/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.JdkBundle;
import com.intellij.util.JdkBundleList;
import com.intellij.util.PlatformUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchBootJdkAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.SwitchBootJdkAction");
    @NonNls
    private static final String productJdkConfigFileName = SwitchBootJdkAction.getExecutable() + ".jdk";
    @NonNls
    private static final File productJdkConfigFile = new File(PathManager.getConfigPath(), productJdkConfigFileName);
    @NonNls
    private static final File bundledJdkFile = SwitchBootJdkAction.getBundledJDKFile();
    private static final String STANDARD_JDK_LOCATION_ON_MAC_OS_X = "/Library/Java/JavaVirtualMachines/";
    private static final String[] STANDARD_JVM_LOCATIONS_ON_LINUX = new String[]{"/usr/lib/jvm/", "/usr/java/"};
    private static final Version JDK8_VERSION = new Version(1, 8, 0);

    @NotNull
    private static File getBundledJDKFile() {
        StringBuilder bundledJDKPath = new StringBuilder("jre");
        if (SystemInfo.isMac) {
            bundledJDKPath.append(File.separator).append("jdk");
        }
        File file2 = new File(bundledJDKPath.toString());
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SwitchBootJdkAction", "getBundledJDKFile"));
        }
        return file2;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!(SystemInfo.isMac || SystemInfo.isLinux && PlatformUtils.isIntelliJ())) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setText("Switch Boot JDK");
    }

    private static List<JdkBundle> getBundlesFromFile(@NotNull File fileWithBundles) {
        if (fileWithBundles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithBundles", "com/intellij/openapi/util/SwitchBootJdkAction", "getBundlesFromFile"));
        }
        ArrayList<JdkBundle> list = new ArrayList<JdkBundle>();
        try {
            for (String line : FileUtil.loadLines((File)fileWithBundles, (String)"UTF-8")) {
                File storedFile = new File(line);
                boolean isBundled = !storedFile.isAbsolute();
                File actualFile = isBundled ? new File(PathManager.getHomePath(), storedFile.getPath()) : storedFile;
                if (!actualFile.exists()) continue;
                list.add(JdkBundle.createBundle(storedFile, false, isBundled));
            }
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error reading JDK bundles", (Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent event) {
        SwitchBootJdkDialog dialog;
        if (!productJdkConfigFile.exists()) {
            try {
                if (!productJdkConfigFile.createNewFile()) {
                    LOG.error("Could not create " + productJdkConfigFileName + " productJdkConfigFile");
                    return;
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        if ((dialog = new SwitchBootJdkDialog(null, SwitchBootJdkAction.getBundlesFromFile(productJdkConfigFile))).showAndGet()) {
            File selectedJdkBundleFile = dialog.getSelectedFile();
            FileWriter fooWriter = null;
            try {
                fooWriter = new FileWriter(productJdkConfigFile, false);
                fooWriter.write(selectedJdkBundleFile.getPath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    if (fooWriter != null) {
                        fooWriter.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            ApplicationManager.getApplication().restart();
        }
    }

    @NotNull
    private static JdkBundleList findJdkPaths() {
        JdkBundle bundledJdk;
        JdkBundle bootJdk = JdkBundle.createBoot();
        JdkBundleList jdkBundleList = new JdkBundleList();
        if (bootJdk != null) {
            jdkBundleList.addBundle(bootJdk, true);
        }
        if (new File(PathManager.getHomePath() + File.separator + bundledJdkFile).exists() && (bundledJdk = JdkBundle.createBundle(bundledJdkFile, false, true)) != null) {
            jdkBundleList.addBundle(bundledJdk, true);
        }
        if (SystemInfo.isMac) {
            jdkBundleList.addBundlesFromLocation(STANDARD_JDK_LOCATION_ON_MAC_OS_X, JDK8_VERSION, null);
        } else if (SystemInfo.isLinux) {
            for (String location : STANDARD_JVM_LOCATIONS_ON_LINUX) {
                jdkBundleList.addBundlesFromLocation(location, JDK8_VERSION, null);
            }
        }
        JdkBundleList jdkBundleList2 = jdkBundleList;
        if (jdkBundleList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SwitchBootJdkAction", "findJdkPaths"));
        }
        return jdkBundleList2;
    }

    @NotNull
    private static String getExecutable() {
        String executable = System.getProperty("idea.executable");
        String string = executable != null ? executable : ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SwitchBootJdkAction", "getExecutable"));
        }
        return string;
    }

    private static class SwitchBootJdkDialog
    extends DialogWrapper {
        @NotNull
        private final ComboBox myComboBox;

        private SwitchBootJdkDialog(@Nullable Project project, final List<JdkBundle> jdkBundlesList) {
            super(project, false);
            final JdkBundleList pathsList = SwitchBootJdkAction.findJdkPaths();
            this.myComboBox = new ComboBox();
            DefaultComboBoxModel<JdkBundle> model = new DefaultComboBoxModel<JdkBundle>();
            for (JdkBundle jdkBundlePath : pathsList.toArrayList()) {
                model.addElement(jdkBundlePath);
            }
            model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    SwitchBootJdkDialog.this.setOKActionEnabled(!((JdkBundle)SwitchBootJdkDialog.this.myComboBox.getSelectedItem()).isBoot());
                }
            });
            this.myComboBox.setModel(model);
            this.myComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value != null) {
                        JdkBundle jdkBundleDescriptor = (JdkBundle)value;
                        if (jdkBundleDescriptor.isBoot()) {
                            this.setForeground((Color)JBColor.DARK_GRAY);
                        }
                        this.setText(jdkBundleDescriptor.getVisualRepresentation());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Null value has been passed to a cell renderer. Available JDKs count: " + pathsList.toArrayList().size());
                        StringBuilder jdkNames = new StringBuilder();
                        for (JdkBundle jdkBundlePath : pathsList.toArrayList()) {
                            if (!jdkBundlesList.isEmpty()) continue;
                            jdkNames.append(jdkBundlePath.getVisualRepresentation()).append("; ");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Available JDKs names: " + jdkNames.toString());
                        }
                    }
                }
            });
            this.setTitle("Switch IDE Boot JDK");
            this.setOKActionEnabled(false);
            this.init();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return new JBLabel("Select Boot JDK");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myComboBox;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        public File getSelectedFile() {
            return ((JdkBundle)this.myComboBox.getSelectedItem()).getLocation();
        }
    }
}

