/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;

public class LimitHistoryCheck {
    private final Project myProject;
    private final String myFilePath;
    private int myLimit;
    private int myCnt;
    private boolean myWarningShown;
    private boolean myOver;

    public LimitHistoryCheck(Project project, String filePath) {
        this.myProject = project;
        this.myFilePath = filePath;
        this.myWarningShown = false;
        this.init();
    }

    private void init() {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myLimit = configuration.LIMIT_HISTORY ? configuration.MAXIMUM_HISTORY_ROWS : -1;
        this.myCnt = 0;
    }

    public void checkNumber() {
        if (this.myLimit <= 0) {
            return;
        }
        ++this.myCnt;
        if (this.isOver()) {
            if (!this.myWarningShown) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "File History: only " + this.myLimit + " revisions were loaded for " + this.myFilePath + "\nTo change the history limit, go to Settings | Version Control.", MessageType.WARNING, new NamedRunnable[0]);
                this.myWarningShown = true;
            }
            throw new ProcessCanceledException();
        }
    }

    public void reset() {
        this.init();
    }

    public boolean isOver() {
        return this.myLimit > 0 && this.myLimit < this.myCnt;
    }
}

