/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDiffUtil {
    public static void showDiffFor(@NotNull Project project, @NotNull Collection<Change> changes, @NotNull String revNumTitle1, @NotNull String revNumTitle2, @NotNull FilePath filePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showDiffFor"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showDiffFor"));
        }
        if (revNumTitle1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revNumTitle1", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showDiffFor"));
        }
        if (revNumTitle2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revNumTitle2", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showDiffFor"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showDiffFor"));
        }
        if (filePath.isDirectory()) {
            VcsDiffUtil.showChangesDialog(project, VcsDiffUtil.getDialogTitle(filePath, revNumTitle1, revNumTitle2), ContainerUtil.newArrayList(changes));
        } else if (changes.isEmpty()) {
            DiffManager.getInstance().showDiff(project, (DiffRequest)new MessageDiffRequest("No Changes Found"));
        } else {
            final HashMap revTitlesMap = new HashMap(2);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, (Object)revNumTitle1);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, (Object)revNumTitle2);
            ShowDiffContext showDiffContext = new ShowDiffContext(){

                @Override
                @NotNull
                public Map<Key, Object> getChangeContext(@NotNull Change change) {
                    if (change == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/history/VcsDiffUtil$1", "getChangeContext"));
                    }
                    HashMap hashMap = revTitlesMap;
                    if (hashMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsDiffUtil$1", "getChangeContext"));
                    }
                    return hashMap;
                }
            };
            ShowDiffAction.showDiffForChange(project, changes, 0, showDiffContext);
        }
    }

    @NotNull
    private static String getDialogTitle(@NotNull FilePath filePath, @NotNull String revNumTitle1, @NotNull String revNumTitle2) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsDiffUtil", "getDialogTitle"));
        }
        if (revNumTitle1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revNumTitle1", "com/intellij/openapi/vcs/history/VcsDiffUtil", "getDialogTitle"));
        }
        if (revNumTitle2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revNumTitle2", "com/intellij/openapi/vcs/history/VcsDiffUtil", "getDialogTitle"));
        }
        String string = String.format("Difference between %s and %s versions in %s", revNumTitle1, revNumTitle2, filePath.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsDiffUtil", "getDialogTitle"));
        }
        return string;
    }

    @NotNull
    public static String getRevisionTitle(@NotNull String revision, boolean localMark) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/VcsDiffUtil", "getRevisionTitle"));
        }
        String string = revision + (localMark ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsDiffUtil", "getRevisionTitle"));
        }
        return string;
    }

    public static void showChangesDialog(@NotNull Project project, @NotNull String title, @NotNull List<Change> changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showChangesDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showChangesDialog"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/history/VcsDiffUtil", "showChangesDialog"));
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(title);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        ChangesBrowser changesBrowser = new ChangesBrowser(project, null, changes, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(changes);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser);
        dialogBuilder.setPreferredFocusComponent(changesBrowser.getPreferredFocusedComponent());
        dialogBuilder.showNotModal();
    }

    @NotNull
    public static List<Change> createChangesWithCurrentContentForFile(@NotNull FilePath filePath, @Nullable ContentRevision beforeContentRevision) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsDiffUtil", "createChangesWithCurrentContentForFile"));
        }
        List<Change> list = Collections.singletonList(new Change(beforeContentRevision, CurrentContentRevision.create((FilePath)filePath)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/VcsDiffUtil", "createChangesWithCurrentContentForFile"));
        }
        return list;
    }
}

