/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import org.jetbrains.annotations.NotNull;

public class BackgroundableActionLock {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object[] myKeys;

    BackgroundableActionLock(@NotNull Project project, @NotNull Object[] keys) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "<init>"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "<init>"));
        }
        this.myProject = project;
        this.myKeys = keys;
    }

    public boolean isLocked() {
        return BackgroundableActionLock.isLocked(this.myProject, this.myKeys);
    }

    public void lock() {
        BackgroundableActionLock.lock(this.myProject, this.myKeys);
    }

    public void unlock() {
        BackgroundableActionLock.unlock(this.myProject, this.myKeys);
    }

    @NotNull
    public static BackgroundableActionLock getLock(@NotNull Project project, Object ... keys) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getLock"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getLock"));
        }
        BackgroundableActionLock backgroundableActionLock = new BackgroundableActionLock(project, keys);
        if (backgroundableActionLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getLock"));
        }
        return backgroundableActionLock;
    }

    public static boolean isLocked(@NotNull Project project, Object ... keys) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "isLocked"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "isLocked"));
        }
        return BackgroundableActionLock.getManager(project).isBackgroundTaskRunning(keys);
    }

    public static void lock(@NotNull Project project, Object ... keys) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "lock"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "lock"));
        }
        BackgroundableActionLock.getManager(project).startBackgroundTask(keys);
    }

    public static void unlock(@NotNull Project project, Object ... keys) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "unlock"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "unlock"));
        }
        BackgroundableActionLock.getManager(project).stopBackgroundTask(keys);
    }

    @NotNull
    private static ProjectLevelVcsManagerImpl getManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getManager"));
        }
        ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project);
        if (projectLevelVcsManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BackgroundableActionLock", "getManager"));
        }
        return projectLevelVcsManagerImpl;
    }
}

