/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementFactoryImpl
extends XmlElementFactory {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(XmlElementFactoryImpl.class);

    public XmlElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull @NonNls CharSequence text, @NotNull Language language) throws IncorrectOperationException {
        XmlDocument document;
        XmlTag tag;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/XmlElementFactoryImpl", "createTagFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/XmlElementFactoryImpl", "createTagFromText"));
        }
        assert (language instanceof XMLLanguage) : "Tag can be created only for xml language";
        LanguageFileType type = language.getAssociatedFileType();
        if (type == null) {
            type = XmlFileType.INSTANCE;
        }
        if ((tag = (document = this.createXmlDocument(text, "dummy." + type.getDefaultExtension(), (FileType)type)).getRootTag()) == null) {
            throw new IncorrectOperationException("Incorrect tag text");
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createTagFromText"));
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull CharSequence text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/XmlElementFactoryImpl", "createTagFromText"));
        }
        XmlTag xmlTag = this.createTagFromText(text, (Language)XMLLanguage.INSTANCE);
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createTagFromText"));
        }
        return xmlTag;
    }

    @NotNull
    public XmlAttribute createXmlAttribute(@NotNull String name, @NotNull String value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/XmlElementFactoryImpl", "createXmlAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/XmlElementFactoryImpl", "createXmlAttribute"));
        }
        XmlAttribute xmlAttribute = this.createAttribute(name, value, (FileType)XmlFileType.INSTANCE);
        if (xmlAttribute == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createXmlAttribute"));
        }
        return xmlAttribute;
    }

    @NotNull
    public XmlAttribute createAttribute(@NotNull @NonNls String name, @NotNull String value, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        XmlAttribute xmlAttribute = this.createAttribute(name, value, (FileType)(PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false) instanceof HtmlTag ? HtmlFileType.INSTANCE : XmlFileType.INSTANCE));
        if (xmlAttribute == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        return xmlAttribute;
    }

    @NotNull
    private XmlAttribute createAttribute(@NotNull String name, @NotNull String value, @NotNull FileType fileType) {
        char quoteChar;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        if (!value.contains("\"")) {
            quoteChar = '\"';
        } else if (!value.contains("'")) {
            quoteChar = '\'';
        } else {
            quoteChar = '\"';
            value = StringUtil.replace((String)value, (String)"\"", (String)"&quot;");
        }
        XmlDocument document = this.createXmlDocument("<tag " + name + "=" + quoteChar + value + quoteChar + "/>", "dummy.xml", fileType);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlAttribute[] attributes = tag.getAttributes();
        LOG.assertTrue(attributes.length == 1, (Object)document.getText());
        XmlAttribute xmlAttribute = attributes[0];
        if (xmlAttribute == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createAttribute"));
        }
        return xmlAttribute;
    }

    @NotNull
    public XmlText createDisplayText(@NotNull String s) throws IncorrectOperationException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/XmlElementFactoryImpl", "createDisplayText"));
        }
        XmlTag tagFromText = this.createTagFromText("<a>" + XmlTagUtil.getCDATAQuote((String)s) + "</a>");
        XmlText[] textElements = tagFromText.getValue().getTextElements();
        if (textElements.length == 0) {
            XmlText xmlText = (XmlText)ASTFactory.composite(XmlElementType.XML_TEXT);
            if (xmlText == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createDisplayText"));
            }
            return xmlText;
        }
        XmlText xmlText = textElements[0];
        if (xmlText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createDisplayText"));
        }
        return xmlText;
    }

    @NotNull
    public XmlTag createXHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/XmlElementFactoryImpl", "createXHTMLTagFromText"));
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.xhtml", (FileType)XHtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createXHTMLTagFromText"));
        }
        return xmlTag;
    }

    @NotNull
    public XmlTag createHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/XmlElementFactoryImpl", "createHTMLTagFromText"));
        }
        XmlDocument document = this.createXmlDocument(text, "dummy.html", (FileType)HtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/XmlElementFactoryImpl", "createHTMLTagFromText"));
        }
        return xmlTag;
    }

    private XmlDocument createXmlDocument(@NonNls CharSequence text, @NonNls String fileName, FileType fileType) {
        XmlFile xmlFile;
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, fileType, text);
        if (fileFromText instanceof XmlFile) {
            xmlFile = (XmlFile)fileFromText;
        } else {
            xmlFile = (XmlFile)fileFromText.getViewProvider().getPsi(((LanguageFileType)fileType).getLanguage());
            assert (xmlFile != null);
        }
        XmlDocument document = xmlFile.getDocument();
        assert (document != null);
        return document;
    }
}

