/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import org.jetbrains.annotations.NotNull;

public class TodoItemImpl
implements TodoItem {
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final TodoPattern myPattern;

    public TodoItemImpl(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull TodoPattern pattern) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/TodoItemImpl", "<init>"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/search/TodoItemImpl", "<init>"));
        }
        this.myFile = file2;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPattern = pattern;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/TodoItemImpl", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = new TextRange(this.myStartOffset, this.myEndOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/TodoItemImpl", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public TodoPattern getPattern() {
        TodoPattern todoPattern = this.myPattern;
        if (todoPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/TodoItemImpl", "getPattern"));
        }
        return todoPattern;
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myStartOffset + this.myEndOffset + this.myPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoItemImpl)) {
            return false;
        }
        TodoItemImpl todoItem = (TodoItemImpl)obj;
        return this.myFile.equals(todoItem.myFile) && this.myStartOffset == todoItem.myStartOffset && this.myEndOffset == todoItem.myEndOffset && this.myPattern.equals((Object)todoItem.myPattern);
    }
}

