/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private static final LowMemoryWatcher ourWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        @Override
        public void run() {
            SmartPointerManagerImpl.processQueue();
        }
    });
    private final Project myProject;
    private final Key<FilePointersList> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        this.POINTERS_KEY = Key.create((String)("SMART_POINTERS for " + project));
    }

    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            FilePointersList pointers = (FilePointersList)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.remove(reference);
        }
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        SmartPointerManagerImpl.processQueue();
        FilePointersList pointers = this.getPointers(file2);
        if (pointers != null) {
            for (Reference<SmartPsiElementPointerImpl> ref : pointers.getReferences()) {
                SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)SoftReference.dereference(ref);
                if (pointer == null) continue;
                pointer.getElementInfo().fastenBelt();
            }
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer != null && pointer.incrementAndGetReferenceCount(1) > 0) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointerImpl;
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference data = (Reference)element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)data);
        if (cachedPointer != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range, false);
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range, boolean forInjected) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file2.isValid()) {
            LOG.error("Invalid element:" + file2);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file2, ProperTextRange.create((Segment)range), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        block4: {
            FilePointersList pointers;
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
            }
            SmartPointerElementInfo info = pointer.getElementInfo();
            if (!(info instanceof SelfElementInfo)) {
                return;
            }
            do {
                if ((pointers = this.getPointers(containingFile)) != null) continue;
                pointers = (FilePointersList)containingFile.putUserDataIfAbsent(this.POINTERS_KEY, (Object)new FilePointersList());
            } while (!pointers.add(new PointerReference(pointer, containingFile, SmartPointerManagerImpl.ourQueue, this.POINTERS_KEY)));
            if (!((SelfElementInfo)info).hasRange()) break block4;
            pointers.markerCache.rangeChanged();
        }
    }

    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        PsiFile containingFile = pointer.getContainingFile();
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            if (containingFile == null) {
                return;
            }
            VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
            FilePointersList pointers = this.getPointers(vFile);
            if (pointers == null) {
                return;
            }
            pointers.remove(pointer);
        }
    }

    @Nullable
    private FilePointersList getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return (FilePointersList)containingFile.getUserData(this.POINTERS_KEY);
    }

    @Nullable
    MarkerCache getMarkerCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        FilePointersList pointers = this.getPointers(file2);
        return pointers == null ? null : pointers.markerCache;
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        VirtualFile file2 = containingFile.getViewProvider().getVirtualFile();
        FilePointersList pointers = this.getPointers(file2);
        return pointers == null ? 0 : pointers.getSize();
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        FilePointersList list;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        FilePointersList filePointersList = list = file2 == null ? null : this.getPointers(file2);
        if (list == null) {
            return;
        }
        list.markerCache.updateMarkers(frozen, events);
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTargetsAfterReparse"));
        }
        FilePointersList list = this.getPointers(file2);
        if (list == null) {
            return;
        }
        for (SmartPsiElementPointerImpl pointer : list.getAlivePointers()) {
            if (pointer instanceof SmartPsiFileRangePointerImpl) continue;
            SmartPointerManagerImpl.updatePointerTarget(pointer, pointer.getPsiRange());
        }
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        E newTarget = pointer.doRestoreElement();
        if (newTarget != null) {
            pointer.cacheElement(newTarget);
        }
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }

    static class FilePointersList {
        private int nextAvailableIndex;
        private int size;
        private PointerReference[] references = new PointerReference[10];
        private final MarkerCache markerCache = new MarkerCache(this);
        private boolean mySorted;

        FilePointersList() {
        }

        private synchronized boolean add(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "add"));
            }
            if (reference.file.getUserData(reference.key) != this) {
                return false;
            }
            if (this.nextAvailableIndex >= this.references.length || this.nextAvailableIndex > this.size * 2) {
                int newCapacity = this.nextAvailableIndex >= this.references.length ? this.references.length * 3 / 2 + 1 : this.size * 3 / 2 + 1;
                PointerReference[] newReferences = new PointerReference[newCapacity];
                int o = 0;
                for (PointerReference oldRef : this.references) {
                    if (SoftReference.dereference((Reference)oldRef) == null) continue;
                    newReferences[o++] = oldRef;
                }
                this.references = newReferences;
                this.size = this.nextAvailableIndex = o;
            }
            this.references[this.nextAvailableIndex++] = reference;
            ++this.size;
            this.mySorted = false;
            return true;
        }

        private synchronized void remove(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            int index = ArrayUtil.indexOf((Object[])this.references, (Object)reference);
            if (index != -1) {
                this.removeReference(reference, index);
            }
        }

        private synchronized void remove(@NotNull SmartPsiElementPointer smartPointer) {
            if (smartPointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartPointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            for (int i = 0; i < this.references.length; ++i) {
                PointerReference reference = this.references[i];
                if (reference == null || reference.get() != smartPointer) continue;
                this.removeReference(reference, i);
                return;
            }
        }

        private void removeReference(@NotNull PointerReference reference, int index) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "removeReference"));
            }
            this.references[index] = null;
            if (--this.size == 0) {
                reference.file.replace(reference.key, (Object)this, null);
            }
        }

        Reference<SmartPsiElementPointerImpl>[] getReferences() {
            return this.references;
        }

        synchronized List<SelfElementInfo> getSortedInfos() {
            if (!this.mySorted) {
                ArrayList hardRefs = ContainerUtil.newArrayListWithCapacity((int)this.size);
                for (int i = 0; i < this.references.length; ++i) {
                    PointerReference reference = this.references[i];
                    if (reference == null) continue;
                    SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)reference.get();
                    if (pointer != null) {
                        hardRefs.add(pointer);
                        continue;
                    }
                    this.removeReference(reference, i);
                    if (this.size != 0) continue;
                    return Collections.emptyList();
                }
                assert (this.size == hardRefs.size());
                Arrays.sort(this.references, 0, this.nextAvailableIndex, new Comparator<PointerReference>(){

                    @Override
                    public int compare(PointerReference o1, PointerReference o2) {
                        SmartPsiElementPointerImpl p1 = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)o1);
                        SmartPsiElementPointerImpl p2 = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)o2);
                        if (p1 == null || p2 == null) {
                            return p1 != null ? -1 : (p2 != null ? 1 : 0);
                        }
                        return MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo());
                    }
                });
                this.nextAvailableIndex = hardRefs.size();
                this.mySorted = true;
            }
            ArrayList infos = ContainerUtil.newArrayListWithCapacity((int)this.size);
            for (PointerReference reference : this.references) {
                SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)reference);
                if (pointer == null) continue;
                SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
                if (!info.hasRange()) break;
                infos.add(info);
            }
            return infos;
        }

        int getSize() {
            return this.size;
        }

        @NotNull
        List<SmartPsiElementPointerImpl> getAlivePointers() {
            List list = ContainerUtil.mapNotNull((Object[])this.references, (Function)new Function<PointerReference, SmartPsiElementPointerImpl>(){

                public SmartPsiElementPointerImpl fun(PointerReference reference) {
                    return (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)reference);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "getAlivePointers"));
            }
            return list;
        }

        synchronized void markUnsorted() {
            this.mySorted = false;
        }
    }

    private static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<FilePointersList> key;

        private PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull ReferenceQueue<SmartPsiElementPointerImpl> queue, @NotNull Key<FilePointersList> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            super(pointer, queue);
            this.file = containingFile;
            this.key = key;
        }
    }
}

