/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParser;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentFormatter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter");
    private final CodeStyleSettings mySettings;
    private final JDParser myParser;
    private final Project myProject;

    public CommentFormatter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "<init>"));
        }
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)project);
        this.myParser = new JDParser(this.mySettings);
        this.myProject = project;
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public JDParser getParser() {
        return this.myParser;
    }

    public void processComment(@Nullable ASTNode element) {
        if (!this.getSettings().ENABLE_JAVADOC_FORMATTING) {
            return;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
        if (psiElement != null) {
            this.getParser().formatCommentText(psiElement, this);
        }
    }

    public void replaceCommentText(@Nullable String newCommentText, @Nullable PsiDocComment oldComment) {
        if (newCommentText != null) {
            newCommentText = CommentFormatter.stripSpaces(newCommentText);
        }
        if (newCommentText == null || oldComment == null || newCommentText.equals(oldComment.getText())) {
            return;
        }
        try {
            PsiComment newComment = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createCommentFromText(newCommentText, null);
            ASTNode oldNode = oldComment.getNode();
            ASTNode newNode = newComment.getNode();
            assert (oldNode != null && newNode != null);
            ASTNode parent = oldNode.getTreeParent();
            parent.replaceChild(oldNode, newNode);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String stripSpaces(String text) {
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false);
        StringBuilder buf = new StringBuilder(text.length());
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(CommentFormatter.rTrim(lines[i]));
        }
        return buf.toString();
    }

    private static String rTrim(String text) {
        int idx;
        for (idx = text.length(); idx > 0 && Character.isWhitespace(text.charAt(idx - 1)); --idx) {
        }
        return text.substring(0, idx);
    }

    @Nullable
    public static JDParser.CommentInfo getOrigCommentInfo(PsiDocCommentOwner element) {
        PsiElement e = element.getFirstChild();
        if (!(e instanceof PsiComment)) {
            return null;
        }
        return CommentFormatter.getCommentInfo((PsiComment)e);
    }

    @Nullable
    public static JDParser.CommentInfo getCommentInfo(PsiComment element) {
        String commentHeader = null;
        String commentFooter = null;
        StringBuilder sb = new StringBuilder();
        PsiComment e = element;
        boolean first = true;
        while (true) {
            if (e instanceof PsiDocComment) {
                PsiComment cm = e;
                String text = cm.getText();
                if (text.startsWith("//")) {
                    if (!first) {
                        sb.append('\n');
                    }
                    sb.append(text.substring(2).trim());
                } else if (text.startsWith("/*")) {
                    int commentFooterStartOffset;
                    int commentHeaderEndOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)1, (String)"*");
                    if (commentHeaderEndOffset <= (commentFooterStartOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(text.length() - 2), (String)"*"))) {
                        commentHeader = text.substring(0, commentHeaderEndOffset);
                        commentFooter = text.substring(commentFooterStartOffset + 1);
                        text = text.substring(commentHeaderEndOffset, commentFooterStartOffset + 1);
                    } else {
                        commentHeader = text.substring(0, commentHeaderEndOffset);
                        text = "";
                        commentFooter = "";
                    }
                    sb.append(text);
                }
            } else if (!(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)) break;
            first = false;
            e = e.getNextSibling();
        }
        return new JDParser.CommentInfo(commentHeader, sb.toString(), commentFooter);
    }

    private int getIndentSpecial(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "getIndentSpecial"));
        }
        if (element instanceof PsiDocComment) {
            return 0;
        }
        LOG.assertTrue(element instanceof PsiClass || element instanceof PsiField || element instanceof PsiMethod);
        int indentSize = this.mySettings.getIndentSize((FileType)JavaFileType.INSTANCE);
        boolean doNotIndentTopLevelClassMembers = this.mySettings.getCommonSettings((Language)JavaLanguage.INSTANCE).DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS;
        int indent = 0;
        PsiClass top = PsiUtil.getTopLevelClass((PsiElement)element);
        while (!(top == null || element.isEquivalentTo((PsiElement)top) || doNotIndentTopLevelClassMembers && element.getParent().isEquivalentTo((PsiElement)top))) {
            element = element.getParent();
            indent += indentSize;
        }
        return indent;
    }

    @NotNull
    public String getIndent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "getIndent"));
        }
        String string = StringUtil.repeatSymbol((char)' ', (int)this.getIndentSpecial(element));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "getIndent"));
        }
        return string;
    }
}

