/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance((String)("#" + InferenceSession.class.getName()));
    public static final Key<PsiType> LOWER_BOUND = Key.create((String)"LowBound");
    public static final Key<PsiType> UPPER_BOUND = Key.create((String)"UpperBound");
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create((String)"ORIGINAL_CONTEXT");
    private static final Key<Boolean> ERASED = Key.create((String)"UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        public PsiType fun(Pair<PsiType, PsiType> pair) {
            if (pair.first instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)((PsiArrayType)pair.first), (PsiType)((PsiType)pair.second))) {
                return null;
            }
            if (pair.second instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)((PsiArrayType)pair.second), (PsiType)((PsiType)pair.first))) {
                return null;
            }
            if (pair.first instanceof PsiCapturedWildcardType && TypesDistinctProver.provablyDistinct((PsiType)((PsiCapturedWildcardType)pair.first).getUpperBound(), (PsiType)((PsiType)pair.second))) {
                return null;
            }
            if (pair.second instanceof PsiCapturedWildcardType && TypesDistinctProver.provablyDistinct((PsiType)((PsiCapturedWildcardType)pair.second).getUpperBound(), (PsiType)((PsiType)pair.first))) {
                return null;
            }
            return GenericsUtil.getGreatestLowerBound((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second));
        }
    };
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private InferenceSessionContainer myInferenceSessionContainer = new InferenceSessionContainer();
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx = 0;
    private List<String> myErrorMessages;
    private boolean myErased = false;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;

    public InferenceSession(InitialInferenceState initialState) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<PsiTypeParameter[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((PsiTypeParameter[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null || leftTypes[i] == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(leftTypes[i]), this.substituteWithInferenceVariables(rightType)));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        this.initExpressionConstraints(parameters, args, parent, method, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, i, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables((PsiType)thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent) {
        if (parent instanceof PsiCall) {
            return MethodCandidateInfo.getCurrentMethod((PsiElement)((PsiCall)parent).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expr.getParent());
            PsiType paramType = null;
            if (parent instanceof PsiExpressionList) {
                PsiElement gParent = parent.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)parent), (PsiElement)expr);
                    if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && parent instanceof PsiLambdaExpression) {
                if (InferenceSession.isTypeParameterType((PsiTypeParameterListOwner)method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)expr))) {
                    if (InferenceSession.isPertinentToApplicability(expression, method, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getTypeParameterOwner"));
        }
        PsiMethod owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondTypeUtil.hasDiamond((PsiNewExpression)gParent)) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, int i, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        PsiType parameterType;
        if (substitutor == null) {
            return null;
        }
        PsiParameter parameter = parameters[i < parameters.length ? i : parameters.length - 1];
        PsiType type = parameter.getType();
        if (!type.isValid()) {
            PsiUtil.ensureValidType((PsiType)type, (String)("Invalid type of parameter " + parameter + " of " + parameter.getClass()));
        }
        if ((parameterType = substitutor.substitute(type)) instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor collectAdditionalAndInfer(@NotNull PsiParameter[] parameters, @NotNull PsiExpression[] args, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor psiSubstitutor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (psiSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        return this.performGuardedInference(parameters, args, this.myContext, properties, psiSubstitutor);
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters, args, parent, InferenceSession.getCurrentProperties(parent));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties) {
        PsiSubstitutor psiSubstitutor = this.performGuardedInference(parameters, args, parent, properties, PsiSubstitutor.EMPTY);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiSubstitutor performGuardedInference(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "performGuardedInference"));
        }
        this.doInfer(parameters, args, parent, properties, initialSubstitutor);
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
        if (psiSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "performGuardedInference"));
        }
        return psiSubstitutor2;
        finally {
            for (ConstraintFormula formula : this.myConstraintsCopy) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                LambdaUtil.getFunctionalTypeMap().remove(((InputOutputConstraintFormula)formula).getExpression());
            }
            if (properties != null && this.myErrorMessages != null) {
                properties.getInfo().setInferenceError(StringUtil.join(this.myErrorMessages, (String)"\n"));
            }
        }
    }

    private void doInfer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull PsiSubstitutor initialSubstitutor) {
        PsiSubstitutor substitutor;
        if (initialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "doInfer"));
        }
        if (!this.repeatInferencePhases(true)) {
            return;
        }
        if (properties != null && !properties.isApplicabilityCheck()) {
            this.initReturnTypeConstraint(properties.getMethod(), (PsiCall)parent);
            if (!this.repeatInferencePhases(true)) {
                return;
            }
            if (parameters != null && args != null) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                if (parameters.length > 0) {
                    this.collectAdditionalConstraints(parameters, args, properties.getMethod(), this.mySiteSubstitutor, additionalConstraints, properties.isVarargs(), initialSubstitutor);
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints)) {
                    return;
                }
            }
        }
        if ((substitutor = this.resolveBounds(this.myInferenceVariables, initialSubstitutor)) != null) {
            if (this.myContext != null) {
                this.myContext.putUserData(ERASED, (Object)this.myErased);
            }
            Map map = substitutor.getSubstitutionMap();
            for (PsiTypeParameter parameter : map.keySet()) {
                PsiTypeParameter param;
                PsiType mapping = (PsiType)map.get(parameter);
                if (parameter instanceof InferenceVariable) {
                    ((InferenceVariable)parameter).setInstantiation(mapping);
                    if (((InferenceVariable)parameter).getCallContext() != this.myContext) continue;
                    param = ((InferenceVariable)parameter).getParameter();
                } else {
                    param = parameter;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping);
            }
        }
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[i]);
            if (arg == null) continue;
            if (MethodCandidateInfo.isOverloadCheck() && arg instanceof PsiLambdaExpression) {
                for (Object expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                    if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PsiLambdaExpression.class) != arg) continue;
                    return;
                }
            }
            InferenceSession nestedCallSession = this.myInferenceSessionContainer.findNestedCallSession((PsiElement)arg, this);
            PsiType parameterType = nestedCallSession.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)arg);
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, (PsiCall)arg, initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)arg, parameterType, !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    public static PsiMethod getCalledMethod(PsiCall arg) {
        PsiExpressionList argumentList = arg.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
        if (properties != null) {
            return properties.getMethod();
        }
        JavaResolveResult resolveResult = InferenceSession.getResolveResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)parameterType);
        if (interfaceReturnType != null) {
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, returnExpression, interfaceReturnType, addConstraint, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiExpression returnExpression, PsiType functionalType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        if (returnExpression instanceof PsiCallExpression) {
            if (addConstraint) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)((PsiCallExpression)returnExpression));
                if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                    this.collectAdditionalConstraints(additionalConstraints, (PsiCall)((PsiCallExpression)returnExpression), initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType, addConstraint, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)returnExpression, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result2;
            MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
            JavaResolveResult javaResolveResult = result2 = properties != null ? null : InferenceSession.getResolveResult(callExpression);
            Object object = properties != null ? properties.getMethod() : (method = result2 instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result2).getElement() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, InferenceSession.chooseSiteSubstitutor(properties, result2, method), additionalConstraints, InferenceSession.chooseVarargsMode(properties, result2), initialSubstitutor);
                }
            }
        }
    }

    public static JavaResolveResult getResolveResult(final PsiCall callExpression) {
        if (callExpression instanceof PsiNewExpression && PsiDiamondTypeUtil.hasDiamond((PsiNewExpression)callExpression)) {
            PsiUtilCore.ensureValid((PsiElement)callExpression);
            return (JavaResolveResult)CachedValuesManager.getCachedValue((PsiElement)callExpression, (CachedValueProvider)new CachedValueProvider<JavaResolveResult>(){

                @Nullable
                public CachedValueProvider.Result<JavaResolveResult> compute() {
                    PsiElement psiClass;
                    PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)callExpression).getClassOrAnonymousClassReference();
                    JavaResolveResult constructor = JavaResolveResult.EMPTY;
                    JavaResolveResult resolveResult = null;
                    if (classReference != null && (psiClass = (resolveResult = classReference.advancedResolve(false)).getElement()) != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)callExpression.getProject());
                        PsiExpressionList argumentList = callExpression.getArgumentList();
                        if (argumentList != null) {
                            constructor = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType((PsiClass)psiClass).rawType(), argumentList, (PsiElement)callExpression);
                        }
                    }
                    return new CachedValueProvider.Result((Object)(constructor.getElement() == null && resolveResult != null ? resolveResult : constructor), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            });
        }
        return callExpression.resolveMethodGenerics();
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs();
    }

    public PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound == null || PsiType.NULL.equals((Object)equalsBound)) continue;
            substitutor = substitutor.put((PsiTypeParameter)variable, equalsBound);
        }
        return substitutor;
    }

    private PsiSubstitutor prepareSubstitution() {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(this.myInferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> variables = InferenceVariablesOrder.resolveOrder(allVars, this);
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable);
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, (PsiType)JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType((PsiClass)typeParameter));
            }
            allVars.removeAll(variables);
        }
        return this.mySiteSubstitutor;
    }

    public InitialInferenceState createInitialState() {
        return new InitialInferenceState(this.myInferenceVariables, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myInferenceSessionContainer);
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result2 = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter : typeParameters) {
            InferenceVariable variable = new InferenceVariable(context, parameter);
            result2.add(variable);
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)variable));
        }
        for (InferenceVariable variable : result2) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiClassType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType((PsiType)(classType = this.substituteWithInferenceVariables(this.mySiteSubstitutor.substitute((PsiType)classType))))) {
                    added = true;
                }
                variable.addBound((PsiType)classType, InferenceBound.UPPER);
            }
            if (added) continue;
            variable.addBound((PsiType)PsiType.getJavaLangObject((PsiManager)parameter.getManager(), (GlobalSearchScope)parameter.getResolveScope()), InferenceBound.UPPER);
        }
        this.myInferenceVariables.addAll(result2);
        return result2.toArray(new InferenceVariable[result2.size()]);
    }

    private void initReturnTypeConstraint(PsiMethod method, PsiCall context) {
        PsiType targetType;
        PsiType returnType;
        if (context instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)context, method) && !PsiType.VOID.equals((Object)(returnType = method.getReturnType())) && returnType != null && (targetType = InferenceSession.getTargetTypeFromParent((PsiElement)context, false)) != null && !PsiType.VOID.equals((Object)targetType)) {
            this.registerReturnTypeConstraints(PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
        }
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType = this.substituteWithInferenceVariables(returnType), targetType);
        if (inferenceVariable != null) {
            PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
            PsiType substitutedReturnType = substitutor.substitute(inferenceVariable.getParameter());
            if (substitutedReturnType != null) {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards((PsiType)substitutedReturnType, (PsiElement)this.myContext)));
            }
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)returnType, (PsiElement)this.myContext);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiTypeParameter[] copy = this.initBounds((PsiElement)null, typeParameters);
                PsiType[] parameters = substitutedCapture.getParameters();
                PsiType[] newParameters = new PsiType[parameters.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
                for (int i = 0; i < parameters.length; ++i) {
                    newParameters[i] = parameters[i];
                    if (!(parameters[i] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i] = elementFactory.createType((PsiClass)copy[i]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy, substitutedCapture);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, (PsiType)substitutedCapture));
            }
        } else {
            this.addConstraint(new TypeCompatibilityConstraint(targetType, this.myErased ? TypeConversionUtil.erasure((PsiType)returnType) : returnType));
        }
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (this.myErased || InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType((PsiType)bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion((PsiType)targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized((PsiType)targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second));
                }
            }) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        return InferenceSession.getTargetTypeFromParent(context, true);
    }

    private static PsiType getTargetTypeFromParent(PsiElement context, boolean inferParent) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList = ((PsiCall)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
                if (properties != null && properties.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList, (PsiElement)properties.getMethod(), properties.isVarargs(), properties.getSubstitutor());
                }
                if (inferParent) {
                    JavaResolveResult result2 = ((PsiCall)gParent).resolveMethodGenerics();
                    boolean varargs = result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isVarargs();
                    return InferenceSession.getTypeByMethod(context, argumentList, result2.getElement(), varargs, result2.getSubstitutor());
                }
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent, inferParent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent, inferParent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class}), inferParent);
            }
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent((PsiElement)lambdaExpression, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, lambdaExpression));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp((PsiElement)lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiElement context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            Object[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find((Object[])args, (Object)arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = InferenceSession.getParameterType(parameters, i, substitutor, varargs);
            boolean isRaw = substitutor != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((PsiMethod)parentMethod), (PsiSubstitutor)substitutor);
            return isRaw ? TypeConversionUtil.erasure((PsiType)parameterType) : parameterType;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        if (psiClass instanceof InferenceVariable) {
            return (InferenceVariable)psiClass;
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = (Boolean)type.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Nullable
            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }

            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return (Boolean)bound.accept((PsiTypeVisitor)this);
            }

            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable((PsiType)classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases(boolean incorporate) {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (!incorporate || this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (incorporate && !this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor = substitutor.put((PsiTypeParameter)dependency, instantiation);
        }
        return substitutor.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            if (GenericsUtil.findTypeParameterBoundError((PsiTypeParameter)typeParameter, (PsiType[])(bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()])), (PsiSubstitutor)substitutor, (PsiElement)this.myContext, (boolean)true) == null) continue;
            return true;
        }
        return false;
    }

    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor) {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            if (!this.myIncorporationPhase.hasCaptureConstraints(vars)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor);
                if (this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor, vars)) {
                return null;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases(true)) continue;
            return null;
        }
        return substitutor;
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor, List<InferenceVariable> vars) {
        int i;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(InferenceSession.getFreshVariableName(var), (PsiElement)parameter);
            ySubstitutor = ySubstitutor.put((PsiTypeParameter)var, (PsiType)elementFactory.createType((PsiClass)yVars[i]));
        }
        for (i = 0; i < yVars.length; ++i) {
            PsiTypeParameter parameter = yVars[i];
            InferenceVariable var = vars.get(i);
            PsiType lub = this.getLowerBound(var, substitutor);
            if (lub != PsiType.NULL) {
                for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable((PsiType)upperBoundType, (PsiType)lub)) continue;
                    return false;
                }
                parameter.putUserData(LOWER_BOUND, (Object)lub);
            }
            parameter.putUserData(UPPER_BOUND, (Object)this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor), true));
            parameter.putUserData(ORIGINAL_CONTEXT, (Object)this.myContext);
            if (var.addBound((PsiType)elementFactory.createType((PsiClass)parameter), InferenceBound.EQ)) continue;
            return false;
        }
        return true;
    }

    private static String getFreshVariableName(InferenceVariable var) {
        return var.getName();
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor = siteSubstitutor;
        HashSet<InferenceVariable> copy = new HashSet<InferenceVariable>(varsToResolve);
        while (!copy.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(copy, this);
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor);
            copy.removeAll(vars);
            substitutor = substitutor.putAll(resolveSubset);
        }
        return substitutor;
    }

    @NotNull
    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type = instantiation == PsiType.NULL ? this.checkBoundsConsistency(substitutor, var) : instantiation;
            if (type == PsiType.NULL) continue;
            substitutor = substitutor.put((PsiTypeParameter)var, type);
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "resolveSubset"));
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor, InferenceVariable var) {
        PsiType type;
        PsiType eqBound = this.getEqualsBound(var, substitutor);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor);
        PsiType upperBound = this.getUpperBound(var, substitutor);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable((PsiType)eqBound, (PsiType)lowerBound)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION);
                return this.registerIncompatibleErrorMessage(var, incompatibleBoundsMessage);
            }
            type = eqBound;
        } else {
            type = lowerBound;
        }
        if (type == PsiType.NULL) {
            String conflictingConjunctsMessage;
            if (var.isThrownBound() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type = PsiType.getJavaLangRuntimeException((PsiManager)this.myManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            } else {
                PsiType psiType = type = this.myErased ? null : upperBound;
            }
            if (type instanceof PsiIntersectionType && (conflictingConjunctsMessage = ((PsiIntersectionType)type).getConflictingConjunctsMessage()) != null) {
                return this.registerIncompatibleErrorMessage(var, "Type parameter " + var.getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (!this.isProperType(upperType)) continue;
                String incompatibleBoundsMessage = null;
                if (type != lowerBound && !TypeConversionUtil.isAssignable((PsiType)substitutor.substitute(upperType), (PsiType)type)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                } else if (type == lowerBound && !TypeConversionUtil.isAssignable((PsiType)substitutor.substitute(upperType), (PsiType)lowerBound)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                }
                if (incompatibleBoundsMessage == null) continue;
                return this.registerIncompatibleErrorMessage(var, incompatibleBoundsMessage);
            }
        }
        return type;
    }

    private PsiType registerIncompatibleErrorMessage(InferenceVariable var, @NotNull String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleBoundsMessage", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "registerIncompatibleErrorMessage"));
        }
        if (var.getCallContext() == this.myContext) {
            this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
        }
        return PsiType.NULL;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables, String incompatibleTypesMessage) {
        String variablesEnumeration = StringUtil.join(variables, (Function)new Function<InferenceVariable, String>(){

            public String fun(InferenceVariable variable) {
                return variable.getName();
            }
        }, (String)", ");
        this.registerIncompatibleErrorMessage("no instance(s) of type variable(s) " + variablesEnumeration + " exist so that " + incompatibleTypesMessage);
    }

    public void registerIncompatibleErrorMessage(@NotNull String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleBoundsMessage", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "registerIncompatibleErrorMessage"));
        }
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, final PsiSubstitutor substitutor, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = new Function<PsiType, String>(){

            public String fun(PsiType type) {
                PsiType substituted = InferenceSession.this.substituteNonProperBound(type, substitutor);
                return (substituted != null ? substituted : type).getPresentableText();
            }
        };
        return "inference variable " + var.getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), (Function)typePresentation, (String)", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), (Function)typePresentation, (String)", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second), (PsiManager)InferenceSession.this.myManager);
            }
        }, substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return !Comparing.equal((Object)pair.first, (Object)pair.second) ? null : (PsiType)pair.first;
            }
        }, substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiPrimitiveType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair pair = Pair.create((Object)lub, (Object)lowerBound);
            if ((lub = (PsiType)fun.fun((Object)pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope((Project)this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, siteSubstitutor, varsToResolve, additionalConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, PsiSubstitutor siteSubstitutor, Set<InferenceVariable> varsToResolve, Set<ConstraintFormula> additionalConstraints) {
        PsiExpression expression;
        PsiSubstitutor substitutor = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
        if (this.myContext instanceof PsiCall) {
            PsiExpressionList argumentList = ((PsiCall)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor((PsiElement)argumentList, (PsiSubstitutor)substitutor);
        }
        formula.apply(substitutor, true);
        this.addConstraint(formula);
        if (!this.repeatInferencePhases(true)) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getT(), (PsiLambdaExpression)expression);
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)expression, parameterType, !this.isProperType(parameterType), substitutor);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints) {
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : additionalConstraints) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        if (inputVariable.hasInstantiation(this)) continue;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            for (InferenceVariable outputVariable : outputVariables) {
                                if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
                                dependsOnOutput = true;
                                break;
                            }
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            subset.add(additionalConstraints.iterator().next());
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block11: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block10: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                LOG.assertTrue(interfaceMethod != null, (Object)this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                PsiParameter[] functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block10;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)methodContainingClass, (PsiClass)containingClass, (PsiSubstitutor)psiSubstitutor)) != null, (Object)("derived: " + containingClass + "; super: " + methodContainingClass));
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards((PsiType)pType, (PsiElement)reference)));
                }
                break block11;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)reference, (MethodSignature)signature, (boolean)varargs, (boolean)isStatic, (int)parameters.length)) break block11;
            PsiType pType = signature.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                PsiType normalizedPType = PsiUtil.captureToplevelWildcards((PsiType)pType, (PsiElement)this.myContext);
                PsiSubstitutor receiverSubstitutor = PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(containingClass, normalizedPType);
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)receiverSubstitutor))) {
                        return receiverSubstitutor;
                    }
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                    psiSubstitutor = receiverSubstitutor;
                }
            } else if (methodContainingClass != null) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)methodContainingClass, (PsiClass)containingClass, (PsiSubstitutor)psiSubstitutor)) != null, (Object)("derived: " + containingClass + "; super: " + methodContainingClass));
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables((PsiType)qType), pType));
            for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards((PsiType)interfaceParamType, (PsiElement)reference)));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)m2)) {
            params.add(param);
        }
        siteSubstitutor1 = InferenceSession.getSiteSubstitutor(siteSubstitutor1, params);
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : parameters1.length - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, siteSubstitutor1, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, siteSubstitutor1, varargs));
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable((PsiType)tType, (PsiType)sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases(true);
    }

    private static PsiSubstitutor getSiteSubstitutor(PsiSubstitutor siteSubstitutor1, List<PsiTypeParameter> params) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter param : params) {
            subst = subst.put(param, siteSubstitutor1.substitute(param));
        }
        return subst;
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType((PsiType)capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)sInterfaceMethod, (PsiClassType.ClassResolveResult)sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType((PsiType)tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)tInterfaceMethod, (PsiClassType.ClassResolveResult)tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals((Object)tReturnType)) {
                return true;
            }
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)arg));
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType((PsiType)sReturnType) && LambdaUtil.isFunctionalType((PsiType)tReturnType) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)sReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)tReturnType)) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)tReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length, (Object)("s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText()));
            for (int i = 0; i < tParameters.length; ++i) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal((Object)tSubstituted, (Object)sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals((Object)tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, (Object)arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure((PsiType)tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure((PsiType)sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable((PsiType)sConjunctErasure, (PsiType)erasedType);
                subRelation |= TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure((PsiType)sType)) != null) {
            return TypeConversionUtil.isAssignable((PsiType)sTypeErasure, (PsiType)erasedType) || TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        Boolean erased = (Boolean)call.getUserData(ERASED);
        return erased != null && erased != false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables) {
        this.myInferenceVariables.addAll(variables);
    }

    public PsiType substituteWithInferenceVariables(PsiType type) {
        return this.myInferenceSubstitution.substitute(type);
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)variable.getParameter()));
        }
        return s.substitute(type);
    }

    public static boolean areSameFreshVariables(PsiTypeParameter p1, PsiTypeParameter p2) {
        PsiElement originalContext = (PsiElement)p1.getUserData(ORIGINAL_CONTEXT);
        return originalContext != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public static boolean isFreshVariable(PsiTypeParameter typeParameter) {
        return typeParameter.getUserData(ORIGINAL_CONTEXT) != null;
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds, Processor<Pair<PsiType, PsiType>> processor2) {
        for (int i = 0; i < upperBounds.size(); ++i) {
            PsiType sBound = upperBounds.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)sBound);
            if (sClass == null) continue;
            LinkedHashSet superClasses = InheritanceUtil.getSuperClasses((PsiClass)sClass);
            superClasses.add(sClass);
            for (int j = i + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)tBound);
                if (tClass == null) continue;
                LinkedHashSet tSupers = InheritanceUtil.getSuperClasses((PsiClass)tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)sBound));
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)tBound));
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substitute(typeParameter);
                        Pair typePair = Pair.create((Object)sType, (Object)(tType = tSubstitutor.substitute(typeParameter)));
                        if (processor2.process((Object)typePair)) continue;
                        return gClass;
                    }
                }
            }
        }
        return null;
    }

    public void registerSiteSubstitutor(PsiSubstitutor substitutor) {
        this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(substitutor);
    }

    public List<String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }
}

