/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class StubProcessingHelperBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubProcessingHelperBase");

    private static IElementType stubType(@NotNull StubElement<?> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/stubs/StubProcessingHelperBase", "stubType"));
        }
        if (stub instanceof PsiFileStub) {
            return ((PsiFileStub)stub).getType();
        }
        return stub.getStubType();
    }

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull StubIdList value, @NotNull Processor<? super Psi> processor2, @NotNull Class<Psi> requiredClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        return this.processStubsInFile(project, file2, value, processor2, requiredClass, false);
    }

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull StubIdList value, @NotNull Processor<? super Psi> processor2, @NotNull Class<Psi> requiredClass, boolean skipOnErrors) {
        FileViewProvider viewProvider;
        PsiFile stubBindingRoot;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        if (requiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClass", "com/intellij/psi/stubs/StubProcessingHelperBase", "processStubsInFile"));
        }
        StubTree stubTree = null;
        PsiFile candidatePsiFile = PsiManager.getInstance((Project)project).findFile(file2);
        PsiFileWithStubSupport psiFile = null;
        boolean customStubs = false;
        if (candidatePsiFile != null && !(candidatePsiFile instanceof PsiPlainTextFile) && (stubBindingRoot = (viewProvider = candidatePsiFile.getViewProvider()).getStubBindingRoot()) instanceof PsiFileWithStubSupport && (stubTree = (psiFile = (PsiFileWithStubSupport)stubBindingRoot).getStubTree()) == null && psiFile instanceof PsiFileImpl) {
            IStubFileElementType elementType = ((PsiFileImpl)psiFile).getElementTypeForStubBuilder();
            if (elementType != null) {
                stubTree = ((PsiFileImpl)psiFile).calcStubTree();
            } else {
                customStubs = true;
                if (BinaryFileStubBuilders.INSTANCE.forFileType(psiFile.getFileType()) == null) {
                    LOG.error("unable to get stub builder for " + psiFile.getFileType() + ", " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
                }
            }
        }
        if (stubTree == null && psiFile == null) {
            return true;
        }
        if (stubTree == null) {
            ObjectStubTree objectStubTree = StubTreeLoader.getInstance().readFromVFile(project, file2);
            if (objectStubTree == null) {
                return true;
            }
            if (customStubs && !(objectStubTree instanceof StubTree)) {
                if (!skipOnErrors && !requiredClass.isInstance(psiFile)) {
                    this.inconsistencyDetected(objectStubTree, psiFile);
                    return true;
                }
                return processor2.process((Object)psiFile);
            }
            stubTree = (StubTree)objectStubTree;
            List<StubElement<?>> plained = stubTree.getPlainListFromAllRoots();
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                int stubTreeIndex = value.get(i);
                if (stubTreeIndex >= plained.size()) {
                    if (skipOnErrors) break;
                    this.onInternalError(file2);
                    break;
                }
                StubElement<?> stub = plained.get(stubTreeIndex);
                PsiUtilCore.ensureValid((PsiElement)psiFile);
                ASTNode tree = psiFile.findTreeForStub(stubTree, stub);
                if (tree == null) continue;
                if (tree.getElementType() == StubProcessingHelperBase.stubType(stub)) {
                    PsiElement psi = tree.getPsi();
                    PsiUtilCore.ensureValid((PsiElement)psi);
                    if (!skipOnErrors && !requiredClass.isInstance(psi)) {
                        this.inconsistencyDetected(stubTree, psiFile);
                        break;
                    }
                    if (processor2.process((Object)psi)) continue;
                    return false;
                }
                if (skipOnErrors) continue;
                String persistedStubTree = ((PsiFileStubImpl)stubTree.getRoot()).printTree();
                String stubTreeJustBuilt = ((PsiFileStubImpl)((PsiFileImpl)psiFile).getElementTypeForStubBuilder().getBuilder().buildStubTree((PsiFile)psiFile)).printTree();
                StringBuilder builder = new StringBuilder();
                builder.append("Oops\n");
                builder.append("Recorded stub:-----------------------------------\n");
                builder.append(persistedStubTree);
                builder.append("\nAST built stub: ------------------------------------\n");
                builder.append(stubTreeJustBuilt);
                builder.append("\n");
                LOG.info(builder.toString());
                this.onInternalError(file2);
            }
        } else {
            List<StubElement<?>> plained = stubTree.getPlainListFromAllRoots();
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                int stubTreeIndex = value.get(i);
                if (stubTreeIndex >= plained.size()) {
                    if (skipOnErrors) break;
                    this.inconsistencyDetected(stubTree, psiFile);
                    break;
                }
                PsiElement psi = plained.get(stubTreeIndex).getPsi();
                PsiUtilCore.ensureValid((PsiElement)psi);
                if (!skipOnErrors && !requiredClass.isInstance(psi)) {
                    this.inconsistencyDetected(stubTree, psiFile);
                    break;
                }
                if (processor2.process((Object)psi)) continue;
                return false;
            }
        }
        return true;
    }

    private void inconsistencyDetected(@NotNull ObjectStubTree stubTree, PsiFileWithStubSupport psiFile) {
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/stubs/StubProcessingHelperBase", "inconsistencyDetected"));
        }
        LOG.error(this.stubTreeAndIndexDoNotMatch(stubTree, psiFile));
        this.onInternalError(psiFile.getVirtualFile());
    }

    protected abstract Object stubTreeAndIndexDoNotMatch(@NotNull ObjectStubTree var1, PsiFileWithStubSupport var2);

    protected abstract void onInternalError(VirtualFile var1);
}

