/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import java.util.List;

public class ClassAnchorUtil {
    public static PsiClass retrieve(Project project, SmartClassAnchor anchor) {
        if (anchor instanceof SmartClassAnchor.DirectSmartClassAnchor) {
            return ((SmartClassAnchor.DirectSmartClassAnchor)anchor).myPsiClass;
        }
        if (anchor instanceof SmartClassAnchor.StubSmartClassAnchor) {
            SmartClassAnchor.StubSmartClassAnchor stubAnchor = (SmartClassAnchor.StubSmartClassAnchor)anchor;
            VirtualFile file2 = PersistentFS.getInstance().findFileById(stubAnchor.myFileId);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            return (PsiClass)ClassAnchorUtil.restoreFromStubIndex((PsiFileWithStubSupport)psiFile, stubAnchor.myStubId);
        }
        return null;
    }

    public static PsiClass retrieveInReadAction(final Project project, final SmartClassAnchor anchor) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return ClassAnchorUtil.retrieve(project, anchor);
            }
        });
    }

    public static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index) {
        List list;
        boolean foreign;
        StubTree tree = fileImpl.getStubTree();
        boolean bl = foreign = tree == null;
        if (foreign) {
            if (fileImpl instanceof PsiFileImpl) {
                tree = ((PsiFileImpl)fileImpl).calcStubTree();
            } else {
                return null;
            }
        }
        if (index >= (list = tree.getPlainList()).size()) {
            return null;
        }
        StubElement stub = (StubElement)list.get(index);
        if (foreign) {
            PsiElement cachedPsi = ((StubBase)stub).getCachedPsi();
            if (cachedPsi != null) {
                return cachedPsi;
            }
            ASTNode ast = fileImpl.findTreeForStub(tree, stub);
            if (ast != null) {
                return ast.getPsi();
            }
            return null;
        }
        return stub.getPsi();
    }
}

