/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationReplacementUtil {
    public static final Logger LOG = Logger.getInstance((String)("#" + TypeMigrationReplacementUtil.class.getName()));

    private TypeMigrationReplacementUtil() {
    }

    public static PsiElement replaceExpression(PsiExpression expression, Project project, Object conversion, TypeEvaluator typeEvaluator) {
        block21: {
            if (conversion instanceof TypeConversionDescriptorBase) {
                try {
                    return ((TypeConversionDescriptorBase)conversion).replace(expression, typeEvaluator);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    break block21;
                }
            }
            if (conversion instanceof String) {
                String replacement = (String)conversion;
                try {
                    return expression.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(replacement, (PsiElement)expression));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    break block21;
                }
            }
            if (expression instanceof PsiReferenceExpression) {
                PsiElement resolved = ((PsiReferenceExpression)expression).resolve();
                PsiMember replacer = (PsiMember)conversion;
                String method = ((PsiMember)resolved).getName();
                String ref = expression.getText();
                String newref = ref.substring(0, ref.lastIndexOf(method)) + replacer.getName();
                if (conversion instanceof PsiMethod) {
                    if (resolved instanceof PsiMethod) {
                        try {
                            return expression.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(newref, (PsiElement)expression));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            break block21;
                        }
                    }
                    try {
                        return expression.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(newref + "()", (PsiElement)expression));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        break block21;
                    }
                }
                if (conversion instanceof PsiField) {
                    if (resolved instanceof PsiField) {
                        try {
                            return expression.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(newref, (PsiElement)expression));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    } else {
                        PsiElement parent = Util.getEssentialParent((PsiElement)expression);
                        if (parent instanceof PsiMethodCallExpression) {
                            try {
                                return parent.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(newref, (PsiElement)expression));
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        return expression;
    }

    static void migratePsiMemberType(PsiElement element, Project project, PsiType migratedType) {
        try {
            if (!migratedType.isValid()) {
                migratedType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName(migratedType.getCanonicalText());
            }
            PsiTypeElement typeElement = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeElement(migratedType);
            if (element instanceof PsiMethod) {
                PsiTypeElement returnTypeElement = ((PsiMethod)element).getReturnTypeElement();
                if (returnTypeElement != null) {
                    PsiElement replaced = returnTypeElement.replace((PsiElement)typeElement);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
                }
            } else if (element instanceof PsiVariable) {
                PsiTypeElement varTypeElement = ((PsiVariable)element).getTypeElement();
                if (varTypeElement != null) {
                    PsiElement replaced = varTypeElement.replace((PsiElement)typeElement);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
                }
            } else {
                LOG.error("Must not happen: " + element.getClass().getName());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    static PsiNewExpression replaceNewExpressionType(Project project, PsiNewExpression expression, Map.Entry<TypeMigrationUsageInfo, PsiType> info) {
        PsiType changeType = info.getValue();
        if (changeType != null) {
            try {
                PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                PsiType componentType = changeType.getDeepComponentType();
                if (classReference != null) {
                    Object psiElement = changeType.equals(expression.getType()) ? classReference : TypeMigrationReplacementUtil.replaceTypeWithClassReferenceOrKeyword(project, componentType, (PsiElement)classReference);
                    PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNewExpression.class);
                    if (!TypeMigrationReplacementUtil.tryToReplaceWithDiamond(newExpression, changeType)) {
                        return newExpression;
                    }
                } else {
                    PsiElement typeKeyword = TypeMigrationReplacementUtil.getTypeKeyword(expression);
                    if (typeKeyword != null) {
                        TypeMigrationReplacementUtil.replaceTypeWithClassReferenceOrKeyword(project, componentType, typeKeyword);
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    static boolean tryToReplaceWithDiamond(PsiNewExpression newExpression, @Nullable PsiType changeType) {
        if (newExpression != null && PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, changeType)) {
            PsiJavaCodeReferenceElement anonymousClassReference = newExpression.getClassOrAnonymousClassReference();
            if (anonymousClassReference != null) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)anonymousClassReference.getParameterList());
            }
            return true;
        }
        return false;
    }

    private static PsiElement replaceTypeWithClassReferenceOrKeyword(Project project, PsiType componentType, PsiElement typePlace) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (componentType instanceof PsiClassType) {
            return typePlace.replace((PsiElement)factory.createReferenceElementByType((PsiClassType)componentType));
        }
        return typePlace.replace(TypeMigrationReplacementUtil.getTypeKeyword((PsiNewExpression)factory.createExpressionFromText("new " + componentType.getPresentableText() + "[0]", typePlace)));
    }

    private static PsiElement getTypeKeyword(PsiNewExpression expression) {
        return ((CompositeElement)expression).findChildByRoleAsPsiElement(72);
    }
}

