/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaConversionUtil {
    @Nullable
    public static PsiType getFunctionReturnType(PsiExpression functionExpression) {
        if (functionExpression instanceof PsiFunctionalExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)functionExpression));
        }
        PsiType currentType = functionExpression.getType();
        if (currentType == null) {
            return null;
        }
        block0: do {
            if (LambdaUtil.isFunctionalType((PsiType)currentType)) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
            }
            PsiType[] superTypes = currentType.getSuperTypes();
            currentType = null;
            for (PsiType type : superTypes) {
                PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
                if (aClass == null || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"com.google.common.base.Function")) continue;
                currentType = type;
                continue block0;
            }
        } while (currentType != null);
        return null;
    }

    @NotNull
    public static PsiType addTypeParameters(@NotNull String baseClassQualifiedName, @Nullable PsiType type, @NotNull PsiElement context) {
        String canonicalText;
        if (baseClassQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassQualifiedName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        String parameterText = "";
        if (type != null && (canonicalText = type.getCanonicalText(false)).contains("<")) {
            parameterText = canonicalText.substring(canonicalText.indexOf(60));
        }
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(baseClassQualifiedName + parameterText, context);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        return psiType;
    }
}

