/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FunctionalInterfaceTypeConversionDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFunctionConversionRule
extends BaseGuavaTypeConversionRule {
    public static final String JAVA_UTIL_FUNCTION_FUNCTION = "java.util.function.Function";
    public static final String GUAVA_FUNCTION = "com.google.common.base.Function";

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put("apply", new FunctionalInterfaceTypeConversionDescriptor("apply", "apply", JAVA_UTIL_FUNCTION_FUNCTION));
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable psiVariable, PsiExpression context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFunctionConversionRule", "findConversionForVariableReference"));
        }
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFunctionConversionRule", "findConversionForVariableReference"));
        }
        return new FunctionalInterfaceTypeConversionDescriptor("apply", "apply", JAVA_UTIL_FUNCTION_FUNCTION);
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        if (GUAVA_FUNCTION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFunctionConversionRule", "ruleFromClass"));
        }
        return GUAVA_FUNCTION;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        if (JAVA_UTIL_FUNCTION_FUNCTION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaFunctionConversionRule", "ruleToClass"));
        }
        return JAVA_UTIL_FUNCTION_FUNCTION;
    }
}

