/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.FluentIterableConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaPredicatesUtil {
    private static final Logger LOG = Logger.getInstance(GuavaPredicatesUtil.class);
    static final Set<String> PREDICATES_AND_OR = ContainerUtil.newHashSet((Object[])new String[]{"or", "and"});
    static final String PREDICATES_NOT = "not";
    public static final Set<String> PREDICATES_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"alwaysTrue", "alwaysFalse", "isNull", "notNull", "equalTo", "not", "or", "and"});

    @Nullable
    static TypeConversionDescriptorBase tryConvertIfPredicates(PsiMethod method, PsiExpression context) {
        String name = method.getName();
        if (name.equals("alwaysTrue") || name.equals("alwaysFalse")) {
            return new TypeConversionDescriptorWithLocalVariable(name, "$x$ -> " + name.contains("True") + "");
        }
        if (name.equals("isNull") || name.equals("notNull")) {
            String operation = name.equals("isNull") ? "==" : "!=";
            return new TypeConversionDescriptorWithLocalVariable(name, "$x$ -> $x$" + operation + " null");
        }
        if (name.equals("equalTo")) {
            return new TypeConversionDescriptorWithLocalVariable("equalTo", "$x$ -> java.util.Objects.equals($x$, $v$)");
        }
        if (!GuavaPredicatesUtil.isConvertablePredicatesMethod(method)) {
            return null;
        }
        if (PREDICATES_AND_OR.contains(name) && GuavaPredicatesUtil.canMigrateAndOrOr((PsiMethodCallExpression)context)) {
            return new AndOrOrConversionDescriptor(GuavaConversionUtil.addTypeParameters("java.util.function.Predicate", context.getType(), (PsiElement)context));
        }
        if (PREDICATES_NOT.equals(name)) {
            return new NotConversionDescriptor(GuavaConversionUtil.addTypeParameters("java.util.function.Predicate", context.getType(), (PsiElement)context));
        }
        return null;
    }

    public static boolean isConvertablePredicatesMethod(@NotNull PsiMethod method) {
        PsiParameter parameter;
        PsiClass psiClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil", "isConvertablePredicatesMethod"));
        }
        return method.getParameterList().getParametersCount() != 1 || (psiClass = PsiTypesUtil.getPsiClass((PsiType)(parameter = method.getParameterList().getParameters()[0]).getType().getDeepComponentType())) != null && !"java.lang.Iterable".equals(psiClass.getQualifiedName());
    }

    private static boolean canMigrateAndOrOr(PsiMethodCallExpression expr) {
        PsiMethod method = expr.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameterList parameters = method.getParameterList();
        if (parameters.getParametersCount() != 1) {
            return parameters.getParametersCount() != 0;
        }
        PsiParameter parameter = parameters.getParameters()[0];
        PsiType type = parameter.getType();
        return type instanceof PsiEllipsisType;
    }

    private static PsiExpression replaceTypeCast(PsiExpression expression, PsiElement parent) {
        PsiType type;
        PsiClass aClass;
        PsiTypeElement typeElement;
        PsiElement parParent = parent.getParent();
        if (parParent instanceof PsiTypeCastExpression && (typeElement = ((PsiTypeCastExpression)parParent).getCastType()) != null && (aClass = PsiTypesUtil.getPsiClass((PsiType)(type = typeElement.getType()))) != null && "java.util.function.Predicate".equals(aClass.getQualifiedName())) {
            expression = (PsiExpression)parParent.replace((PsiElement)expression);
        }
        return expression;
    }

    public static boolean isJavaPredicate(PsiElement element, TypeEvaluator evaluator) {
        PsiElement parent;
        if (element instanceof PsiLocalVariable) {
            return GuavaPredicatesUtil.isJavaPredicate(evaluator.getType(element));
        }
        if (element instanceof PsiReturnStatement) {
            PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            PsiType methodReturnType = null;
            if (methodOrLambda instanceof PsiMethod) {
                methodReturnType = evaluator.getType(methodOrLambda);
            }
            return GuavaPredicatesUtil.isJavaPredicate(methodReturnType);
        }
        if (element instanceof PsiExpressionList && (parent = element.getParent()) instanceof PsiMethodCallExpression) {
            return evaluator.getType(parent) != null;
        }
        return false;
    }

    private static boolean isJavaPredicate(@Nullable PsiType type) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return aClass != null && "java.util.function.Predicate".equals(aClass.getQualifiedName());
    }

    private static boolean isUnconverted(PsiType type) {
        PsiClass predicateClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return predicateClass != null && !"java.util.function.Predicate".equals(predicateClass.getQualifiedName());
    }

    private static String adjust(PsiExpression expression, boolean insertTypeCase, PsiType targetType, TypeEvaluator evaluator) {
        PsiClass evaluateClass;
        PsiExpression qualifier;
        PsiType evaluatedType;
        if (expression instanceof PsiMethodReferenceExpression && (evaluatedType = evaluator.evaluateType(qualifier = ((PsiMethodReferenceExpression)expression).getQualifierExpression())) != null && (evaluateClass = PsiTypesUtil.getPsiClass((PsiType)evaluatedType)) != null && "java.util.function.Predicate".equals(evaluateClass.getQualifiedName())) {
            return GuavaPredicatesUtil.adjust((PsiExpression)expression.replace((PsiElement)qualifier), insertTypeCase, targetType, evaluator);
        }
        if (expression instanceof PsiFunctionalExpression) {
            if (insertTypeCase) {
                return "((" + targetType.getCanonicalText() + ")" + expression.getText() + ")";
            }
        } else if ((expression instanceof PsiMethodCallExpression || expression instanceof PsiReferenceExpression) && GuavaPredicatesUtil.isUnconverted(evaluator.evaluateType(expression))) {
            expression = (PsiExpression)expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::apply", (PsiElement)expression));
            return GuavaPredicatesUtil.adjust(expression, insertTypeCase, targetType, evaluator);
        }
        return expression.getText();
    }

    private static class AndOrOrConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final PsiType myTargetType;

        public AndOrOrConversionDescriptor(PsiType targetType) {
            this.myTargetType = targetType;
        }

        @Override
        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$AndOrOrConversionDescriptor", "replace"));
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            String methodName = methodCall.getMethodExpression().getReferenceName();
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
            if (arguments.length == 1) {
                return (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(GuavaPredicatesUtil.adjust(arguments[0], true, this.myTargetType, evaluator), (PsiElement)expression));
            }
            LOG.assertTrue(arguments.length != 0);
            StringBuilder replaceBy = new StringBuilder();
            for (int i = 1; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                replaceBy.append(".").append(methodName).append("(").append(GuavaPredicatesUtil.adjust(argument, false, this.myTargetType, evaluator)).append(")");
            }
            replaceBy.insert(0, GuavaPredicatesUtil.adjust(arguments[0], true, this.myTargetType, evaluator));
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodReferenceExpression) {
                expression = GuavaPredicatesUtil.replaceTypeCast(expression, parent);
            } else if (!GuavaPredicatesUtil.isJavaPredicate(parent, evaluator)) {
                replaceBy.append("::test");
            }
            return (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(replaceBy.toString(), (PsiElement)expression));
        }
    }

    private static class NotConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final PsiType myTargetType;

        public NotConversionDescriptor(PsiType targetType) {
            this.myTargetType = targetType;
        }

        @Override
        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$NotConversionDescriptor", "replace"));
            }
            String newExpressionString = GuavaPredicatesUtil.adjust(((PsiMethodCallExpression)expression).getArgumentList().getExpressions()[0], true, this.myTargetType, evaluator) + ".negate()";
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodReferenceExpression) {
                expression = GuavaPredicatesUtil.replaceTypeCast(expression, parent);
            } else if (!GuavaPredicatesUtil.isJavaPredicate(parent, evaluator)) {
                newExpressionString = newExpressionString + "::test";
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
            PsiExpression convertedExpression = (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(newExpressionString, (PsiElement)expression));
            convertedExpression = convertedExpression.getParent() instanceof PsiMethodReferenceExpression ? (PsiExpression)convertedExpression.getParent().replace((PsiElement)convertedExpression) : convertedExpression;
            PsiElement maybeTypeCast = convertedExpression.getParent();
            if (maybeTypeCast instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)maybeTypeCast))) {
                convertedExpression = (PsiExpression)maybeTypeCast.replace((PsiElement)((PsiTypeCastExpression)maybeTypeCast).getOperand());
            }
            return convertedExpression;
        }
    }

    private static class TypeConversionDescriptorWithLocalVariable
    extends TypeConversionDescriptor {
        private final String myReplaceByStringTemplate;

        TypeConversionDescriptorWithLocalVariable(String methodName, String replaceByString) {
            super("'Predicates*." + methodName + "(" + (methodName.equals("equalTo") ? "$v$" : "") + ")", null);
            this.myReplaceByStringTemplate = replaceByString;
        }

        @Override
        public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) {
            String chosenName = FluentIterableConversionUtil.chooseName(expression, TypeConversionDescriptorWithLocalVariable.getIntroducedVariableType(expression));
            this.setReplaceByString(StringUtil.replace((String)this.myReplaceByStringTemplate, (String)"$x$", (String)chosenName));
            return super.replace(expression, evaluator);
        }

        private static PsiType getIntroducedVariableType(PsiExpression expression) {
            PsiType parameter;
            PsiType[] parameters;
            PsiType type = expression.getType();
            if (type instanceof PsiClassType && (parameters = ((PsiClassType)type).getParameters()).length == 1 && (parameter = parameters[0]) instanceof PsiClassType) {
                return parameter;
            }
            return null;
        }
    }
}

