/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GuavaTypeConversionDescriptor
extends TypeConversionDescriptor {
    private static final Logger LOG = Logger.getInstance(GuavaTypeConversionDescriptor.class);
    private final String myReplaceByStringSource;
    private boolean myConvertParameterAsLambda = true;

    GuavaTypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        super(stringToReplace, replaceByString);
        this.myReplaceByStringSource = replaceByString;
    }

    public GuavaTypeConversionDescriptor setConvertParameterAsLambda(boolean convertParameterAsLambda) {
        this.myConvertParameterAsLambda = convertParameterAsLambda;
        return this;
    }

    @Override
    public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) throws IncorrectOperationException {
        PsiExpression[] arguments;
        LOG.assertTrue(expression instanceof PsiMethodCallExpression);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
        this.setReplaceByString(this.myReplaceByStringSource + (GuavaTypeConversionDescriptor.isIterable(methodCall) ? ".collect(java.util.stream.Collectors.toList())" : ""));
        if (this.myConvertParameterAsLambda && (arguments = methodCall.getArgumentList().getExpressions()).length == 1) {
            PsiExpression functionArg = arguments[0];
            this.customizeParameter(GuavaTypeConversionDescriptor.convertParameter(functionArg, evaluator));
        }
        return super.replace(expression, evaluator);
    }

    protected void customizeParameter(PsiExpression parameter) {
    }

    private static PsiExpression addApplyReference(PsiExpression expression, TypeEvaluator evaluator) {
        PsiClass resolvedClass;
        String samMethodName = null;
        PsiType type = evaluator.evaluateType(expression);
        if (type instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null) {
            GlobalSearchScope scope;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)expression.getProject());
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedClass, (PsiClass)javaPsiFacade.findClass("com.google.common.base.Supplier", scope = resolvedClass.getResolveScope()), (boolean)true)) {
                samMethodName = "get";
            } else if (InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedClass, (PsiClass)javaPsiFacade.findClass("com.google.common.base.Function", scope), (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedClass, (PsiClass)javaPsiFacade.findClass("com.google.common.base.Predicate", scope), (boolean)true)) {
                samMethodName = "apply";
            }
        }
        if (samMethodName == null) {
            return expression;
        }
        return (PsiExpression)expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + samMethodName, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PsiExpression convertParameter(PsiExpression expression, TypeEvaluator evaluator) {
        if (expression instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)expression).getAnonymousClass();
            if (anonymousClass == null) return GuavaTypeConversionDescriptor.addApplyReference(expression, evaluator);
            if (!AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, true)) return expression;
            AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, true, true);
            return expression;
        } else {
            PsiClass qualifierClass;
            PsiType qualifierType;
            PsiElement qualifier;
            if (!(expression instanceof PsiFunctionalExpression)) {
                return GuavaTypeConversionDescriptor.addApplyReference(expression, evaluator);
            }
            if (!(expression instanceof PsiMethodReferenceExpression) || !((qualifier = ((PsiMethodReferenceExpression)expression).getQualifier()) instanceof PsiExpression) || (qualifierType = evaluator.evaluateType((PsiExpression)qualifier)) == null || (qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType)) == null || !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.function.Function") && !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.Optional") && !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.function.Supplier") && !Comparing.equal((String)qualifierClass.getQualifiedName(), (String)"java.util.function.Predicate")) return expression;
            return (PsiExpression)expression.replace(qualifier);
        }
    }

    public static boolean isIterable(PsiMethodCallExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiLocalVariable) {
            return GuavaTypeConversionDescriptor.isIterable(((PsiLocalVariable)parent).getType());
        }
        if (parent instanceof PsiReturnStatement) {
            PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            PsiType methodReturnType = null;
            if (methodOrLambda instanceof PsiMethod) {
                methodReturnType = ((PsiMethod)methodOrLambda).getReturnType();
            } else if (methodOrLambda instanceof PsiLambdaExpression) {
                methodReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)methodOrLambda));
            }
            return GuavaTypeConversionDescriptor.isIterable(methodReturnType);
        }
        return false;
    }

    private static boolean isIterable(@Nullable PsiType type) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return aClass != null && "java.lang.Iterable".equals(aClass.getQualifiedName());
    }
}

