/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.ui.DuplicateNodeRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MigrationNode
extends AbstractTreeNode<TypeMigrationUsageInfo>
implements DuplicateNodeRenderer.DuplicatableNode<MigrationNode> {
    private final TypeMigrationUsageInfo myInfo;
    private MigrationNode myDuplicatedNode;
    private List<MigrationNode> myCachedChildren;
    private final TypeMigrationLabeler myLabeler;
    private final PsiType myMigrationType;
    private final HashMap<TypeMigrationUsageInfo, Set<MigrationNode>> myProcessed;
    private final HashSet<TypeMigrationUsageInfo> myParents;

    public MigrationNode(Project project, TypeMigrationUsageInfo info, PsiType migrationType, TypeMigrationLabeler labeler, HashSet<TypeMigrationUsageInfo> parents, HashMap<TypeMigrationUsageInfo, Set<MigrationNode>> processed) {
        super(project, (Object)info);
        this.myLabeler = labeler;
        this.myMigrationType = migrationType;
        this.myProcessed = processed;
        this.myParents = parents;
        Set<MigrationNode> alreadyAdded = this.myProcessed.get((Object)info);
        if (alreadyAdded == null) {
            alreadyAdded = new HashSet<MigrationNode>();
            this.myProcessed.put(info, alreadyAdded);
            this.myInfo = info;
        } else {
            MigrationNode duplicate = alreadyAdded.iterator().next();
            this.myInfo = duplicate.getInfo();
            this.myDuplicatedNode = duplicate;
        }
        alreadyAdded.add(this);
    }

    public TypeMigrationUsageInfo getInfo() {
        return this.myInfo;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        if (this.myCachedChildren == null) {
            this.myCachedChildren = new ArrayList<MigrationNode>();
            PsiElement element = this.myInfo.getElement();
            if (element != null) {
                try {
                    this.myLabeler.setRootAndMigrate(this.myInfo, this.myMigrationType, this.myLabeler.markRootUsages(element, this.myMigrationType));
                }
                catch (TypeMigrationLabeler.MigrateException migrateException) {
                    // empty catch block
                }
                HashSet<Pair<TypeMigrationUsageInfo, PsiType>> roots = this.myLabeler.getRootsTree().get((Object)this.myInfo);
                if (roots != null) {
                    for (Pair<TypeMigrationUsageInfo, PsiType> root : roots) {
                        TypeMigrationUsageInfo info = (TypeMigrationUsageInfo)((Object)root.getFirst());
                        if (this.myParents.contains((Object)info)) continue;
                        HashSet<TypeMigrationUsageInfo> parents = new HashSet<TypeMigrationUsageInfo>(this.myParents);
                        parents.add(info);
                        MigrationNode migrationNode = new MigrationNode(this.getProject(), info, (PsiType)root.getSecond(), this.myLabeler, parents, this.myProcessed);
                        if (this.myInfo.isExcluded()) {
                            info.setExcluded(true);
                        }
                        this.myCachedChildren.add(migrationNode);
                    }
                }
            }
        }
        List<MigrationNode> list = this.myCachedChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/ui/MigrationNode", "getChildren"));
        }
        return list;
    }

    public boolean areChildrenInitialized() {
        return this.myCachedChildren != null;
    }

    protected void update(PresentationData presentation) {
    }

    @Override
    public MigrationNode getDuplicate() {
        return this.myDuplicatedNode;
    }

    public boolean hasDuplicate() {
        return this.myDuplicatedNode != null;
    }
}

