/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.ui.SimpleEditorCustomization;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.WeakHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpellCheckingEditorCustomization
extends SimpleEditorCustomization {
    public static final SpellCheckingEditorCustomization ENABLED = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization();
    public static final SpellCheckingEditorCustomization DISABLED = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
    private static final Map<String, LocalInspectionToolWrapper> SPELL_CHECK_TOOLS = new HashMap<String, LocalInspectionToolWrapper>();
    private static final boolean READY = SpellCheckingEditorCustomization.init();

    @NotNull
    public static SpellCheckingEditorCustomization getInstance(boolean enabled) {
        SpellCheckingEditorCustomization spellCheckingEditorCustomization = (SpellCheckingEditorCustomization)SpellCheckingEditorCustomizationProvider.getInstance().getCustomization(enabled);
        if (spellCheckingEditorCustomization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization", "getInstance"));
        }
        return spellCheckingEditorCustomization;
    }

    SpellCheckingEditorCustomization(boolean enabled) {
        super(enabled);
    }

    private static boolean init() {
        Class[] inspectionClasses;
        for (Class inspectionClass : inspectionClasses = new Class[]{SpellCheckingInspection.class}) {
            try {
                LocalInspectionTool tool = (LocalInspectionTool)inspectionClass.newInstance();
                SPELL_CHECK_TOOLS.put(tool.getShortName(), new LocalInspectionToolWrapper(tool));
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void customize(@NotNull EditorEx editor) {
        DaemonCodeAnalyzer analyzer;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization", "customize"));
        }
        boolean apply = this.isEnabled();
        if (!READY) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return;
        }
        NotNullFunction strategy = (NotNullFunction)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        if (strategy == null) {
            strategy = new MyInspectionProfileStrategy();
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, (Object)strategy);
        }
        if (!(strategy instanceof MyInspectionProfileStrategy)) {
            return;
        }
        ((MyInspectionProfileStrategy)strategy).setUseSpellCheck(apply);
        if (apply) {
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, false);
        }
        if ((analyzer = DaemonCodeAnalyzer.getInstance((Project)project)) != null) {
            analyzer.restart(file2);
        }
    }

    private static class MyInspectionProfileWrapper
    extends InspectionProfileWrapper {
        private final InspectionProfileWrapper myDelegate;
        private boolean myUseSpellCheck;

        MyInspectionProfileWrapper(InspectionProfileWrapper delegate) {
            super(new InspectionProfileImpl("CommitDialog"));
            this.myDelegate = delegate;
        }

        @Override
        public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
            return SPELL_CHECK_TOOLS.containsKey(key.toString()) && this.myUseSpellCheck;
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }
    }

    private static class MyInspectionProfileStrategy
    implements NotNullFunction<InspectionProfileWrapper, InspectionProfileWrapper> {
        private final Map<InspectionProfileWrapper, MyInspectionProfileWrapper> myWrappers = new WeakHashMap();
        private boolean myUseSpellCheck;

        private MyInspectionProfileStrategy() {
        }

        @NotNull
        public InspectionProfileWrapper fun(InspectionProfileWrapper inspectionProfileWrapper) {
            if (!READY) {
                InspectionProfileWrapper inspectionProfileWrapper2 = inspectionProfileWrapper;
                if (inspectionProfileWrapper2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy", "fun"));
                }
                return inspectionProfileWrapper2;
            }
            MyInspectionProfileWrapper wrapper = this.myWrappers.get(inspectionProfileWrapper);
            if (wrapper == null) {
                wrapper = new MyInspectionProfileWrapper(inspectionProfileWrapper);
                this.myWrappers.put(inspectionProfileWrapper, wrapper);
            }
            wrapper.setUseSpellCheck(this.myUseSpellCheck);
            MyInspectionProfileWrapper myInspectionProfileWrapper = wrapper;
            if (myInspectionProfileWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/ui/SpellCheckingEditorCustomization$MyInspectionProfileStrategy", "fun"));
            }
            return myInspectionProfileWrapper;
        }

        public void setUseSpellCheck(boolean useSpellCheck) {
            this.myUseSpellCheck = useSpellCheck;
        }
    }
}

