/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.UnindexedFilesUpdater");
    private final FileBasedIndexImpl myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
    private final Project myProject;
    private final boolean myOnStartup;

    public UnindexedFilesUpdater(final Project project, boolean onStartup) {
        this.myProject = project;
        this.myOnStartup = onStartup;
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                DumbService.getInstance((Project)project).cancelTask((DumbModeTask)UnindexedFilesUpdater.this);
            }
        });
    }

    private void updateUnindexedFiles(ProgressIndicator indicator) {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        PushedFilePropertiesUpdater.getInstance((Project)this.myProject).pushAllPropertiesNow();
        snapshot.logResponsivenessSinceCreation("Pushing properties");
        indicator.setIndeterminate(true);
        indicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        CollectingContentIterator finder = this.myIndex.createContentIterator(indicator);
        snapshot = PerformanceWatcher.takeSnapshot();
        this.myIndex.iterateIndexableFilesConcurrently((ContentIterator)finder, this.myProject, indicator);
        this.myIndex.filesUpdateEnumerationFinished();
        snapshot.logResponsivenessSinceCreation("Indexable file iteration");
        List files = finder.getFiles();
        if (this.myOnStartup && !ApplicationManager.getApplication().isUnitTestMode()) {
            ((StartupManagerImpl)StartupManager.getInstance((Project)this.myProject)).scheduleInitialVfsRefresh();
        }
        if (files.isEmpty()) {
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        LOG.info("Unindexed files update started: " + files.size() + " files to update");
        indicator.setIndeterminate(false);
        indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.indexFiles(indicator, files);
        snapshot.logResponsivenessSinceCreation("Unindexed files update");
    }

    private void indexFiles(ProgressIndicator indicator, List<VirtualFile> files) {
        CacheUpdateRunner.processFiles(indicator, true, files, this.myProject, new Consumer<FileContent>(){

            public void consume(FileContent content) {
                UnindexedFilesUpdater.this.myIndex.indexFileContent(UnindexedFilesUpdater.this.myProject, content);
            }
        });
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/UnindexedFilesUpdater", "performInDumbMode"));
        }
        this.myIndex.filesUpdateStarted(this.myProject);
        try {
            this.updateUnindexedFiles(indicator);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Unindexed files update canceled");
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
        }
    }
}

