/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StopWatch {
    private static final Logger LOG = Logger.getInstance(StopWatch.class);
    private final long myStartTime;
    @NotNull
    private final String myOperation;
    @NotNull
    private final Map<VirtualFile, Long> myDurationPerRoot;

    private StopWatch(@NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/vcs/log/util/StopWatch", "<init>"));
        }
        this.myOperation = operation;
        this.myStartTime = System.currentTimeMillis();
        this.myDurationPerRoot = ContainerUtil.newHashMap();
    }

    @NotNull
    public static StopWatch start(@NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/vcs/log/util/StopWatch", "start"));
        }
        StopWatch stopWatch = new StopWatch(operation);
        if (stopWatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/StopWatch", "start"));
        }
        return stopWatch;
    }

    public void rootCompleted(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/util/StopWatch", "rootCompleted"));
        }
        long totalDuration = System.currentTimeMillis() - this.myStartTime;
        long duration = totalDuration - StopWatch.sum(this.myDurationPerRoot.values());
        this.myDurationPerRoot.put(root, duration);
    }

    private static long sum(@NotNull Collection<Long> durations) {
        if (durations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "durations", "com/intellij/vcs/log/util/StopWatch", "sum"));
        }
        long sum = 0L;
        for (Long duration : durations) {
            sum += duration.longValue();
        }
        return sum;
    }

    public void report() {
        String message = this.myOperation + " took " + (System.currentTimeMillis() - this.myStartTime) + " ms";
        if (this.myDurationPerRoot.size() > 1) {
            message = message + "\n" + StringUtil.join(this.myDurationPerRoot.entrySet(), (Function)new Function<Map.Entry<VirtualFile, Long>, String>(){

                public String fun(Map.Entry<VirtualFile, Long> entry) {
                    return "    " + entry.getKey().getName() + ": " + entry.getValue() + " ms";
                }
            }, (String)"\n");
        }
        LOG.debug(message);
    }
}

