/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.actions.SimpleCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateXmlTagAction
extends SimpleCodeInsightAction {
    public static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(GenerateXmlTagAction.class);

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/GenerateXmlTagAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/GenerateXmlTagAction", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        try {
            final XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file2);
            if (contextTag == null) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Caret should be positioned inside a tag");
            }
            XmlElementDescriptor currentTagDescriptor = contextTag.getDescriptor();
            assert (currentTagDescriptor != null);
            Object[] descriptors = currentTagDescriptor.getElementsDescriptors(contextTag);
            Arrays.sort(descriptors, new Comparator<XmlElementDescriptor>(){

                @Override
                public int compare(XmlElementDescriptor o1, XmlElementDescriptor o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            final JBList list = new JBList(descriptors);
            list.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    final XmlElementDescriptor selected = (XmlElementDescriptor)list.getSelectedValue();
                    new WriteCommandAction.Simple(project, "Generate XML Tag", new PsiFile[]{file2}){

                        protected void run() {
                            if (selected == null) {
                                return;
                            }
                            XmlTag newTag = GenerateXmlTagAction.createTag(contextTag, selected);
                            XmlTag anchor = GenerateXmlTagAction.getAnchor(contextTag, editor, selected);
                            if (anchor == null) {
                                int offset = editor.getCaretModel().getOffset();
                                Document document = editor.getDocument();
                                document.insertString(offset, (CharSequence)newTag.getText());
                                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                                newTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset + 1), XmlTag.class, (boolean)false);
                            } else {
                                newTag = (XmlTag)contextTag.addAfter((PsiElement)newTag, (PsiElement)anchor);
                            }
                            if (newTag != null) {
                                GenerateXmlTagAction.generateTag(newTag, editor);
                            }
                        }
                    }.execute();
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                XmlElementDescriptor descriptor = (XmlElementDescriptor)ContainerUtil.find((Object[])descriptors, (Condition)new Condition<XmlElementDescriptor>(){

                    public boolean value(XmlElementDescriptor xmlElementDescriptor) {
                        return xmlElementDescriptor.getName().equals(TEST_THREAD_LOCAL.get());
                    }
                });
                list.setSelectedValue((Object)descriptor, false);
                runnable2.run();
            } else {
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Tag Name").setItemChoosenCallback(runnable2).setFilteringEnabled((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return ((XmlElementDescriptor)o).getName();
                    }
                }).createPopup().showInBestPositionFor(editor);
            }
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException e) {
            HintManager.getInstance().showErrorHint(editor, e.getMessage());
        }
    }

    @Nullable
    private static XmlTag getAnchor(@NotNull XmlTag contextTag, Editor editor, XmlElementDescriptor selected) {
        if (contextTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextTag", "com/intellij/xml/actions/GenerateXmlTagAction", "getAnchor"));
        }
        XmlContentDFA contentDFA = XmlContentDFA.getContentDFA(contextTag);
        int offset = editor.getCaretModel().getOffset();
        if (contentDFA == null) {
            return null;
        }
        XmlTag anchor = null;
        boolean previousPositionIsPossible = true;
        for (XmlTag subTag : contextTag.getSubTags()) {
            if (contentDFA.getPossibleElements().contains(selected)) {
                if (subTag.getTextOffset() > offset) break;
                anchor = subTag;
                previousPositionIsPossible = true;
            } else {
                previousPositionIsPossible = false;
            }
            contentDFA.transition(subTag);
        }
        return previousPositionIsPossible ? null : anchor;
    }

    public static void generateTag(@NotNull XmlTag newTag, Editor editor) {
        if (newTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTag", "com/intellij/xml/actions/GenerateXmlTagAction", "generateTag"));
        }
        GenerateXmlTagAction.generateRaw(newTag);
        XmlTag restored = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newTag);
        if (restored == null) {
            LOG.error("Could not restore tag: " + newTag.getText());
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)restored);
        GenerateXmlTagAction.replaceElements(restored, builder);
        builder.run(editor, false);
    }

    private static void generateRaw(@NotNull XmlTag newTag) {
        if (newTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTag", "com/intellij/xml/actions/GenerateXmlTagAction", "generateRaw"));
        }
        XmlElementDescriptor selected = newTag.getDescriptor();
        if (selected == null) {
            return;
        }
        switch (selected.getContentType()) {
            case 0: {
                newTag.collapseIfEmpty();
                ASTNode node = newTag.getNode();
                assert (node != null);
                ASTNode elementEnd = node.findChildByType(XmlTokenType.XML_EMPTY_ELEMENT_END);
                if (elementEnd != null) break;
                LeafElement emptyTagEnd = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, null, newTag.getManager());
                node.addChild((ASTNode)emptyTagEnd);
                break;
            }
            case 3: {
                newTag.getValue().setText("");
            }
        }
        for (ASTNode descriptor : selected.getAttributesDescriptors(newTag)) {
            if (!descriptor.isRequired()) continue;
            newTag.setAttribute(descriptor.getName(), "");
        }
        List<XmlElementDescriptor> tags = GenerateXmlTagAction.getRequiredSubTags(selected);
        for (XmlElementDescriptor descriptor : tags) {
            if (descriptor == null) {
                XmlTag tag = XmlElementFactory.getInstance((Project)newTag.getProject()).createTagFromText((CharSequence)"<", newTag.getLanguage());
                newTag.addSubTag(tag, false);
                continue;
            }
            XmlTag subTag = newTag.addSubTag(GenerateXmlTagAction.createTag(newTag, descriptor), false);
            GenerateXmlTagAction.generateRaw(subTag);
        }
    }

    public static List<XmlElementDescriptor> getRequiredSubTags(XmlElementDescriptor selected) {
        XmlElementsGroup topGroup = selected.getTopGroup();
        if (topGroup == null) {
            return Collections.emptyList();
        }
        return GenerateXmlTagAction.computeRequiredSubTags(topGroup);
    }

    private static void replaceElements(XmlTag tag, TemplateBuilder builder) {
        int i;
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            if (value == null) continue;
            builder.replaceElement((PsiElement)value, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode(new CompleteMacro()));
        }
        if ("<".equals(tag.getText())) {
            builder.replaceElement((PsiElement)tag, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode(new CompleteSmartMacro()));
        } else if (tag.getSubTags().length == 0 && (i = tag.getText().indexOf("></")) > 0) {
            builder.replaceElement((PsiElement)tag, TextRange.from((int)(i + 1), (int)0), (Expression)new MacroCallNode(new CompleteMacro()));
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            GenerateXmlTagAction.replaceElements((XmlTag)xmlAttribute, builder);
        }
    }

    private static XmlTag createTag(@NotNull XmlTag contextTag, @NotNull XmlElementDescriptor descriptor) {
        if (contextTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextTag", "com/intellij/xml/actions/GenerateXmlTagAction", "createTag"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/actions/GenerateXmlTagAction", "createTag"));
        }
        String namespace = GenerateXmlTagAction.getNamespace(descriptor);
        XmlTag tag = contextTag.createChildTag(descriptor.getName(), namespace, null, false);
        PsiElement lastChild = tag.getLastChild();
        assert (lastChild != null);
        lastChild.delete();
        return tag;
    }

    private static String getNamespace(XmlElementDescriptor descriptor) {
        return descriptor instanceof XmlElementDescriptorImpl ? ((XmlElementDescriptorImpl)descriptor).getNamespace() : "";
    }

    @Nullable
    private static XmlTag getContextTag(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        XmlTag tag = null;
        if (element != null) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        }
        if (tag == null) {
            tag = ((XmlFile)file2).getRootTag();
        }
        return tag;
    }

    private static List<XmlElementDescriptor> computeRequiredSubTags(XmlElementsGroup group) {
        if (group.getMinOccurs() < 1) {
            return Collections.emptyList();
        }
        switch (group.getGroupType()) {
            case LEAF: {
                XmlElementDescriptor descriptor = group.getLeafDescriptor();
                return descriptor == null ? Collections.emptyList() : Collections.singletonList(descriptor);
            }
            case CHOICE: {
                LinkedHashSet<XmlElementDescriptor> set = null;
                for (XmlElementsGroup subGroup : group.getSubGroups()) {
                    List<XmlElementDescriptor> descriptors = GenerateXmlTagAction.computeRequiredSubTags(subGroup);
                    if (set == null) {
                        set = new LinkedHashSet<XmlElementDescriptor>(descriptors);
                        continue;
                    }
                    set.retainAll(descriptors);
                }
                if (set == null || set.isEmpty()) {
                    return Collections.singletonList(null);
                }
                return new ArrayList<XmlElementDescriptor>(set);
            }
        }
        ArrayList<XmlElementDescriptor> list = new ArrayList<XmlElementDescriptor>();
        for (XmlElementsGroup subGroup : group.getSubGroups()) {
            list.addAll(GenerateXmlTagAction.computeRequiredSubTags(subGroup));
        }
        return list;
    }

    private static boolean isInsideTagBody(XmlTag contextTag, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "isInsideTagBody"));
        }
        return contextTag.getValue().getTextRange().contains(editor.getCaretModel().getOffset());
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/actions/GenerateXmlTagAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/actions/GenerateXmlTagAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/actions/GenerateXmlTagAction", "isValidForFile"));
        }
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file2);
        return contextTag != null && GenerateXmlTagAction.isInsideTagBody(contextTag, editor) && contextTag.getDescriptor() != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myNSLabel;

        public MyListCellRenderer() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myNSLabel = new JLabel();
            this.myPanel.add((Component)this.myNSLabel, "East");
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Font font = scheme.getFont(EditorFontType.PLAIN);
            this.myNameLabel.setFont(font);
            this.myNSLabel.setFont(font);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            XmlElementDescriptor descriptor = (XmlElementDescriptor)value;
            Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
            this.myNameLabel.setText(descriptor.getName());
            this.myNameLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.myPanel.setBackground(backgroundColor);
            this.myNSLabel.setText(GenerateXmlTagAction.getNamespace(descriptor));
            this.myNSLabel.setForeground(LookupCellRenderer.getGrayedForeground(isSelected));
            this.myNSLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

