/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.XmlBundle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;

public class UIUtils {
    private UIUtils() {
    }

    public static void configureBrowseButton(final Project myProject, final TextFieldWithBrowseButton wsdlUrl, final String[] _extensions, final String selectFileDialogTitle, final boolean multipleFileSelection) {
        wsdlUrl.getButton().setToolTipText(XmlBundle.message((String)"browse.button.tooltip", (Object[])new Object[0]));
        wsdlUrl.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VirtualFile[] virtualFiles;
                VirtualFile fileByPath;
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, multipleFileSelection){
                    private final List<String> extensions;
                    {
                        this.extensions = Arrays.asList(_extensions);
                    }

                    public boolean isFileSelectable(VirtualFile virtualFile) {
                        return this.extensions.contains(virtualFile.getExtension());
                    }

                    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                        return super.isFileVisible(file2, showHiddenFiles) && (file2.isDirectory() || this.isFileSelectable(file2));
                    }
                };
                fileChooserDescriptor.setTitle(selectFileDialogTitle);
                VirtualFile initialFile = myProject.getBaseDir();
                String selectedItem = wsdlUrl.getTextField().getText();
                if (selectedItem != null && selectedItem.startsWith("file://") && (fileByPath = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(VfsUtilCore.fixURLforIDEA((String)selectedItem)), null)) != null) {
                    initialFile = fileByPath;
                }
                if ((virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)myProject, (VirtualFile)initialFile)).length == 1) {
                    String url = VfsUtilCore.fixIDEAUrl((String)virtualFiles[0].getUrl());
                    wsdlUrl.setText(url);
                }
            }
        });
    }
}

