/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0007\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001A!\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!J\u000f\u0005\u0017!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0002\t\u00105\t\u0001\u0004C\r\u0005\u0011#i!\u0001$\u0001\u0019\u0013\u0015BB!\u0001E\n\u001b\u0005A\"\"G\u0002\t\u00165\t\u0001dC\r\u0004\u0011/i\u0011\u0001G\u0005\u001a\u0007!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u000fe\u0019\u0001rB\u0007\u00021!I\u0003\u0002B!\u001d\u0011\u0007i!\u0001$\u0001\u0019\u0005E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "processSsi", "", "file", "Ljava/io/File;", "path"}, moduleName="built-in-server")
public final class StaticFileHandler
extends WebServerFileHandler {
    private SsiProcessor ssiProcessor;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost) {
        block10: {
            File file2;
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                if (pathInfo.getIoFile() != null) break block9;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block10;
            }
            if ((file2 = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                file2 = new File(virtualFile.getPath());
            }
            File ioFile = file2;
            String nameSequence = pathInfo.getName();
            if (!(StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm"))) {
                StaticFileHandlerKt.sendIoFile(channel, ioFile, (HttpRequest)request);
                return true;
            }
            String string = PathUtilRt.getParentPath((String)((Object)canonicalPath).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath(canonicalPath.toString())");
            this.processSsi(ioFile, string, project, request, channel);
            return true;
        }
        VirtualFile file3 = pathInfo.getFile();
        HttpResponse httpResponse = FileResponses.prepareSend((HttpRequest)request, channel, file3.getTimeStamp(), file3.getPath());
        if (httpResponse == null) return true;
        HttpResponse response = httpResponse;
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file3.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file3.getInputStream()));
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive) return true;
        future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(File file2, String path, Project project, FullHttpRequest request, Channel channel) {
        boolean keepAlive;
        if (this.ssiProcessor == null) {
            this.ssiProcessor = new SsiProcessor(false);
        }
        ByteBuf buffer = channel.alloc().ioBuffer();
        boolean releaseBuffer = true;
        try {
            HttpResponse httpResponse;
            long lastModified;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            if (FileResponses.prepareSend((HttpRequest)request, channel, lastModified = ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file2.getParentFile()), file2, new ByteBufUtf8Writer(buffer)), file2.getPath()) == null) {
                return;
            }
            HttpResponse response = httpResponse;
            keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

