/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinInterfaceDefaultImpls;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.StandaloneVmHelper;
import org.jetbrains.debugger.StandaloneVmHelperKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageProcessor;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0001!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\t-a\u0001!G\u0001\u0019\u0002u\u00051\")\b\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006%\u0019\u0001bA\u0007\u00021\u000f\t6!\u0001\u0005\u0005KA!!\u0002\u0003\u0004\u000e\u0003a5\u0011d\u0001\u0005\u0004\u001b\u0005A:!G\u0004\t\u000f5)\u0011bA\u0005\u0003\u0019\u0003A\u0002\u0002g\u0004&\r\u0011Y\u0001\u0012C\u0007\u0004\u0013\u0005!\u0019\u0001G\u0005&\t!MQB\u0001G\u00011\u000f)s\u0001\u0003\u0006\u000e\u0003a)\u0011d\u0001E\u000b\u001b\u0005A\u0002\"\u000b\u0006\u0005\u0004rA1!\u0004\u0002\r\u0002a\u001dA$\u0001\u0011\u0002#\u000e\tQ\u0001A\u0015\u000b\t-C\u0001\u0012B\u0007\u00021\u0015a2&U\u0002\u0004\u001b\t!I\u0001c\u0003*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/debugger/AttachStateManager;", "vm", "Lorg/jetbrains/debugger/Vm;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "channel", "Lio/netty/channel/Channel;", "(Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/rpc/MessageProcessor;Lio/netty/channel/Channel;)V", "isAttached", "", "()Z", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "detach", "Lorg/jetbrains/concurrency/Promise;", "getChannelIfActive", "write", "content", "VmEx"}, moduleName="script-debugger-backend")
public class StandaloneVmHelper
implements AttachStateManager {
    private volatile Channel channel;
    private final Vm vm;
    private final MessageProcessor messageProcessor;

    @Nullable
    public final Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? (Channel)null : currentChannel;
    }

    public final boolean write(@NotNull Object content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Channel channel = this.getChannelIfActive();
        return channel != null && !channel.writeAndFlush(content).isCancelled();
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<?> detach() {
        Channel channel = this.channel;
        if (channel == null) {
            return PromiseKt.resolvedPromise();
        }
        Channel currentChannel = channel;
        this.messageProcessor.cancelWaitingRequests();
        Vm vm = this.vm;
        if (!(vm instanceof VmEx)) {
            vm = null;
        }
        VmEx vmEx = (VmEx)vm;
        Request<? extends Object> disconnectRequest = vmEx != null ? vmEx.createDisconnectRequest() : null;
        AsyncPromise promise2 = new AsyncPromise();
        if (disconnectRequest == null) {
            this.messageProcessor.closed();
            this.channel = null;
        } else {
            this.messageProcessor.send(disconnectRequest).rejected((Consumer)detach.1.INSTANCE);
            currentChannel.flush();
            this.messageProcessor.closed();
            this.channel = null;
            this.messageProcessor.cancelWaitingRequests();
        }
        this.closeChannel(currentChannel, (AsyncPromise<Object>)promise2);
        return (Promise)promise2;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Object> promise2) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        StandaloneVmHelperKt.doCloseChannel(channel, promise2);
    }

    /*
     * WARNING - void declaration
     */
    public StandaloneVmHelper(@NotNull Vm vm, @NotNull MessageProcessor messageProcessor, @NotNull Channel channel) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)messageProcessor, (String)"messageProcessor");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.vm = vm;
        this.messageProcessor = messageProcessor;
        this.channel = channel;
        ChannelFuture channelFuture = channel.closeFuture();
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ StandaloneVmHelper this$0;

            public final void operationComplete(ChannelFuture future2) {
                ChannelFuture channelFuture = future2;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"future");
                ChannelFuture it = channelFuture;
                if (StandaloneVmHelper.access$getChannel$p(this.this$0) != null) {
                    StandaloneVmHelper.access$getMessageProcessor$p(this.this$0).closed();
                    StandaloneVmHelper.access$getVm$p(this.this$0).getDebugListener().disconnected();
                }
            }
            {
                this.this$0 = standaloneVmHelper;
            }
        });
    }

    @Nullable
    public static final /* synthetic */ Channel access$getChannel$p(StandaloneVmHelper $this) {
        return $this.channel;
    }

    public static final /* synthetic */ void access$setChannel$p(StandaloneVmHelper $this, @Nullable Channel channel) {
        $this.channel = channel;
    }

    @NotNull
    public static final /* synthetic */ MessageProcessor access$getMessageProcessor$p(StandaloneVmHelper $this) {
        return $this.messageProcessor;
    }

    @NotNull
    public static final /* synthetic */ Vm access$getVm$p(StandaloneVmHelper $this) {
        return $this.vm;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\t\u0001\u0002\u0001\u00034\u0019\u0001I\u0012\u0001'\u0001&\u0013\u0011\u0019\u0002\"A\u0007\u0007\u0013\r!\t!C\u0001\u0019\u00051\u0005\u00014\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "Lorg/jetbrains/debugger/Vm;", "createDisconnectRequest", "Lorg/jetbrains/jsonProtocol/Request;", ""}, moduleName="script-debugger-backend")
    public static interface VmEx
    extends Vm {
        @Nullable
        public Request<? extends Object> createDisconnectRequest();

        @KotlinInterfaceDefaultImpls(version={1, 0, 0})
        @KotlinSyntheticClass(version={1, 0, 0}, abiVersion=32, moduleName="script-debugger-backend")
        public static final class DefaultImpls {
            @NotNull
            public static Promise<?> setBreakOnException(@NotNull VmEx $this, ExceptionCatchMode catchMode) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)catchMode), (String)"catchMode");
                return Vm.DefaultImpls.setBreakOnException($this, catchMode);
            }
        }
    }
}

