/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendState;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.VmAwareValueManager;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!!!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0005'1\u0001Q\u0003\u0002\u0003\u0001\u0011\u0003)\u0012\u0001G\u0001\u0016\t\u0011\u0005\u00012A\u000b\u00021\t)B\u0001B\u0001\t\u0006U\t\u0001dA\r\u0005\u0013\tI\u0011\u0001*\u0002\u0019\b\u0005V\u0011b\u0001\u0005\u0005\u001b\u0005a\n!C\u0002\t\n5\t\u0001$B)\u0004\u0003!-\u0011F\u0003\u0003C\u0011!%Q\"\u0001\r\u0006#\u000e!Q\u0001A\u0007\u0003\t\u0019Ai!K\u0006\u0005\u0017\"Aq!\u0004\u0002\r\u0002a=AdK)\u0004\u00075\u0011A\u0001\u0003E\tS)!1\n\u0003\u0005\n\u001b\u0005A\u001a\u0002H\u0016R\u0007\ri!\u0001\u0002\u0006\t\u0016%ZAa\u0011\u0005\t\t5\tA\u0014A)\u0004\u000b\u0015\t\u0001\u0002D\u0007\u0003\t-A9\u0002"}, strings={"Lorg/jetbrains/debugger/SuspendContextBase;", "VM", "Lorg/jetbrains/debugger/Vm;", "VALUE_MANAGER", "Lorg/jetbrains/debugger/values/ValueManager;", "F", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/debugger/SuspendContext;", "valueManager", "explicitPaused", "", "(Lorg/jetbrains/debugger/values/ValueManager;Z)V", "getExplicitPaused", "()Z", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "()Lorg/jetbrains/debugger/Script;", "state", "Lorg/jetbrains/debugger/SuspendState;", "getState", "()Lorg/jetbrains/debugger/SuspendState;", "getValueManager", "()Lorg/jetbrains/debugger/values/ValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;"}, moduleName="script-debugger-backend")
public abstract class SuspendContextBase<VM extends Vm, VALUE_MANAGER extends ValueManager, F extends CallFrame>
implements SuspendContext<F> {
    @NotNull
    private final VALUE_MANAGER valueManager;
    private final boolean explicitPaused;

    @Override
    @NotNull
    public SuspendState getState() {
        return this.getExceptionData() == null ? (this.explicitPaused ? SuspendState.PAUSED : SuspendState.NORMAL) : SuspendState.EXCEPTION;
    }

    @Override
    @Nullable
    public Script getScript() {
        Object topFrame = this.getTopFrame();
        return topFrame == null || !(this.valueManager instanceof VmAwareValueManager) ? (Script)null : ((VmAwareValueManager)this.valueManager).getVm().getScriptManager().getScript((CallFrame)topFrame);
    }

    @NotNull
    public final VALUE_MANAGER getValueManager() {
        return this.valueManager;
    }

    protected final boolean getExplicitPaused() {
        return this.explicitPaused;
    }

    public SuspendContextBase(@NotNull VALUE_MANAGER valueManager, boolean explicitPaused) {
        Intrinsics.checkParameterIsNotNull(valueManager, (String)"valueManager");
        this.valueManager = valueManager;
        this.explicitPaused = explicitPaused;
    }

    @Override
    public boolean getHasUnresolvedBreakpointsHit() {
        return SuspendContext.DefaultImpls.getHasUnresolvedBreakpointsHit(this);
    }

    @Override
    @Nullable
    public ExceptionData getExceptionData() {
        return SuspendContext.DefaultImpls.getExceptionData(this);
    }
}

