/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.StringsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.debugger.LogEntry;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.io.CharSequenceBackedByChars;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u00015U\u0001\u0002A\u0007\u0003\u0019\u0003A\n!\u0007\u0003\u0005\u0002!\tQ\"\u0001M\u0002)\u000e\u0011\u0001"}, strings={"createDebugLogger", "Lorg/jetbrains/debugger/MessagingLogger;", "key", "", "UtilKt"}, moduleName="script-debugger-backend")
public final class UtilKt {
    @Nullable
    public static final MessagingLogger createDebugLogger(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String debugFile = Registry.stringValue((String)key);
        if (StringsKt.isNullOrEmpty((CharSequence)debugFile)) {
            return null;
        }
        ConcurrentLinkedQueue<LogEntry> queue = new ConcurrentLinkedQueue<LogEntry>();
        MessagingLogger logger = new MessagingLogger(queue);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(debugFile, queue, logger){
            final /* synthetic */ String $debugFile;
            final /* synthetic */ ConcurrentLinkedQueue $queue;
            final /* synthetic */ MessagingLogger $logger;

            public final void run() {
                OutputStreamWriter writer;
                FileOutputStream out;
                block5: {
                    File file2 = new File(FileUtil.expandUserHome((String)this.$debugFile));
                    out = new FileOutputStream(file2);
                    writer = ByteStreamsKt.writer$default((OutputStream)out, null, (int)1);
                    writer.write("[\n");
                    writer.flush();
                    FileChannel fileChannel = out.getChannel();
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("HH.mm.ss,SSS");
                    while (true) {
                        Object message;
                        LogEntry entry;
                        if ((LogEntry)this.$queue.poll() == null) {
                            if (!this.$logger.getClosed$script_debugger_backend()) continue;
                            break block5;
                        }
                        writer.write("{" + "\"" + "timestamp" + "\"" + ": " + "\"" + dateFormatter.format(entry.getTime$script_debugger_backend()) + "\"" + ", ");
                        Object object = message = entry.getMessage();
                        if (object instanceof CharSequence) {
                            writer.write("\"" + entry.getMarker() + "\"" + ": ");
                            writer.flush();
                            if (message instanceof CharSequenceBackedByChars) {
                                fileChannel.write(((CharSequenceBackedByChars)((Object)message)).getByteBuffer());
                            } else {
                                fileChannel.write(CharsetToolkit.UTF8_CHARSET.encode(CharBuffer.wrap((CharSequence)message)));
                            }
                            writer.write("},\n");
                            writer.flush();
                            continue;
                        }
                        if (!(object instanceof ByteBuf)) break;
                        writer.write("\"" + entry.getMarker() + "\"" + ": ");
                        writer.flush();
                        ((ByteBuf)message).getBytes(((ByteBuf)message).readerIndex(), (OutputStream)out, ((ByteBuf)message).readableBytes());
                        ((ByteBuf)message).release();
                        writer.write("},\n");
                        writer.flush();
                    }
                    throw (Throwable)new RuntimeException("Unknown message type");
                }
                writer.write("]");
                out.close();
            }
            {
                this.$debugFile = string;
                this.$queue = concurrentLinkedQueue;
                this.$logger = messagingLogger;
            }
        });
        return logger;
    }
}

