/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.NonWatchableVariableContext;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.VariablesKt$processVariables$;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"}\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0001\u000b\u0005Aq\"\u0002\u0001\u0006\u0003!\u0005R\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u001d)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u000e>\u0011\t\u0001rA\u0007\u00021\u0011Ib\u0001#\u0003\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0015Ib\u0001c\u0003\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0019Ib\u0001#\u0004\u000e\t%\u0011\u0011\"\u0001\r\u00021\u001dI2\u0001c\u0004\u000e\u0003aAAka\u0001\u000e:!EQ\"\u0001\r\n3\u0019AI!\u0004\u0003\n\u0005%\t\u0001$\u0001\r\u00063\rA\u0019\"D\u0001\u0019\u0015e\u0019\u0001RC\u0007\u00021)I2\u0001C\u0006\u000e\u0003a]\u0011\u0004\u0002E\b\u001b\ta\t\u0001\u0007\u0005U\u0007\u0007ii\u0003b\u0002\t\u00125\t\u0001$C\r\u0007\u0011\u0013iA!\u0003\u0002\n\u0003a\t\u0001$B\r\u0004\u0011-i\u0011\u0001g\u0006\u001a\u000b\u0011\t\u0001rB\u0007\u0003\u0019\u0003A\u0002\u0002VB\u0002\u001bKAA\"\u0004\u0003\n\u0005%\t\u0001$\u0001\r\u00063\u0019AI!\u0004\u0003\n\u0005%\t\u0001$\u0001\r\u00063\rAy!D\u0001\u0019\u0011Q\u001b\u0019!d\b\u0005\u0003!eQ\"\u0001\r\u000b3\u0011AQ\"\u0004\u0002\r\u0002am\u0011\u0004\u0002\u0005\u000f\u001b\ta\t\u0001g\u0007U\u0007\u0007i9\u0005#\b\u000e\u000b%\u0011\u0011\"\u0001\r\u0002\u0019\u0003AR!\u0007\u0004\t\n5!\u0011BA\u0005\u00021\u0005AR!G\u0002\t\u001f5\t\u0001tD\r\u0004\u0011Ai\u0011\u0001g\u0006\u001a\u0007!=Q\"\u0001\r\t3\rA\t#D\u0001\u0019\u0015e\u0019\u0001\"E\u0007\u00021G!61A\u0007\u001f\u0011Ii)\"\u0003\u0004\n\u000bA\u0019QC\u0001G\u00011\u0011AB\u0001'\nR\u0007\u0005!1#G\u0002\t(5\t\u0001\u0004F\r\u0004\u0011=i\u0011\u0001g\b\u001a\u0007!\u0001R\"\u0001M\f3\rAI#D\u0001\u0019$Q\u001b\u0019!\u0004\u0019\t+5U\u0011BB\u0005\u0006!\r)\"\u0001$\u0001\u0019\ta!\u0001TE)\u0004\u0003\u0011\u0019\u0012d\u0001\u0005\u0011\u001b\u0005A:\"G\u0005\t\n59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u000ba\u0015\u0012d\u0001E\u0016\u001b\u0005Ab#G\b\t.5i\u0011BA\u0005\u00021!IQ!\u0003\u0003\n\u0005%\t\u0001$\u0001\r\u0006\u0013\tI\u0011\u0001\u0007\u0003\u0019/Q\u001b\u0019!e\u0006\u0005\u0003\"A\u0001!\u0004\u0003\n\u0005%\t\u0001$\u0001M\u0001#\u000e\tQ\u0001\u0001+\u0004\u0004EeA!\u0011\u0005\t\u00055)\u0001cA\u000b\u0003\u0019\u0003A*\u0001'\u0002R\u0007\u0005)\u0001\u0001VB\u0002"}, strings={"NATURAL_NAME_COMPARATOR", "Ljava/util/Comparator;", "Lorg/jetbrains/debugger/Variable;", "VariablesKt", "UNNAMED_FUNCTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "addAditionalVariables", "", "variables", "", "additionalVariables", "", "result", "", "memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "createVariablesList", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "from", "", "to", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "filterAndSort", "naturalCompare", "string1", "", "string2", "processNamedObjectProperties", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "context", "maxChildrenToAdd", "defaultIsLast", "", "processScopeVariables", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/annotations/NotNull;", "scope", "Lorg/jetbrains/debugger/Scope;", "isLast", "processVariables", "obsolescent", "Lorg/jetbrains/concurrency/Obsolescent;", "consumer", "Lkotlin/Function2;"}, moduleName="script-debugger-ui")
public final class VariablesKt {
    private static final Pattern UNNAMED_FUNCTION_PATTERN = Pattern.compile("^function[\\t ]*\\(");
    private static final Comparator<Variable> NATURAL_NAME_COMPARATOR = new Comparator<Variable>(){

        public int compare(@NotNull Variable o1, @NotNull Variable o2) {
            Intrinsics.checkParameterIsNotNull((Object)o1, (String)"o1");
            Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
            return VariablesKt.access$naturalCompare(o1.getName(), o2.getName());
        }
    };

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<Unit> processVariables(@NotNull VariableContext context, @NotNull Promise<List<? extends Variable>> variables, @NotNull Obsolescent obsolescent, @NotNull Function2<? super MemberFilter, ? super List<? extends Variable>, ? extends Unit> consumer) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull((Object)obsolescent, (String)"obsolescent");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Promise<MemberFilter> promise2 = context.getMemberFilter();
        return $receiver.thenAsync((AsyncFunction)new ValueNodeAsyncFunction<T, SUB_RESULT>(obsolescent, variables, obsolescent, consumer){
            final /* synthetic */ Promise $variables$inlined;
            final /* synthetic */ Obsolescent $obsolescent$inlined;
            final /* synthetic */ Function2 $consumer$inlined;

            /*
             * WARNING - void declaration
             */
            public Promise<SUB_RESULT> fun(T param) {
                void obsolescent;
                void $receiver;
                MemberFilter memberFilter = (MemberFilter)param;
                Promise promise2 = this.$variables$inlined;
                Obsolescent obsolescent2 = this.$obsolescent$inlined;
                return $receiver.then((Function)new ObsolescentFunction<T, SUB_RESULT>((Obsolescent)obsolescent, memberFilter, this){
                    final /* synthetic */ Obsolescent $obsolescent;
                    final /* synthetic */ MemberFilter $memberFilter$inlined;
                    final /* synthetic */ processVariables$$inlined$thenAsync$1 this$0;

                    public SUB_RESULT fun(T param) {
                        List it = (List)param;
                        Function2 function2 = this.this$0.$consumer$inlined;
                        MemberFilter memberFilter = this.$memberFilter$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)memberFilter, (String)"memberFilter");
                        function2.invoke((Object)memberFilter, (Object)it);
                        return (SUB_RESULT)Unit.INSTANCE;
                    }

                    public boolean isObsolete() {
                        return this.$obsolescent.isObsolete();
                    }
                    {
                        this.$obsolescent = obsolescent;
                        this.$memberFilter$inlined = memberFilter;
                        this.this$0 = var3_3;
                    }
                });
            }
            {
                void $super_call_param$1;
                this.$variables$inlined = promise2;
                this.$obsolescent$inlined = obsolescent2;
                this.$consumer$inlined = function2;
                super((Obsolescent)$super_call_param$1);
            }
        });
    }

    @NotNull
    public static final Promise<Unit> processScopeVariables(@NotNull Scope scope, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Promise<List<Variable>> promise2 = scope.getVariablesHost().get();
        Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"scope.variablesHost.get()");
        return VariablesKt.processVariables(context, promise2, (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, ? extends Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(context, node, isLast){
            final /* synthetic */ VariableContext $context;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLast;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)memberFilter, (String)"memberFilter");
                Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
                Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
                Object object = this.$context.getViewSupport().getVm();
                Value exceptionValue = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null && (object = object.getExceptionData()) != null ? object.getExceptionValue() : null;
                ArrayList<Variable> properties = new ArrayList<Variable>(variables.size() + additionalVariables.size() + (exceptionValue == null ? 0 : 1));
                Value value = exceptionValue;
                if (value != null) {
                    void $receiver;
                    Value value2 = value;
                    Value value3 = (Value)$receiver;
                    bl = properties.add(new VariableImpl("Exception", value3));
                } else {
                    bl = null;
                }
                SmartList functions = new SmartList();
                for (Variable variable : variables) {
                    if (!memberFilter.isMemberVisible(variable)) continue;
                    Value value3 = variable.getValue();
                    if (value3 != null && Intrinsics.areEqual((Object)((Object)value3.getType()), (Object)((Object)ValueType.FUNCTION)) && value3.getValueString() != null && !VariablesKt.access$getUNNAMED_FUNCTION_PATTERN$p().matcher(value3.getValueString()).lookingAt()) {
                        functions.add((Object)variable);
                        continue;
                    }
                    properties.add(variable);
                }
                Comparator comparator2 = memberFilter.hasNameMappings() ? (Comparator)new Comparator<T>(memberFilter){
                    final /* synthetic */ MemberFilter $memberFilter$inlined;

                    /*
                     * WARNING - void declaration
                     */
                    public int compare(T a, T b) {
                        void o2;
                        Variable variable = (Variable)b;
                        Variable o1 = (Variable)a;
                        return VariablesKt.access$naturalCompare(this.$memberFilter$inlined.rawNameToSource(o1), this.$memberFilter$inlined.rawNameToSource((Variable)o2));
                    }
                    {
                        this.$memberFilter$inlined = memberFilter;
                    }
                } : VariablesKt.access$getNATURAL_NAME_COMPARATOR$p();
                Collections.sort((List)properties, comparator2);
                Collections.sort((List)functions, comparator2);
                VariablesKt.access$addAditionalVariables(variables, additionalVariables, properties, memberFilter);
                if (!properties.isEmpty()) {
                    this.$node.addChildren(VariablesKt.createVariablesList((List<? extends Variable>)properties, this.$context, memberFilter), functions.isEmpty() && this.$isLast);
                }
                if (!functions.isEmpty()) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new VariablesGroup("Functions", (List)functions, this.$context)), this.$isLast);
                } else if (this.$isLast && properties.isEmpty()) {
                    this.$node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }
            {
                this.$context = variableContext;
                this.$node = xCompositeNode;
                this.$isLast = bl;
                super(2);
            }
        }));
    }

    @Nullable
    public static final List<Variable> processNamedObjectProperties(@NotNull List<? extends Variable> variables, @NotNull XCompositeNode node, @NotNull VariableContext context, @NotNull MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)memberFilter, (String)"memberFilter");
        List<Variable> list = VariablesKt.filterAndSort(variables, memberFilter);
        if (list.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = Math.min(maxChildrenToAdd, list.size());
        boolean isLast = to == list.size();
        node.addChildren(VariablesKt.createVariablesList(list, 0, to, context, memberFilter), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list.size() - to);
        return list;
    }

    @NotNull
    public static final List<Variable> filterAndSort(@NotNull List<? extends Variable> variables, @NotNull MemberFilter memberFilter) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull((Object)memberFilter, (String)"memberFilter");
        if (variables.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
        ArrayList<Variable> result2 = new ArrayList<Variable>(variables.size() + additionalVariables.size());
        for (Variable variable : variables) {
            if (!memberFilter.isMemberVisible(variable)) continue;
            result2.add(variable);
        }
        Collections.sort((List)result2, NATURAL_NAME_COMPARATOR);
        VariablesKt.addAditionalVariables(variables, additionalVariables, (List<Variable>)result2, memberFilter);
        return result2;
    }

    private static final void addAditionalVariables(List<? extends Variable> variables, Collection<? extends Variable> additionalVariables, List<Variable> result2, MemberFilter memberFilter) {
        block0: for (Variable variable : additionalVariables) {
            for (Variable variable2 : variables) {
                if (!Intrinsics.areEqual((Object)memberFilter.rawNameToSource(variable2), (Object)memberFilter.rawNameToSource(variable))) continue;
                continue block0;
            }
            result2.add(variable);
        }
    }

    private static final int naturalCompare(String string1, String string2) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit((char)ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit((char)ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit((char)string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit((char)string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (ch1 == ch2) continue;
            if (ch1 == '_') {
                return 1;
            }
            if (ch2 == '_') {
                return -1;
            }
            return ch1 - ch2;
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        return string1Length - string2Length;
    }

    @JvmOverloads
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull((Object)variableContext, (String)"variableContext");
        return VariablesKt.createVariablesList(variables, 0, variables.size(), variableContext, memberFilter);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ XValueChildrenList createVariablesList$default(List list, VariableContext variableContext, MemberFilter memberFilter, int n) {
        if ((n & 4) != 0) {
            memberFilter = null;
        }
        return VariablesKt.createVariablesList(list, variableContext, memberFilter);
    }

    @JvmOverloads
    @NotNull
    public static XValueChildrenList createVariablesList(@NotNull List<? extends Variable> list, @NotNull VariableContext variableContext) {
        return VariablesKt.createVariablesList$default(list, variableContext, null, 4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, int from, int to, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull((Object)variableContext, (String)"variableContext");
        XValueChildrenList list = new XValueChildrenList(to - from);
        VariableContext getterOrSetterContext = null;
        int n = from;
        int n2 = to - 1;
        if (n <= n2) {
            while (true) {
                String normalizedName;
                void i;
                Variable variable = variables.get((int)i);
                String string = normalizedName = memberFilter == null ? variable.getName() : memberFilter.rawNameToSource(variable);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"normalizedName");
                list.add((XNamedValue)new VariableView(string, variable, variableContext));
                if (variable instanceof ObjectProperty) {
                    if (((ObjectProperty)variable).getGetter() != null) {
                        if (getterOrSetterContext == null) {
                            getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                        }
                        String string2 = "get " + normalizedName;
                        FunctionValue functionValue = ((ObjectProperty)variable).getGetter();
                        if (functionValue == null) {
                            Intrinsics.throwNpe();
                        }
                        list.add((XNamedValue)VariableViewKt.VariableView(new VariableImpl(string2, functionValue), getterOrSetterContext));
                    }
                    if (((ObjectProperty)variable).getSetter() != null) {
                        if (getterOrSetterContext == null) {
                            getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                        }
                        String string3 = "set " + normalizedName;
                        FunctionValue functionValue = ((ObjectProperty)variable).getSetter();
                        if (functionValue == null) {
                            Intrinsics.throwNpe();
                        }
                        list.add((XNamedValue)VariableViewKt.VariableView(new VariableImpl(string3, functionValue), getterOrSetterContext));
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return list;
    }

    public static final /* synthetic */ Pattern access$getUNNAMED_FUNCTION_PATTERN$p() {
        return UNNAMED_FUNCTION_PATTERN;
    }

    public static final /* synthetic */ int access$naturalCompare(@Nullable String string1, @Nullable String string2) {
        return VariablesKt.naturalCompare(string1, string2);
    }

    @NotNull
    public static final /* synthetic */ Comparator access$getNATURAL_NAME_COMPARATOR$p() {
        return NATURAL_NAME_COMPARATOR;
    }

    public static final /* synthetic */ void access$addAditionalVariables(@NotNull List variables, @NotNull Collection additionalVariables, @NotNull List result2, @NotNull MemberFilter memberFilter) {
        VariablesKt.addAditionalVariables(variables, additionalVariables, result2, memberFilter);
    }
}

