/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.text.CharArrayCharSequence;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u00113)\u0001!B\u0001\t\t\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!5A\u0002A\r\u00021\u0003\t{\u0001B\u0006\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BAQ\u0010\t-I1\u0001#\u0002\u000e\u0003a\u0019\u0011b\u0001E\u0004\u001b\u0005AB!C\u0002\t\n5\t\u0001\u0004B)\u0004\u0003!)\u0011u\u0002\u0003\f\u0013\rA)!D\u0001\u0019\u0007E\u001b\u0011\u0001c\u0003&\u0019\u0011Y\u0001\u0002C\u0007\u00021#I2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AB!\u000b\u0006\u0005\u0007\"Aa!D\u0001\u0019\u000eq\u0019\u0013kA\u0002\u000e\u0005\u00119\u0001r\u0002"}, strings={"Lorg/jetbrains/io/CharSequenceBackedByChars;", "Lcom/intellij/util/text/CharArrayCharSequence;", "charBuffer", "Ljava/nio/CharBuffer;", "(Ljava/nio/CharBuffer;)V", "chars", "", "start", "", "end", "([CII)V", "([C)V", "byteBuffer", "Ljava/nio/ByteBuffer;", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "subSequence", ""}, moduleName="platform-impl")
public final class CharSequenceBackedByChars
extends CharArrayCharSequence {
    @NotNull
    public final ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = CharsetToolkit.UTF8_CHARSET.encode(CharBuffer.wrap(this.myChars, this.myStart, this.length()));
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"CharsetToolkit.UTF8_CHAR\u2026yChars, myStart, length))");
        return byteBuffer;
    }

    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharSequence charSequence;
        if (start == 0 && end == this.length()) {
            charSequence = (CharSequence)((Object)this);
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.myChars, (String)"myChars");
            charSequence = StringsKt.String((char[])this.myChars, (int)(this.myStart + start), (int)(end - start));
        }
        return charSequence;
    }

    public CharSequenceBackedByChars(@NotNull CharBuffer charBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)charBuffer, (String)"charBuffer");
        super(charBuffer.array(), charBuffer.arrayOffset(), charBuffer.position());
    }

    public CharSequenceBackedByChars(@NotNull char[] chars, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        super(chars, start, end);
    }

    public CharSequenceBackedByChars(@NotNull char[] chars) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        super(Arrays.copyOf(chars, chars.length));
    }
}

