/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyUtil;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"]\u0015\u0001Q!\u0001\u0005\b\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005iI\u0001C\u0003\u000e\u0003a-Ak!\u0002\u000e\u0012!1Q\"\u0001M\u00073\rAq!D\u0001\u0019\u0010Q\u001b)!$\u000b\u0005\u0007BA\u0001\"D\u0001\u0019\u0012U\t\u0001$CM\f\t\tA\u0019\"D\u0004\n\u0005%\t\u0001$C\u0005\u0003\u0013\u0005A\n\u0002\u0007\u0006Q\u0007\u0003!6QAG\u0007\u0011+i\u0011\u0001'\u0005\u0016\u0003a\u001dAk!\u0002\u000eR\u0011\u001d\u0001bC\u0007\u0003\u0019\u0003A:!F\u0001\u0019\fe%\u0001rC\u0007\u000211\u00016\u0011AM\t\t\u0005AI\"\u0004\u0003\n\u0003\u0011\rA\u0012\u0001\r\u000e!\u000e\t\u00114\u0002\u0003\u0002\u00117i\u0011\u0001\u0007\bQ\u0007\u0007I\u001a\u0002B\u0001\t\u001e5)\u0011BA\u0005\u00021?a\t\u0001G\bQ\u0007\t!6QAG\u0015\t\r\u0003\u0002\u0002E\u0007\u00021\u0017)\u0012\u0001g\u0003\u001a\u0018\u0011\u0011\u0001\u0012E\u0007\b\u0013\tI\u0011\u0001g\u0002\n\u0005%\t\u0001\u0014\u0003\r\u000b!\u000e\u0005Ak!\u0002\u000e\u000e!\tR\"\u0001M\t+\u0005A\u001a\u0003VB\u0003#7!1\t\u0003\u0005\u0001\u001b\u0005A\n!F\u0001\u0019\u0003q\u0019\u0013kA\u0002\u000e\u0005\u0011\r\u0001B\u0001+\u0004\u0006EmAa\u0011\u0005\t\u00075\t\u0001\u0014A\u000b\u00021\u000fa2%U\u0002\u0004\u001b\t!A\u0001#\u0003U\u0007\u000b\u0001"}, strings={"host", "", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "NettyKt", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "addListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "shutdownIfOio", "Lio/netty/channel/EventLoop;"}, moduleName="platform-impl")
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(Bootstrap $receiver, @NotNull Function1<? super Channel, ? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(group instanceof NioEventLoopGroup ? NioServerSocketChannel.class : OioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    public static final void addListener(ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, ? extends Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture future2) {
                ChannelFuture channelFuture = future2;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"future");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                condition = Conditions.alwaysFalse();
            }
            return NettyUtil.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            AsyncPromise<?> asyncPromise = promise2;
            Boolean bl = asyncPromise != null ? Boolean.valueOf(asyncPromise.setError(e)) : null;
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2) {
        if ((n2 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n, (Condition<Void>)condition);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, @NotNull AsyncPromise<?> asyncPromise, int n) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, n, null, 8);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, AsyncPromise<?> asyncPromise) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, 0, null, 12);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, InetSocketAddress inetSocketAddress) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, null, 0, null, 14);
    }

    @NotNull
    public static final String getUriScheme(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @NotNull
    public static final String getHost(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headers().getAsString(HttpHeaderNames.HOST)");
        return string;
    }
}

