/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IndexedValue;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"=\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\t\u0015\tA1\u0001\u0003\u0001\u0019\u0001\u0001*\"G\u0001\u0019\u0002u\t!RCQ\u0003#\u000e\t\u0001\"A\u0013\u0010\t\u0005A\u0019!\u0004\u0003\n\u0005%\t\u0001T\u0001\r\u00033\rA1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013)S\u0004B\u0001\t\u000b5\t\u00014B\r\u0006\u0011\u0019i1\u0001'\u0004*\u0003a9\u0011d\u0001\u0005\u0005\u001b\u0005AJ!G\u0002\t\u00105\t\u0001tA\r\u0007\u0011!iA!\u0003\u0002\n\u0003a\u0015\u0001DA\r\u0004\u0011#i\u0011\u0001G\u0005&%\u0011Y\u00012C\u0007\u00021\u0017IR\u0001\u0003\u0004\u000e\u0007a5\u0011&\u0001\r\b3\rA1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "getAlignmentInfo", "", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "populateRow", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "cellName", "alignmentInfo", "rowNumber", "", "processNode", "Alignment", "Companion"}, moduleName="intellij-markdown")
public final class TablesGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Alignment DEFAULT_ALIGNMENT;
    @NotNull
    public static final Regex SPLIT_REGEX;
    public static final Companion Companion;

    static {
        Object object;
        block2: {
            Companion = org.intellij.markdown.flavours.gfm.TablesGeneratingProvider$Companion.INSTANCE;
            Object[] $receiver$iv = (Object[])Alignment.values();
            Object[] $receiver$iv$iv = $receiver$iv;
            for (int i = 0; i < $receiver$iv$iv.length; ++i) {
                Object element$iv$iv = $receiver$iv$iv[i];
                Alignment it = (Alignment)((Object)element$iv$iv);
                if (!it.isDefault()) continue;
                object = element$iv$iv;
                break block2;
            }
            object = null;
        }
        Alignment alignment = (Alignment)((Object)object);
        if (alignment == null) {
            throw (Throwable)new IllegalStateException("Must me default alignment");
        }
        DEFAULT_ALIGNMENT = alignment;
        SPLIT_REGEX = new Regex("\\|");
    }

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PreconditionsKt.assert((boolean)Intrinsics.areEqual((Object)node.getType(), (Object)GFMElementTypes.Companion.getTABLE()));
        List<Alignment> alignmentInfo = this.getAlignmentInfo(text, node);
        int rowsPopulated = 0;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "table", new CharSequence[0], false, 8);
        for (ASTNode child : node.getChildren()) {
            if (Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.Companion.getHEADER())) {
                visitor.consumeHtml("<thead>");
                this.populateRow(visitor, child, "th", alignmentInfo, -1);
                visitor.consumeHtml("</thead>");
                continue;
            }
            if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.Companion.getROW())) continue;
            if (rowsPopulated == 0) {
                visitor.consumeHtml("<tbody>");
            }
            this.populateRow(visitor, child, "td", alignmentInfo, ++rowsPopulated);
        }
        if (rowsPopulated > 0) {
            visitor.consumeHtml("</tbody>");
        }
        visitor.consumeTagClose("table");
    }

    /*
     * WARNING - void declaration
     */
    private final void populateRow(HtmlGenerator.HtmlGeneratingVisitor visitor, ASTNode node, String cellName, List<Alignment> alignmentInfo, int rowNumber) {
        Object alignment;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        String parityAttribute = rowNumber > 0 && rowNumber % 2 == 0 ? "class=\"intellij-row-even\"" : (String)null;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "tr", new CharSequence[]{parityAttribute}, false, 8);
        Iterable iterable = node.getChildren();
        void var10_8 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.INSTANCE.getCELL())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IndexedValue child : CollectionsKt.withIndex((Iterable)((List)destination$iv$iv))) {
            if (child.getIndex() >= alignmentInfo.size()) {
                throw (Throwable)new IllegalStateException("Too many cells in a row! Should check parser.");
            }
            alignment = alignmentInfo.get(child.getIndex());
            String alignmentAttribute = ((Alignment)((Object)alignment)).isDefault() ? (String)null : "align=" + "\"" + ((Alignment)((Object)alignment)).getHtmlName() + "\"";
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, (ASTNode)child.getValue(), cellName, new CharSequence[]{alignmentAttribute}, false, 8);
            visitor.visitNode((ASTNode)child.getValue());
            visitor.consumeTagClose(cellName);
        }
        alignment = node.getChildren();
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            ASTNode it = (ASTNode)element$iv;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.INSTANCE.getCELL())) continue;
            ++count$iv;
        }
        int child = count$iv;
        int n = alignmentInfo.size() - 1;
        if (child <= n) {
            while (true) {
                void i;
                visitor.consumeHtml("<td></td>");
                if (i == n) break;
                ++i;
            }
        }
        visitor.consumeTagClose("tr");
    }

    /*
     * WARNING - void declaration
     */
    private final List<Alignment> getAlignmentInfo(String text, ASTNode node) {
        ArrayList<Alignment> result;
        block7: {
            ASTNode aSTNode = ASTUtilKt.findChildOfType(node, GFMTokenTypes.INSTANCE.getTABLE_SEPARATOR());
            if (aSTNode == null) {
                throw (Throwable)new IllegalStateException("Could not find table separator");
            }
            ASTNode separatorRow = aSTNode;
            result = new ArrayList<Alignment>();
            List cells = Regex.split$default((Regex)Companion.getSPLIT_REGEX(), (CharSequence)ASTUtilKt.getTextInNode(separatorRow, text), (int)0, (int)2);
            IntRange intRange = CollectionsKt.getIndices((Collection)cells);
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            if (n > n2) break block7;
            while (true) {
                void i;
                block9: {
                    String cell;
                    block8: {
                        if (!StringsKt.isBlank((CharSequence)(cell = (String)cells.get((int)i)))) break block8;
                        void v2 = i;
                        boolean bl = true;
                        if (v2 < true) {
                            bl = false;
                        }
                        boolean bl2 = true;
                        if (v2 > CollectionsKt.getLastIndex((List)cells) - 1) {
                            bl2 = false;
                        }
                        if (!(bl & bl2)) break block9;
                    }
                    String trimmed = StringsKt.trim((String)cell);
                    boolean starts = StringsKt.startsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2);
                    boolean ends = StringsKt.endsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2);
                    result.add(starts && ends ? Alignment.CENTER : (starts ? Alignment.LEFT : (ends ? Alignment.RIGHT : Companion.getDEFAULT_ALIGNMENT())));
                }
                if (i == n2) break;
                ++i;
            }
        }
        return result;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0019\u0015\tA\"A\u0003\u0002\u0011!)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0006\u000b\u0005!9\u0001Bb\u0001\u0019\u0001IB!\u0003\u0002\n\u0003a\u0001\u0001\u0014AQ\u000f\t\u0005II\u0001C\u0001\u000e\u0003a\r\u0001kA\u0001\n\n!\u0011Q\"\u0001M\u0003!\u000e\r\u0011kA\u0001\t\u0007%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001C\u0004\u0011\u0011I#\u0002B\"\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0005!%\u00117AC\u0006\r\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "", "htmlName", "", "isDefault", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getHtmlName", "()Ljava/lang/String;", "()Z", "LEFT", "CENTER", "RIGHT"}, moduleName="intellij-markdown")
    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT;
        public static final /* enum */ Alignment CENTER;
        public static final /* enum */ Alignment RIGHT;
        private static final /* synthetic */ Alignment[] $VALUES;
        @NotNull
        private final String htmlName;
        private final boolean isDefault;

        static {
            Alignment[] alignmentArray = new Alignment[3];
            Alignment[] alignmentArray2 = alignmentArray;
            alignmentArray[0] = LEFT = new Alignment("left", true);
            alignmentArray[1] = CENTER = new Alignment("center", false);
            alignmentArray[2] = RIGHT = new Alignment("right", false);
            $VALUES = alignmentArray;
        }

        @NotNull
        public final String getHtmlName() {
            return this.htmlName;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        protected Alignment(String htmlName, boolean isDefault) {
            Intrinsics.checkParameterIsNotNull((Object)htmlName, (String)"htmlName");
            this.htmlName = htmlName;
            this.isDefault = isDefault;
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String string) {
            return Enum.valueOf(Alignment.class, string);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0015\f\t\rC\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%ZAa\u0011\u0005\t\b5\t\u0001\u0004B)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u0013AQ\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Companion;", "", "()V", "DEFAULT_ALIGNMENT", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "getDEFAULT_ALIGNMENT", "()Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Alignment getDEFAULT_ALIGNMENT() {
            return DEFAULT_ALIGNMENT;
        }

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

