/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.CharsKt;
import kotlin.CollectionsKt;
import kotlin.IndexedValue;
import kotlin.IntRange;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0001\u0013C\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002u\u0005\t\")\u0002R\u0007\u0005A\u0019!J\u000b\u0005\u0017!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\u001a\u000b!\u001dQb\u0001\r\u0005S\u0005AJ!G\u0002\t\u000b5\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001G\u0001&\u001d\u0011Y\u0001RB\u0007\u00021\u001dIR\u0001c\u0002\u000e\u0007a!\u0011&\u0001M\u00053\rAy!D\u0001\u0019\u0011\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion"}, moduleName="intellij-markdown")
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final String WHSP = "[ \\t]*";
    @NotNull
    public static final Function1<String, String> NOT_CHARS;
    @NotNull
    public static final String NONCONTROL = "(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])";
    @NotNull
    public static final String LINK_DESTINATION = "(?:<(?:\\\\[<>]|[^<>\\n])*>|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\((?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\)(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])+)";
    @NotNull
    public static final String LINK_TITLE;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider$Companion.INSTANCE;
        WHSP = WHSP;
        NOT_CHARS = Companion.NOT_CHARS.1.INSTANCE;
        NONCONTROL = NONCONTROL;
        LINK_DESTINATION = "(?:<(?:" + "\\" + "\\" + "[<>]|[^<>" + "\\" + "n])*>|" + Companion.getNONCONTROL() + "*" + "\\" + "(" + Companion.getNONCONTROL() + "*" + "\\" + ")" + Companion.getNONCONTROL() + "*|" + Companion.getNONCONTROL() + "+)";
        LINK_TITLE = "(?:" + "\"" + (String)Companion.getNOT_CHARS().invoke((Object)"\"") + "\"" + "|'" + (String)Companion.getNOT_CHARS().invoke((Object)"'") + "'|" + "\\" + "(" + (String)Companion.getNOT_CHARS().invoke((Object)"\\)") + "\\" + "))";
    }

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list = Companion.matchLinkDefinition(pos.getTextFromPosition());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)matchResult)) {
            IElementType iElementType;
            int i = indexedValue.component1();
            IntRange range = (IntRange)indexedValue.component2();
            IntRange intRange = Companion.addToRangeAndWiden(range, pos.getOffset());
            switch (i) {
                case 0: {
                    iElementType = MarkdownElementTypes.Companion.getLINK_LABEL();
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.Companion.getLINK_DESTINATION();
                    break;
                }
                case 2: {
                    iElementType = MarkdownElementTypes.Companion.getLINK_TITLE();
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)"There are no more than three groups in this regex"));
                }
            }
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(intRange, iElementType)));
        }
        int matchLength = ((Number)((IntRange)CollectionsKt.last(matchResult)).getEndInclusive()).intValue() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0004\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\u0003\u0006\u0001\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001#\u0004\u0006\u0003\u0011\rAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K-A\t\"D\u0001\u0019\u0013e\u0019\u00012C\u0007\u00021%I2\u0001\u0003\u0006\u000e\u0003aUQ%\u0003\u0005\f\u001b\u0005A:\"G\u0003\t\u00195\u0019\u0001\u0014D\u0015\u000215)3\u0002c\u0007\u000e\u000b%\u0011\u0011\"\u0001\r\n\u0019\u0003Ab\"G\u0002\t\u001e5\t\u0001dD\u0013\r\u0011?i!\u0001$\u0001\u0019\u0013e\u0019\u0001RD\u0007\u00021=I2\u0001\u0003\t\u000e\u0003aUQ\u0005\u0004\u0003\u0002\u0011Ci\u0011\u0001'\u0006\u001a\u0007!uQ\"\u0001\r\u00103\rA\u0001#D\u0001\u0019\u0016%^Aa\u0011%\u0002\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011\u0015\u0001bA\u0015\f\t\rC\u0001rA\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\u0002\u0003\t\u0007%^Aa\u0011%\u0002\u0011\u0013i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011)\u0001bA\u0015\u0012\t\rC\u00012B\u0007\b\u0013\tI\u0011\u0001\u0007\u0002\n\u0005%\t\u0001D\u0001\r\u0007#\u000e)Q!\u0001G\u0001\u001b\t!i\u0001C\u0004*\u0018\u0011\u0019\u0005*\u0001E\b\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0011!\u0019\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "LINK_DESTINATION", "", "getLINK_DESTINATION", "()Ljava/lang/String;", "LINK_TITLE", "getLINK_TITLE", "NONCONTROL", "getNONCONTROL", "NOT_CHARS", "Lkotlin/Function1;", "getNOT_CHARS", "()Lkotlin/jvm/functions/Function1;", "WHSP", "getWHSP", "addToRangeAndWiden", "Lkotlin/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "matchLinkDefinition", "", "text", "", "matchLinkLabel", "start", "passOneNewline"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getWHSP() {
            return WHSP;
        }

        @NotNull
        public final Function1<String, String> getNOT_CHARS() {
            return NOT_CHARS;
        }

        @NotNull
        public final String getNONCONTROL() {
            return NONCONTROL;
        }

        @NotNull
        public final String getLINK_DESTINATION() {
            return LINK_DESTINATION;
        }

        @NotNull
        public final String getLINK_TITLE() {
            return LINK_TITLE;
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return new IntRange(((Number)range.getStart()).intValue() + t, ((Number)range.getEndInclusive()).intValue() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text) {
            void offset;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            int times$iv = 3;
            int n = 0;
            int n2 = times$iv - 1;
            if (n <= n2) {
                void index$iv;
                do {
                    void it = ++index$iv;
                    if (offset.element < text.length() && text.charAt(offset.element) == ' ') {
                        int n3 = offset.element++;
                    }
                } while (index$iv != n2);
            }
            IntRange intRange = this.matchLinkLabel(text, offset.element);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset.element = ((Number)linkLabel.getEndInclusive()).intValue() + 1;
            if (offset.element >= text.length() || text.charAt(offset.element) != ':') {
                return null;
            }
            int n4 = offset.element++;
            offset.element = this.passOneNewline(text, offset.element);
            MatchResult matchResult = Regex.find$default((Regex)new Regex("^" + this.getLINK_DESTINATION()), (CharSequence)text.subSequence(offset.element, text.length()), (int)0, (int)2);
            if (matchResult == null) {
                return null;
            }
            MatchResult destination = matchResult;
            IntRange destinationRange = new IntRange(((Number)destination.getRange().getStart()).intValue() + offset.element, ((Number)destination.getRange().getEndInclusive()).intValue() + offset.element);
            offset.element += ((Number)destination.getRange().getEndInclusive()).intValue() - ((Number)destination.getRange().getStart()).intValue() + 1;
            offset.element = this.passOneNewline(text, offset.element);
            MatchResult title = Regex.find$default((Regex)new Regex("^" + this.getLINK_TITLE()), (CharSequence)text.subSequence(offset.element, text.length()), (int)0, (int)2);
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            result.add(linkLabel);
            result.add(destinationRange);
            if (title != null) {
                IntRange titleRange = new IntRange(((Number)title.getRange().getStart()).intValue() + offset.element, ((Number)title.getRange().getEndInclusive()).intValue() + offset.element);
                offset.element += ((Number)title.getRange().getEndInclusive()).intValue() - ((Number)title.getRange().getStart()).intValue() + 1;
                while (offset.element < text.length()) {
                    void $receiver$iv;
                    Character c = Character.valueOf(text.charAt(offset.element));
                    char it = ((Character)$receiver$iv).charValue();
                    if (!(it == ' ' || it == '\t')) break;
                    int n5 = offset.element++;
                }
                if (offset.element >= text.length() || text.charAt(offset.element) == '\n') {
                    result.add(titleRange);
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text, int start) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int offset = start;
            if (offset >= text.length() || text.charAt(offset) != '[') {
                return null;
            }
            ++offset;
            boolean seenNonWhitespace = false;
            int n = 1;
            int n2 = 999;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (offset >= text.length()) {
                        return null;
                    }
                    char c = text.charAt(offset);
                    if (c == '[' || c == ']') break;
                    if (c == '\\') {
                        if (++offset >= text.length()) {
                            return null;
                        }
                        c = text.charAt(offset);
                    }
                    if (!CharsKt.isWhitespace((char)c)) {
                        seenNonWhitespace = true;
                    }
                    ++offset;
                    if (i == n2) break;
                    ++i;
                }
            }
            if (!seenNonWhitespace || offset >= text.length() || text.charAt(offset) != ']') {
                return null;
            }
            return new IntRange(start, offset);
        }

        private final int passOneNewline(CharSequence text, int start) {
            char it;
            Character $receiver$iv;
            int offset;
            for (offset = start; offset < text.length(); ++offset) {
                Character c = Character.valueOf(text.charAt(offset));
                it = ((Character)$receiver$iv).charValue();
                if (!(it == ' ' || it == '\t')) break;
            }
            if (offset < text.length() && text.charAt(offset) == '\n') {
                ++offset;
                while (offset < text.length()) {
                    $receiver$iv = Character.valueOf(text.charAt(offset));
                    it = $receiver$iv.charValue();
                    if (!(it == ' ' || it == '\t')) break;
                    ++offset;
                }
            }
            return offset;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

