/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.tools.perflib.vmtrace.MethodProfileData;
import java.util.Locale;

public class MethodInfo {
    public final long id;
    public final String className;
    public final String methodName;
    public final String signature;
    public final String srcPath;
    public final int srcLineNumber;
    private MethodProfileData mProfileData;
    private String mFullName;
    private String mShortName;

    public MethodInfo(long id, String className, String methodName, String signature, String srcPath, int srcLineNumber) {
        this.id = id;
        this.className = className;
        this.methodName = methodName;
        this.signature = signature;
        this.srcPath = srcPath;
        this.srcLineNumber = srcLineNumber;
    }

    public String getFullName() {
        if (this.mFullName == null) {
            this.mFullName = String.format(Locale.US, "%s.%s: %s", this.className, this.methodName, this.signature);
        }
        return this.mFullName;
    }

    public String getShortName() {
        if (this.mShortName == null) {
            this.mShortName = String.format(Locale.US, "%s.%s", this.getUnqualifiedClassName(), this.methodName);
        }
        return this.mShortName;
    }

    private String getUnqualifiedClassName() {
        String cn = this.className;
        int i = cn.lastIndexOf(47);
        if (i > 0) {
            cn = cn.substring(i + 1);
        }
        return cn;
    }

    public MethodProfileData getProfileData() {
        return this.mProfileData;
    }

    public void setProfileData(MethodProfileData profileData) {
        this.mProfileData = profileData;
    }
}

