/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.debugText;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegationSpecifier;
import org.jetbrains.kotlin.psi.KtDelegationSpecifierList;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0006)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005A\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A\t\"B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0011\t\u0017\u0001\u0004\u0001\u001a\u000f%\u0011\u0011\"\u0001\r\u0002\u0013\tI\u0011\u0001g\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\u0011Q\u0015\u0005\u0005\u0005\u001b\ta\t\u0001G\u0001\u001a\u0018!%Q2C\u0005\u0003\u0013\u0005AZ!\u0003\u0002\n\u0003a\r\u0001$B)\u0004\u0003\u00111Q\u0015\u0007E\u0007\u001b\ta\t\u0001G\u0001\u001a\u000b!9QbA\u0005\u0002\t\u0007Az!G\u0006\t\u001151\u0011\u0002\u0002C\u0001\u0013\ta\t\u0001G\u0005\u0019\u0012E\u0011A\u0012\u0001\r\n#\u000e\t\u00012C\u0013\u0019\u0011)i!\u0001$\u0001\u0019\u0003e)\u0001bB\u0007\u0004\u0013\u0005!\u0019\u0001g\u0004\u001a\u0007!UQ\"\u0001\r\u00023\u0011!\u0011\u0001C\u0006\u000e\u0003a\t\u0011\u0004\u0002\u0003\u0002\u0011/i\u0011\u0001G\u0001&\"\u0011Y\u0001\u0002D\u0007\u0003\u0019\u0003A\u0012!G\u0002\t\u001a5\t\u0001$D\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\b&\"\u0011Y\u0001RD\u0007\u0003\u0019\u0003A\u0012!G\u0002\t\u001f5\t\u0001tD\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\t&\"\u0011Y\u0001\u0012E\u0007\u0003\u0019\u0003A\u0012!G\u0002\t#5\t\u00014E\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\n&\"\u0011Y\u0001RE\u0007\u0003\u0019\u0003A\u0012!G\u0002\t'5\t\u0001tE\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u000b&\"\u0011Y\u0001\u0012F\u0007\u0003\u0019\u0003A\u0012!G\u0002\t+5\t\u00014F\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\f&\"\u0011Y\u0001RF\u0007\u0003\u0019\u0003A\u0012!G\u0002\t/5\t\u0001tF\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\r&\"\u0011Y\u0001\u0012G\u0007\u0003\u0019\u0003A\u0012!G\u0002\t35\t\u00014G\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u000e&\"\u0011Y\u0001RG\u0007\u0003\u0019\u0003A\u0012!G\u0002\t75\t\u0001tG\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u000f&\"\u0011Y\u0001\u0012H\u0007\u0003\u0019\u0003A\u0012!G\u0002\t;5\t\u00014H\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0010&\"\u0011Y\u0001RH\u0007\u0003\u0019\u0003A\u0012!G\u0002\t?5\t\u0001tH\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0011&\"\u0011Y\u0001\u0012I\u0007\u0003\u0019\u0003A\u0012!G\u0002\tC5\t\u00014I\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0012&\"\u0011Y\u0001RI\u0007\u0003\u0019\u0003A\u0012!G\u0002\tG5\t\u0001tI\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0013&\"\u0011Y\u0001\u0012J\u0007\u0003\u0019\u0003A\u0012!G\u0002\tK5\t\u00014J\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0014&\"\u0011Y\u0001RJ\u0007\u0003\u0019\u0003A\u0012!G\u0002\tO5\t\u0001tJ\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0015&\"\u0011Y\u0001\u0012K\u0007\u0003\u0019\u0003A\u0012!G\u0002\t75\t\u0001$K\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001c\u0015&\"\u0011Y\u0001BK\u0007\u0003\u0019\u0003A\u0012!G\u0002\t\u000f5\t\u0001$C\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001#\u0016&\"\u0011Y\u0001bK\u0007\u0003\u0019\u0003A\u0012!G\u0002\tX5\t\u0001\u0004L\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001#\u0017&\"\u0011Y\u0001\"L\u0007\u0003\u0019\u0003A\u0012!G\u0002\t75\t\u00014L\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0018&\"\u0011Y\u0001RL\u0007\u0003\u0019\u0003A\u0012!G\u0002\t_5\t\u0001tL\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0019&\"\u0011Y\u0001\u0012M\u0007\u0003\u0019\u0003A\u0012!G\u0002\tc5\t\u00014M\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u001a&\"\u0011Y\u0001RM\u0007\u0003\u0019\u0003A\u0012!G\u0002\tg5\t\u0001tM\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u001b&\"\u0011Y\u0001\u0012N\u0007\u0003\u0019\u0003A\u0012!G\u0002\tk5\t\u00014N\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u001c&\"\u0011Y\u0001RN\u0007\u0003\u0019\u0003A\u0012!G\u0002\t75\t\u0001dN\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001c\u001c&\"\u0011Y\u0001\u0002O\u0007\u0003\u0019\u0003A\u0012!G\u0002\tr5\t\u0001$O\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001c\u001d&\"\u0011Y\u0001BO\u0007\u0003\u0019\u0003A\u0012!G\u0002\tv5\t\u0001dO\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001c\u001e&\"\u0011Y\u0001\u0002P\u0007\u0003\u0019\u0003A\u0012!G\u0002\t;5\t\u0001\u0014P\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001C\u001f&\"\u0011Y\u00012P\u0007\u0003\u0019\u0003A\u0012!G\u0002\t}5\t\u0001TP\r\u0005\u00117i!\u0001$\u0001\u0019\u0004E\u001b\u0011\u0001C &%\u0011Y\u0001rP\u0007\u0003\u0019\u0003A\u0012!\u0007\u0003\t\u0001\u0004i\u0019\u0001'a\u00013\u0011AY\"\u0004\u0002\r\u0002a\r\u0011ka\u0001\t\u0003\u0004)#\u0003B\u0006\t\u0004\u0004i!\u0001$\u0001\u0019\u0003e\u001d\u0001bGG\u00021\t\u0007\u0011\u0004\u0002E\u000e\u001b\ta\t\u0001g\u0001R\u0007\u0007A)\u0019A\u0013\u0013\t-A1\u0019A\u0007\u0003\u0019\u0003A\u0012!g\u0002\tk5\r\u0001t1\u0001\u001a\t!mQB\u0001G\u00011\u0007\t61\u0001\u0005E\u0002\u0015\u0012Ba\u0003EE\u00025\u0011A\u0012\u0001\r\u00023\u000fA1$d\u0001\u0019\u000b\u0004IB\u0001c\u0007\u000e\u00051\u0005\u00014A)\u0004\u0004!-\r!*\n\u0005\u0017!1\r!\u0004\u0002\r\u0002a\t\u0011\u0004\u0002EG\u00025\r\u0001d2\u0001\u001a\t!mQB\u0001G\u00011\u0007\t61\u0001EH\u0002\u0015\u0016Ba\u0003\u0005I\u00025\u0011A\u0012\u0001\r\u00023\u0011A\t\u001aAG\u00021%\u0007\u0011\u0004\u0002E\u000e\u001b\ta\t\u0001g\u0001R\u0007\u0007A\u0019\u001aAS\u0013\t-A!\u001aA\u0007\u0003\u0019\u0003A\u0012!\u0007\u0003\t\u0016\u0004i\u0019\u0001Gf\u00013\u0011AY\"\u0004\u0002\r\u0002a\r\u0011ka\u0001\t\u0018\u0004I\u001b\u0002B!\t\u0011\u000bi9\u0001G\u0002R\u0007\u0005!9!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/psi/debugText/DebugTextBuildingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildText", "body", "Lkotlin/Function1;", "Ljava/lang/StringBuilder;", "Lkotlin/Extension;", "render", "element", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "relevantChildren", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;[Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/lang/String;", "renderChildren", "separator", "prefix", "postfix", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotation;", "data", "(Lorg/jetbrains/kotlin/psi/KtAnnotation;Lkotlin/Unit;)Ljava/lang/String;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitAnonymousInitializer", "initializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "(Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;Lkotlin/Unit;)Ljava/lang/String;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Ljava/lang/String;", "visitClassBody", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "(Lorg/jetbrains/kotlin/psi/KtClassBody;Lkotlin/Unit;)Ljava/lang/String;", "visitConstructorCalleeExpression", "constructorCalleeExpression", "Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitDelegationSpecifier", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifier;", "(Lorg/jetbrains/kotlin/psi/KtDelegationSpecifier;Lkotlin/Unit;)Ljava/lang/String;", "visitDelegationSpecifierList", "list", "Lorg/jetbrains/kotlin/psi/KtDelegationSpecifierList;", "(Lorg/jetbrains/kotlin/psi/KtDelegationSpecifierList;Lkotlin/Unit;)Ljava/lang/String;", "visitDotQualifiedExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "(Lorg/jetbrains/kotlin/psi/KtDynamicType;Lkotlin/Unit;)Ljava/lang/String;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitFunctionType", "functionType", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtFunctionType;Lkotlin/Unit;)Ljava/lang/String;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;Lkotlin/Unit;)Ljava/lang/String;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "(Lorg/jetbrains/kotlin/psi/KtImportList;Lkotlin/Unit;)Ljava/lang/String;", "visitInitializerList", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "(Lorg/jetbrains/kotlin/psi/KtInitializerList;Lkotlin/Unit;)Ljava/lang/String;", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Ljava/lang/String;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/Unit;)Ljava/lang/String;", "visitModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "(Lorg/jetbrains/kotlin/psi/KtModifierList;Lkotlin/Unit;)Ljava/lang/String;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Ljava/lang/String;", "visitNullableType", "nullableType", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "(Lorg/jetbrains/kotlin/psi/KtNullableType;Lkotlin/Unit;)Ljava/lang/String;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Ljava/lang/String;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Ljava/lang/String;", "visitParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "(Lorg/jetbrains/kotlin/psi/KtParameterList;Lkotlin/Unit;)Ljava/lang/String;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Ljava/lang/String;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Ljava/lang/String;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeArgumentList", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeConstraint", "constraint", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraint;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeConstraintList", "Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeParameterList", "Lorg/jetbrains/kotlin/psi/KtTypeParameterList;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameterList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "(Lorg/jetbrains/kotlin/psi/KtTypeProjection;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lkotlin/Unit;)Ljava/lang/String;", "visitUserType", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "(Lorg/jetbrains/kotlin/psi/KtUserType;Lkotlin/Unit;)Ljava/lang/String;"}, moduleName="kotlin-compiler")
public final class DebugTextBuildingVisitor
extends KtVisitor<String, Unit> {
    private static final Logger LOG;
    public static final DebugTextBuildingVisitor INSTANCE;
    public static final DebugTextBuildingVisitor INSTANCE$;

    @Override
    @Nullable
    public String visitKtFile(@NotNull KtFile file, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return "STUB file: " + file.getName();
    }

    @Override
    @Nullable
    public String visitKtElement(@NotNull KtElement element, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        if (element instanceof KtElementImplStub) {
            LOG.error("getDebugText() is not defined for " + ((KtElementImplStub)element).getClass());
        }
        return element.getText();
    }

    @Override
    @Nullable
    public String visitImportDirective(@NotNull KtImportDirective importDirective, @Nullable Unit data) {
        String string;
        Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
        ImportPath importPath = importDirective.getImportPath();
        if (importPath == null) {
            return "import <invalid>";
        }
        if (importPath.hasAlias()) {
            StringBuilder stringBuilder = new StringBuilder().append(" as ");
            Name name = importPath.getAlias();
            if (name == null) {
                Intrinsics.throwNpe();
            }
            string = stringBuilder.append(name.asString()).toString();
        } else {
            string = "";
        }
        String aliasStr = string;
        return "import " + importPath.getPathStr() + aliasStr;
    }

    @Override
    @Nullable
    public String visitImportList(@NotNull KtImportList importList, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(importList, "importList");
        return DebugTextBuildingVisitor.renderChildren$default(this, importList, "\n", null, null, 12);
    }

    @Override
    @Nullable
    public String visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(annotationEntry, "annotationEntry");
        return this.render(annotationEntry, annotationEntry.getCalleeExpression(), annotationEntry.getTypeArgumentList());
    }

    @Override
    @Nullable
    public String visitTypeReference(@NotNull KtTypeReference typeReference, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        return DebugTextBuildingVisitor.renderChildren$default(this, typeReference, " ", null, null, 12);
    }

    @Override
    @Nullable
    public String visitTypeArgumentList(@NotNull KtTypeArgumentList typeArgumentList, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(typeArgumentList, "typeArgumentList");
        return this.renderChildren(typeArgumentList, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitTypeConstraintList(@NotNull KtTypeConstraintList list, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(list, "list");
        return this.renderChildren(list, ", ", "where ", "");
    }

    @Override
    @Nullable
    public String visitUserType(@NotNull KtUserType userType, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        return this.render(userType, userType.getQualifier(), userType.getReferenceExpression(), userType.getTypeArgumentList());
    }

    @Override
    @Nullable
    public String visitDynamicType(@NotNull KtDynamicType type2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return "dynamic";
    }

    @Override
    @Nullable
    public String visitAnnotation(@NotNull KtAnnotation annotation2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        return this.renderChildren(annotation2, " ", "[", "]");
    }

    @Override
    @Nullable
    public String visitConstructorCalleeExpression(@NotNull KtConstructorCalleeExpression constructorCalleeExpression, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(constructorCalleeExpression, "constructorCalleeExpression");
        return this.render(constructorCalleeExpression, constructorCalleeExpression.getConstructorReferenceExpression());
    }

    @Override
    @Nullable
    public String visitDelegationSpecifier(@NotNull KtDelegationSpecifier specifier, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(specifier, "specifier");
        return this.render(specifier, specifier.getTypeReference());
    }

    @Override
    @Nullable
    public String visitDelegationSpecifierList(@NotNull KtDelegationSpecifierList list, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(list, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list, ", ", null, null, 12);
    }

    @Override
    @Nullable
    public String visitTypeParameterList(@NotNull KtTypeParameterList list, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(list, "list");
        return this.renderChildren(list, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return DebugTextBuildingVisitor.renderChildren$default(this, expression, ".", null, null, 12);
    }

    @Override
    @Nullable
    public String visitInitializerList(@NotNull KtInitializerList list, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(list, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list, ", ", null, null, 12);
    }

    @Override
    @Nullable
    public String visitParameterList(@NotNull KtParameterList list, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(list, "list");
        return this.renderChildren(list, ", ", "(", ")");
    }

    @Override
    @Nullable
    public String visitEnumEntry(@NotNull KtEnumEntry enumEntry, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(enumEntry){
            final /* synthetic */ KtEnumEntry $enumEntry;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$enumEntry.getModifierList(), null, " ", 2);
                $receiver.append("enum entry ");
                DebugTextUtilKt.appendInn$default($receiver, this.$enumEntry.getNameAsName(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$enumEntry.getInitializerList(), " : ", null, 4);
            }
            {
                this.$enumEntry = ktEnumEntry;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitFunctionType(@NotNull KtFunctionType functionType, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(functionType, "functionType");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(functionType){
            final /* synthetic */ KtFunctionType $functionType;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                DebugTextUtilKt.appendInn$default($receiver, this.$functionType.getReceiverTypeReference(), null, ".", 2);
                DebugTextUtilKt.appendInn$default($receiver, this.$functionType.getParameterList(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$functionType.getReturnTypeReference(), " -> ", null, 4);
            }
            {
                this.$functionType = ktFunctionType;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeParameter(@NotNull KtTypeParameter parameter, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(parameter){
            final /* synthetic */ KtTypeParameter $parameter;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                DebugTextUtilKt.appendInn$default($receiver, this.$parameter.getModifierList(), null, " ", 2);
                DebugTextUtilKt.appendInn$default($receiver, this.$parameter.getNameAsName(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$parameter.getExtendsBound(), " : ", null, 4);
            }
            {
                this.$parameter = ktTypeParameter;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeProjection(@NotNull KtTypeProjection typeProjection, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(typeProjection){
            final /* synthetic */ KtTypeProjection $typeProjection;

            public final void invoke(StringBuilder $receiver) {
                KtSingleValueToken token;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                KtSingleValueToken ktSingleValueToken = token = this.$typeProjection.getProjectionKind().getToken();
                DebugTextUtilKt.appendInn$default($receiver, ktSingleValueToken != null ? ktSingleValueToken.getValue() : null, null, null, 6);
                KtTypeReference typeReference = this.$typeProjection.getTypeReference();
                if (token != null && typeReference != null) {
                    $receiver.append(" ");
                }
                DebugTextUtilKt.appendInn$default($receiver, typeReference, null, null, 6);
            }
            {
                this.$typeProjection = ktTypeProjection;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitModifierList(@NotNull KtModifierList list, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(list, "list");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(list){
            final /* synthetic */ KtModifierList $list;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                boolean first = true;
                KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
                for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
                    KtModifierKeywordToken modifierKeywordToken = ktModifierKeywordTokenArray[i];
                    if (!this.$list.hasModifier(modifierKeywordToken)) continue;
                    if (!first) {
                        $receiver.append(" ");
                    }
                    $receiver.append(modifierKeywordToken.getValue());
                    first = false;
                }
            }
            {
                this.$list = ktModifierList;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return expression.getReferencedName();
    }

    @Override
    @Nullable
    public String visitNullableType(@NotNull KtNullableType nullableType, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(nullableType, "nullableType");
        return this.renderChildren(nullableType, "", "", "?");
    }

    @Override
    @Nullable
    public String visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(initializer2, "initializer");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(initializer2);
        StringBuilder stringBuilder = new StringBuilder().append("initializer in ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append(object).toString();
    }

    @Override
    @Nullable
    public String visitClassBody(@NotNull KtClassBody classBody, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(classBody, "classBody");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(classBody);
        StringBuilder stringBuilder = new StringBuilder().append("class body for ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append(object).toString();
    }

    @Override
    @Nullable
    public String visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(accessor, "accessor");
        KtProperty containingProperty = KtStubbedPsiUtil.getContainingDeclaration(accessor, KtProperty.class);
        String what = accessor.isGetter() ? "getter" : "setter";
        return what + " for " + (containingProperty != null ? DebugTextUtilKt.getDebugText(containingProperty) : "...");
    }

    @Override
    @Nullable
    public String visitClass(@NotNull KtClass klass, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(klass){
            final /* synthetic */ KtClass $klass;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getModifierList(), null, " ", 2);
                $receiver.append("class ");
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getNameAsName(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getTypeParameterList(), null, null, 6);
                DebugTextUtilKt.access$appendInn($receiver, this.$klass.getPrimaryConstructorModifierList(), " ", " ");
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getPrimaryConstructorParameterList(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getDelegationSpecifierList(), " : ", null, 4);
            }
            {
                this.$klass = ktClass;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitNamedFunction(@NotNull KtNamedFunction function, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(function){
            final /* synthetic */ KtNamedFunction $function;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getModifierList(), null, " ", 2);
                $receiver.append("fun ");
                KtTypeParameterList typeParameterList = this.$function.getTypeParameterList();
                if (this.$function.hasTypeParameterListBeforeFunctionName()) {
                    DebugTextUtilKt.appendInn$default($receiver, typeParameterList, null, " ", 2);
                }
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getReceiverTypeReference(), null, ".", 2);
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getNameAsName(), null, null, 6);
                if (!this.$function.hasTypeParameterListBeforeFunctionName()) {
                    DebugTextUtilKt.appendInn$default($receiver, typeParameterList, null, null, 6);
                }
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getValueParameterList(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getTypeReference(), ": ", null, 4);
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getTypeConstraintList(), " ", null, 4);
            }
            {
                this.$function = ktNamedFunction;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(declaration){
            final /* synthetic */ KtObjectDeclaration $declaration;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$declaration.getModifierList(), null, " ", 2);
                $receiver.append("object ");
                DebugTextUtilKt.appendInn$default($receiver, this.$declaration.getNameAsName(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$declaration.getDelegationSpecifierList(), " : ", null, 4);
            }
            {
                this.$declaration = ktObjectDeclaration;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitParameter(@NotNull KtParameter parameter, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(parameter){
            final /* synthetic */ KtParameter $parameter;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if (this.$parameter.hasValOrVar()) {
                    if (this.$parameter.isMutable()) {
                        $receiver.append("var ");
                    } else {
                        $receiver.append("val ");
                    }
                }
                Name name = this.$parameter.getNameAsName();
                DebugTextUtilKt.appendInn$default($receiver, name, null, null, 6);
                KtTypeReference typeReference = this.$parameter.getTypeReference();
                if (typeReference != null && name != null) {
                    $receiver.append(": ");
                }
                DebugTextUtilKt.appendInn$default($receiver, typeReference, null, null, 6);
            }
            {
                this.$parameter = ktParameter;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitProperty(@NotNull KtProperty property, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(property){
            final /* synthetic */ KtProperty $property;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$property.getModifierList(), null, " ", 2);
                $receiver.append(this.$property.isVar() ? "var " : "val ");
                DebugTextUtilKt.appendInn$default($receiver, this.$property.getNameAsName(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$property.getTypeReference(), ": ", null, 4);
            }
            {
                this.$property = ktProperty;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeConstraint(@NotNull KtTypeConstraint constraint, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(constraint, "constraint");
        return this.buildText((Function1<? super StringBuilder, ? extends Unit>)new Function1<StringBuilder, Unit>(constraint){
            final /* synthetic */ KtTypeConstraint $constraint;

            public final void invoke(StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                DebugTextUtilKt.appendInn$default($receiver, this.$constraint.getSubjectTypeParameterName(), null, null, 6);
                DebugTextUtilKt.appendInn$default($receiver, this.$constraint.getBoundTypeReference(), " : ", null, 4);
            }
            {
                this.$constraint = ktTypeConstraint;
                super(1);
            }
        });
    }

    @Nullable
    public final String buildText(@NotNull Function1<? super StringBuilder, ? extends Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        StringBuilder sb = new StringBuilder();
        body.invoke(sb);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String renderChildren(@NotNull KtElementImplStub<?> element, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
        String childrenTexts;
        String string;
        Object object;
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(separator, "separator");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        Intrinsics.checkParameterIsNotNull(postfix, "postfix");
        Object t = element.getStub();
        if (t != null && (t = t.getChildrenStubs()) != null) {
            void destination;
            void $receiver;
            void $receiver2;
            void $receiver3;
            Iterable iterable = (Iterable)t;
            void var7_6 = $receiver3;
            Collection collection = new ArrayList();
            void var9_8 = $receiver2;
            Iterator iterator2 = $receiver.iterator();
            while (iterator2.hasNext()) {
                Boolean bl;
                StubElement it2;
                Object element2;
                Object element3 = element2 = iterator2.next();
                StubElement stubElement = it2 = (StubElement)element3;
                Object object2 = stubElement != null ? stubElement.getPsi() : null;
                if (!(object2 instanceof KtElement)) {
                    object2 = null;
                }
                KtElement ktElement = (KtElement)object2;
                if ((ktElement != null ? DebugTextUtilKt.getDebugText(ktElement) : null) != null) {
                    void $receiver4;
                    String string2;
                    string2 = string2;
                    void it3 = $receiver4;
                    bl = destination.add(it3);
                    continue;
                }
                bl = null;
            }
            object = (List)destination;
        } else {
            object = null;
        }
        if ((string = (childrenTexts = object)) == null || (string = CollectionsKt.joinToString$default((Iterable)((Object)string), (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix, 0, null, null, 56)) == null) {
            string = element.getText();
        }
        return string;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String renderChildren$default(DebugTextBuildingVisitor debugTextBuildingVisitor, KtElementImplStub ktElementImplStub, String string, String string2, String string3, int n) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        return debugTextBuildingVisitor.renderChildren(ktElementImplStub, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String render(@NotNull KtElementImplStub<?> element, KtElement ... relevantChildren) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(relevantChildren, "relevantChildren");
        if (element.getStub() == null) {
            return element.getText();
        }
        Iterable $receiver2 = ArraysKt.filterNotNull((Object[])relevantChildren);
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            KtElement ktElement = (KtElement)item;
            void var12_9 = destination;
            String string = DebugTextUtilKt.getDebugText((KtElement)it2);
            var12_9.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination), (CharSequence)"", (CharSequence)"", (CharSequence)"", 0, null, null, 56);
    }

    static {
        new DebugTextBuildingVisitor();
    }

    private DebugTextBuildingVisitor() {
        INSTANCE = this;
        INSTANCE$ = this;
        LOG = Logger.getInstance(this.getClass());
    }
}

