/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;
import org.jetbrains.idea.svn.commandLine.WinTerminalExecutor;

public class TerminalExecutor
extends CommandExecutor {
    private final List<InteractiveCommandListener> myInteractiveListeners;

    public TerminalExecutor(@NotNull @NonNls String exePath, @NotNull String locale, @NotNull Command command) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "<init>"));
        }
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "<init>"));
        }
        super(exePath, locale, command);
        this.myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "addInteractiveListener"));
        }
        this.myInteractiveListeners.add(listener);
    }

    @Override
    public Boolean wasError() {
        return Boolean.FALSE;
    }

    @Override
    protected void startHandlingStreams() {
        for (InteractiveCommandListener listener : this.myInteractiveListeners) {
            ((TerminalProcessHandler)this.myHandler).addInteractiveListener(listener);
        }
        super.startHandlingStreams();
    }

    @Override
    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        TerminalProcessHandler terminalProcessHandler = new TerminalProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString(), this.needsUtf8Output(), false);
        if (terminalProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createProcessHandler"));
        }
        return terminalProcessHandler;
    }

    @Override
    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        if (this instanceof WinTerminalExecutor) {
            ByteArrayOutputStream byteArrayOutputStream = super.getBinaryOutput();
            if (byteArrayOutputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "getBinaryOutput"));
            }
            return byteArrayOutputStream;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] outputBytes = CharsetToolkit.getUtf8Bytes((String)this.getOutput());
        result.write(outputBytes, 0, outputBytes.length);
        ByteArrayOutputStream byteArrayOutputStream = result;
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "getBinaryOutput"));
        }
        return byteArrayOutputStream;
    }

    @Override
    @NotNull
    protected GeneralCommandLine createCommandLine() {
        PtyCommandLine ptyCommandLine = new PtyCommandLine();
        if (ptyCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createCommandLine"));
        }
        return ptyCommandLine;
    }

    @Override
    @NotNull
    protected Process createProcess() throws ExecutionException {
        List<String> parameters = this.escapeArguments(this.buildParameters());
        Process process = this.createProcess(parameters);
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createProcess"));
        }
        return process;
    }

    @NotNull
    protected List<String> buildParameters() {
        List list = CommandLineUtil.toCommandLine((String)this.myCommandLine.getExePath(), (List)this.myCommandLine.getParametersList().getList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "buildParameters"));
        }
        return list;
    }

    @NotNull
    protected Process createProcess(@NotNull List<String> parameters) throws ExecutionException {
        Process process;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createProcess"));
        }
        try {
            process = ((PtyCommandLine)this.myCommandLine).startProcessWithPty(parameters, false);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createProcess"));
        }
        return process;
    }

    @Override
    public void logCommand() {
        super.logCommand();
        LOG.info("Terminal output " + ((TerminalProcessHandler)this.myHandler).getTerminalOutput());
    }

    @NotNull
    protected List<String> escapeArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "escapeArguments"));
        }
        List<String> list = arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "escapeArguments"));
        }
        return list;
    }
}

