/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.IndentStrategy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageIndentStrategy
extends LanguageExtension<IndentStrategy> {
    public static final String EP_NAME = "com.intellij.lang.indentStrategy";
    public static final LanguageIndentStrategy INSTANCE = new LanguageIndentStrategy();
    private static final DefaultIndentStrategy DEFAULT_INDENT_STRATEGY = new DefaultIndentStrategy();

    public LanguageIndentStrategy() {
        super(EP_NAME, DEFAULT_INDENT_STRATEGY);
    }

    @NotNull
    public static IndentStrategy getIndentStrategy(@Nullable PsiFile file) {
        Language language;
        IndentStrategy strategy;
        if (file != null && (strategy = (IndentStrategy)INSTANCE.forLanguage(language = file.getLanguage())) != null) {
            IndentStrategy indentStrategy = strategy;
            if (indentStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LanguageIndentStrategy", "getIndentStrategy"));
            }
            return indentStrategy;
        }
        DefaultIndentStrategy defaultIndentStrategy = DEFAULT_INDENT_STRATEGY;
        if (defaultIndentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LanguageIndentStrategy", "getIndentStrategy"));
        }
        return defaultIndentStrategy;
    }

    public static boolean isDefault(IndentStrategy indentStrategy) {
        return indentStrategy == DEFAULT_INDENT_STRATEGY;
    }

    private static class DefaultIndentStrategy
    implements IndentStrategy {
        private DefaultIndentStrategy() {
        }

        @Override
        public boolean canIndent(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/LanguageIndentStrategy$DefaultIndentStrategy", "canIndent"));
            }
            return true;
        }
    }
}

