/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UA)\u0004\u0003!\tQ\u0005\u0003\u0003\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004K)!\u0011\u0001c\u0002\u000e\u00051\u0005\u0001\u0004B\r\u0005\u0011\u0013i!\u0001$\u0001\u0019\u000b\u0015JA!\u0001E\u0006\u001b\ta\t\u0001G\u0003\u001a\u0007!\u0015Q\"\u0001\r\u0004K!!1\u0002\u0003\u0004\u000e\u0003a\u0011\u0011d\u0001E\u0003\u001b\u0005A2\u0001"}, strings={"Lorg/jetbrains/java/decompiler/ShowDecompiledClassAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOriginalFile", "Lcom/intellij/psi/PsiFile;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "update"}, moduleName="java-decompiler-plugin")
public final class ShowDecompiledClassAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiElement psiElement = this.getPsiElement(e);
        boolean visible = (psiElement != null ? psiElement.getContainingFile() : null) instanceof PsiClassOwner;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && this.getOriginalFile(this.getPsiElement(e)) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile vFile;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiFile file = this.getOriginalFile(this.getPsiElement(e));
        if (file != null && (vFile = file.getVirtualFile()) != null) {
            new OpenFileDescriptor(file.getProject(), vFile, -1).navigate(true);
        }
    }

    private final PsiElement getPsiElement(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        }
        Editor editor2 = editor;
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project2);
        return psiFile != null ? psiFile.findElementAt(editor2.getCaretModel().getOffset()) : null;
    }

    private final PsiFile getOriginalFile(PsiElement psiElement) {
        PsiClass psiClass;
        PsiClass psiClass2 = psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        PsiElement original = psiClass2 != null ? psiClass2.getOriginalElement() : null;
        return Intrinsics.areEqual((Object)original, (Object)psiClass) ^ true && original instanceof PsiCompiledElement ? ((PsiCompiledElement)original).getContainingFile() : (PsiFile)null;
    }

    public ShowDecompiledClassAction() {
        super(IdeaDecompilerBundle.message("action.show.decompiled.name", new Object[0]));
    }
}

