/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassDeserializer {
    private final Function1<? super ClassKey, ? extends ClassDescriptor> classes;
    private final DeserializationComponents components;

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        return this.classes.invoke(new ClassKey(classId, classDataWithSource));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassDataWithSource classDataWithSource, int n) {
        if ((n & 2) != 0) {
            classDataWithSource = null;
        }
        return classDeserializer.deserializeClass(classId, classDataWithSource);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor createClass(ClassKey key) {
        void sourceElement;
        void nameResolver;
        void classProto;
        DeserializationContext deserializationContext;
        void classData;
        ClassId classId = key.getClassId();
        ClassDescriptor classDescriptor = this.components.getFictitiousClassDescriptorFactory().createClass(classId);
        if (classDescriptor != null) {
            ClassDescriptor $receiver = classDescriptor;
            ClassDescriptor it = $receiver;
            return it;
        }
        ClassDataWithSource classDataWithSource = key.getClassDataWithSource();
        if (classDataWithSource == null) {
            classDataWithSource = this.components.getClassDataFinder().findClassData(classId);
        }
        if (classDataWithSource == null) {
            return null;
        }
        Object $i$a$1 = classDataWithSource;
        ClassData $receiver = ((ClassDataWithSource)$i$a$1).component1();
        SourceElement it = ((ClassDataWithSource)$i$a$1).component2();
        $i$a$1 = null;
        Object var6_8 = classData;
        $i$a$1 = var6_8.component1();
        ProtoBuf.Class $i$f$let = var6_8.component2();
        var6_8 = null;
        if (classId.isNestedClass()) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull(classId2, "classId.outerClassId");
            ClassDescriptor classDescriptor2 = ClassDeserializer.deserializeClass$default(this, classId2, null, 2);
            if (!(classDescriptor2 instanceof DeserializedClassDescriptor)) {
                classDescriptor2 = null;
            }
            DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)classDescriptor2;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            Name name = classId.getShortClassName();
            Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
            if (!outerClass.hasNestedClass$kotlin_core(name)) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            Unit unit;
            void $receiver22;
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
            List<PackageFragmentDescriptor> fragments2 = packageFragmentProvider.getPackageFragments(fqName2);
            Collection collection = fragments2;
            boolean $receiver22 = $receiver22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "There should be exactly one package: " + fragments2 + ", class id is " + classId;
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            PackageFragmentDescriptor fragment = CollectionsKt.single(fragments2);
            if (fragment instanceof DeserializedPackageFragment) {
                DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)fragment;
                Name name = classId.getShortClassName();
                Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
                if (!deserializedPackageFragment.hasTopLevelClass$kotlin_core(name)) {
                    return null;
                }
            }
            ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull(typeTable, "classProto.typeTable");
            deserializationContext = this.components.createContext(fragment, (NameResolver)nameResolver, new TypeTable(typeTable));
        }
        DeserializationContext outerContext = deserializationContext;
        return new DeserializedClassDescriptor(outerContext, (ProtoBuf.Class)classProto, (NameResolver)nameResolver, (SourceElement)sourceElement);
    }

    public ClassDeserializer(@NotNull DeserializationComponents components2) {
        Intrinsics.checkParameterIsNotNull(components2, "components");
        this.components = components2;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key) {
                Intrinsics.checkParameterIsNotNull(key, "key");
                return ClassDeserializer.access$createClass(this.this$0, key);
            }
            {
                this.this$0 = classDeserializer;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, @NotNull ClassKey key) {
        return $this.createClass(key);
    }

    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassDataWithSource classDataWithSource;

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual(this.classId, ((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassDataWithSource getClassDataWithSource() {
            return this.classDataWithSource;
        }

        public ClassKey(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
            Intrinsics.checkParameterIsNotNull(classId, "classId");
            this.classId = classId;
            this.classDataWithSource = classDataWithSource;
        }
    }
}

