/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.tools.idea.editors.gfxtrace.gapi.GapisProcess;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientRPC;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;

public class GapisConnection
implements Closeable {
    private final GapisProcess myParent;
    private final Socket myServerSocket;

    public GapisConnection(GapisProcess parent, Socket serverSocket) {
        this.myParent = parent;
        this.myServerSocket = serverSocket;
    }

    public boolean isConnected() {
        return this.myServerSocket != null && this.myServerSocket.isConnected();
    }

    public ServiceClient createServiceClient(ListeningExecutorService executor) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Not connected");
        }
        return new ServiceClientRPC(executor, this.myServerSocket.getInputStream(), this.myServerSocket.getOutputStream(), 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GapisConnection gapisConnection = this;
        synchronized (gapisConnection) {
            if (this.isConnected()) {
                try {
                    this.myServerSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.myParent.onClose(this);
            }
        }
    }
}

