/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkLoadedCallback;
import com.android.tools.idea.sdk.SdkLoggerIntegration;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.internal.updater.SdkUpdaterNoWindow;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmwOldApiDirectInstall
extends DynamicWizardStepWithDescription {
    private Logger LOG;
    private JBLabel myLabelSdkPath;
    private JTextArea mySdkManagerOutput;
    private JBLabel myLabelProgress1;
    private JProgressBar myProgressBar;
    private JBLabel myLabelProgress2;
    private JLabel myErrorLabel;
    private JPanel myContentPanel;
    private boolean myInstallFinished;
    private Boolean myBackgroundSuccess;

    public SmwOldApiDirectInstall(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall", "<init>"));
        }
        super(disposable);
        this.$$$setupUI$$$();
        this.LOG = Logger.getInstance(SmwOldApiDirectInstall.class);
        this.myBackgroundSuccess = null;
        this.setBodyComponent(this.myContentPanel);
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.mySdkManagerOutput.setText("");
        this.startSdkInstallUsingNonSwtOldApi();
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.listSize(WizardConstants.INSTALL_REQUESTS_KEY) > 0;
    }

    @Override
    public boolean validate() {
        return this.myInstallFinished;
    }

    @Override
    public boolean canGoPrevious() {
        return this.myInstallFinished;
    }

    private void startSdkInstallUsingNonSwtOldApi() {
        SdkState sdkState;
        final AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        SdkState sdkState2 = sdkState = sdkData == null ? null : SdkState.getInstance(sdkData);
        if (sdkState == null) {
            this.myErrorLabel.setText("Error: can't get SDK instance.");
            this.myErrorLabel.setForeground((Color)JBColor.RED);
            return;
        }
        File androidSdkPath = IdeSdks.getAndroidSdkPath();
        if (androidSdkPath != null && androidSdkPath.exists() && !androidSdkPath.canWrite()) {
            this.myErrorLabel.setText(String.format("SDK folder is read-only: '%1$s'", androidSdkPath.getPath()));
            this.myErrorLabel.setForeground((Color)JBColor.RED);
            return;
        }
        this.myLabelSdkPath.setText(sdkData.getLocation().getPath());
        final CustomLogger logger = new CustomLogger();
        SdkLoadedCallback onSdkAvailable = new SdkLoadedCallback(true){

            @Override
            public void doRun(@NotNull SdkPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$1", "doRun"));
                }
                ArrayList requestedPackages = Lists.newArrayList();
                List<IPkgDesc> requestedChanges = SmwOldApiDirectInstall.this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
                if (requestedChanges == null) {
                    SmwOldApiDirectInstall.this.myInstallFinished = true;
                    SmwOldApiDirectInstall.this.invokeUpdate(null);
                    return;
                }
                for (IPkgDesc object : requestedChanges) {
                    try {
                        IPkgDesc packageDesc = object;
                        if (packageDesc == null) continue;
                        requestedPackages.add(packageDesc.getInstallId());
                    }
                    catch (ClassCastException e) {
                        SmwOldApiDirectInstall.this.LOG.error((Throwable)e);
                    }
                }
                InstallTask task = new InstallTask(sdkData, requestedPackages, (ILogger)logger);
                BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator((Task.Backgroundable)task);
                logger.setIndicator(indicator);
                ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
            }
        };
        logger.info("Loading SDK information...\n", new Object[0]);
        sdkState.loadAsync(86400000L, false, null, onSdkAvailable, null, false);
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("InstallingSDKComponentsStep" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall", "getStepName"));
        }
        return "InstallingSDKComponentsStep";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("Installing Requested Components" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall", "getStepTitle"));
        }
        return "Installing Requested Components";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private void checkForUpgrades(@Nullable List completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (Object o : completedChanges) {
            AndroidVersion version;
            IPkgDesc pkgDesc;
            if (!(o instanceof IPkgDesc) || !(pkgDesc = (IPkgDesc)o).getType().equals((Object)PkgType.PKG_PLATFORM) || (version = pkgDesc.getAndroidVersion()) == null || version.getApiLevel() <= highestNewApiLevel) continue;
            highestNewApiLevel = version.getApiLevel();
        }
        if (highestNewApiLevel > 0) {
            this.myState.put(WizardConstants.NEWLY_INSTALLED_API_KEY, highestNewApiLevel);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JLabel jLabel;
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myLabelProgress1 = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myLabelProgress2 = jBLabel = new JBLabel();
        jBLabel.setVerticalAlignment(1);
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setText("");
        jBLabel.setBackground(new Color(-3355444));
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 0, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySdkManagerOutput = jTextArea = new JTextArea();
        jTextArea.setText("");
        jBScrollPane.setViewportView(jTextArea);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private final class CustomLogger
    extends SdkLoggerIntegration {
        private CustomLogger() {
        }

        @Override
        protected void setProgress(int progress) {
            SmwOldApiDirectInstall.this.myProgressBar.setValue(progress);
        }

        @Override
        protected void setDescription(String description) {
            SmwOldApiDirectInstall.this.myLabelProgress2.setText(description);
        }

        @Override
        protected void setTitle(String title) {
            SmwOldApiDirectInstall.this.myLabelProgress1.setText(title);
        }

        @Override
        protected void lineAdded(String string) {
            String current = SmwOldApiDirectInstall.this.mySdkManagerOutput.getText();
            if (current == null) {
                current = "";
            }
            SmwOldApiDirectInstall.this.mySdkManagerOutput.setText(current + string);
            if (string.contains("Nothing was installed") || string.contains("Failed") || string.contains("The package filter removed all packages")) {
                SmwOldApiDirectInstall.this.myBackgroundSuccess = false;
            } else if (string.contains("Done") && !string.contains("othing")) {
                SmwOldApiDirectInstall.this.myBackgroundSuccess = true;
            }
        }
    }

    private class InstallTask
    extends Task.Backgroundable {
        @NotNull
        private final AndroidSdkData mySdkData;
        @NotNull
        private final ArrayList<String> myRequestedPackages;
        @NotNull
        private final ILogger myLogger;

        private InstallTask(@NotNull AndroidSdkData sdkData, @NotNull ArrayList<String> requestedPackages, ILogger logger) {
            if (sdkData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            if (requestedPackages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "<init>"));
            }
            super(null, "Installing Android SDK", false, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.mySdkData = sdkData;
            this.myRequestedPackages = requestedPackages;
            this.myLogger = logger;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/wizard/SmwOldApiDirectInstall$InstallTask", "run"));
            }
            SdkManager sdkManager = SdkManager.createManager((LocalSdk)this.mySdkData.getLocalSdk());
            SdkUpdaterNoWindow upd = new SdkUpdaterNoWindow(this.mySdkData.getLocation().getPath(), sdkManager, this.myLogger, false, null, null);
            upd.updateAll(this.myRequestedPackages, true, false, null, true);
            while (SmwOldApiDirectInstall.this.myBackgroundSuccess == null) {
                TimeoutUtil.sleep((long)100L);
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    SmwOldApiDirectInstall.this.myProgressBar.setValue(100);
                    SmwOldApiDirectInstall.this.myLabelProgress1.setText("");
                    if (!SmwOldApiDirectInstall.this.myBackgroundSuccess.booleanValue()) {
                        SmwOldApiDirectInstall.this.myLabelProgress2.setText("<html>Install Failed. Please check your network connection and try again. You may continue with creating your project, but it will not compile correctly without the missing components.</html>");
                        SmwOldApiDirectInstall.this.myLabelProgress2.setForeground((Color)JBColor.RED);
                        SmwOldApiDirectInstall.this.myProgressBar.setEnabled(false);
                    } else {
                        SmwOldApiDirectInstall.this.myLabelProgress2.setText("Done");
                        List<IPkgDesc> requestedChanges = SmwOldApiDirectInstall.this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
                        SmwOldApiDirectInstall.this.checkForUpgrades(requestedChanges);
                        SmwOldApiDirectInstall.this.myState.remove(WizardConstants.INSTALL_REQUESTS_KEY);
                    }
                    SmwOldApiDirectInstall.this.myInstallFinished = true;
                    SmwOldApiDirectInstall.this.invokeUpdate(null);
                    VirtualFile sdkDir = LocalFileSystem.getInstance().findFileByIoFile(InstallTask.this.mySdkData.getLocation());
                    if (sdkDir != null) {
                        sdkDir.refresh(true, true);
                    }
                    InstallTask.this.mySdkData.getLocalSdk().clearLocalPkg(PkgType.PKG_ALL);
                }
            });
        }
    }
}

