/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.GradleFileMerger;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultRecipeExecutor
implements RecipeExecutor {
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private final FindReferencesRecipeExecutor myReferences;
    private final RenderingContext myContext;
    private final RecipeIO myIO;
    private final ReadonlyStatusHandler myReadonlyStatusHandler;
    private boolean myNeedsGradleSync;

    public DefaultRecipeExecutor(@NotNull RenderingContext context, boolean dryRun) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "<init>"));
        }
        this.myReferences = new FindReferencesRecipeExecutor(context);
        this.myContext = context;
        this.myIO = dryRun ? new DryRunRecipeIO() : new RecipeIO();
        this.myReadonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)context.getProject());
    }

    @Override
    public void addDependency(@NotNull String mavenUrl) {
        if (mavenUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenUrl", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addDependency"));
        }
        this.myReferences.addDependency(mavenUrl);
        List dependencyList = (List)this.getParamMap().get("dependencyList");
        dependencyList.add(mavenUrl);
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addFilesToOpen"));
        }
        this.myReferences.addFilesToOpen(file);
    }

    private void addWarning(@NotNull String warning) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addWarning"));
        }
        this.myContext.getWarnings().add(warning);
    }

    @NotNull
    private Map<String, Object> getParamMap() {
        Map<String, Object> map = this.myContext.getParamMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getParamMap"));
        }
        return map;
    }

    @NotNull
    Configuration getFreemarker() {
        Configuration configuration = this.myContext.getFreemarkerConfiguration();
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getFreemarker"));
        }
        return configuration;
    }

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copy"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copy"));
        }
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "instantiate"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "instantiate"));
        }
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                File sourceFile = this.myContext.getLoader().getSourceFile(from);
                File targetFile = this.getTargetFile(to);
                String content = FreemarkerUtils.processFreemarkerTemplate(this.myContext, sourceFile, null);
                if (targetFile.exists()) {
                    if (!this.compareTextFile(targetFile, content)) {
                        this.addFileAlreadyExistWarning(targetFile);
                    }
                } else {
                    this.myIO.writeFile(this, content, targetFile);
                    this.myReferences.addSourceFile(sourceFile);
                    this.myReferences.addTargetFile(targetFile);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "merge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "merge"));
        }
        try {
            String contents;
            String sourceText;
            String targetText = null;
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(targetFile, ".xml") && !TemplateUtils.hasExtension(targetFile, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + targetFile);
            }
            if (targetFile.exists()) {
                VirtualFile toFile;
                ReadonlyStatusHandler.OperationStatus status;
                if (this.myContext.getProject().isInitialized() && (status = this.myReadonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{toFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true)})).hasReadonlyFiles()) {
                    throw new FreemarkerUtils.TemplateUserVisibleException(String.format("Attempt to update file that is readonly: %1$s", targetFile.getAbsolutePath()));
                }
                targetText = this.readTextFile(targetFile);
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, targetFile);
                } else {
                    this.copyTemplateResource(from, targetFile);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myContext, from, null);
            } else {
                sourceText = TemplateUtils.readTextFromDisk(sourceFile);
                if (sourceText == null) {
                    return;
                }
            }
            if (targetFile.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsGradleSync = true;
            } else if (targetFile.getName().equals("build.gradle")) {
                String compileSdkVersion = (String)this.getParamMap().get("buildApiString");
                contents = GradleFileMerger.mergeGradleFiles(sourceText, targetText, this.myContext.getProject(), compileSdkVersion);
                this.myNeedsGradleSync = true;
            } else if (TemplateUtils.hasExtension(targetFile, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myContext, sourceText, targetText, targetFile);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + targetFile);
            }
            this.myIO.writeFile(this, contents, targetFile);
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mkDir(@NotNull File at) {
        if (at == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "mkDir"));
        }
        try {
            this.myIO.mkDir(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateAndSyncGradle() {
        if (!this.myContext.getDependencies().isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Project project = this.myContext.getProject();
        if (this.myNeedsGradleSync && this.myContext.performGradleSync() && !project.isDefault() && Projects.isBuildWithGradle(project)) {
            this.myIO.requestGradleSync(project);
        }
    }

    @Override
    public void pushFolder(@NotNull String folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "pushFolder"));
        }
        try {
            this.myContext.getLoader().pushTemplateFolder(folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void popFolder() {
        this.myContext.getLoader().popTemplateFolder();
    }

    @NotNull
    private File getTargetFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getTargetFile"));
        }
        if (file.isAbsolute()) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getTargetFile"));
            }
            return file2;
        }
        File file3 = new File(this.myContext.getOutputRoot(), file.getPath());
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "getTargetFile"));
        }
        return file3;
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        File gradleBuildFile = GradleUtil.getGradleBuildFilePath(this.myContext.getModuleRoot());
        String destinationContents = null;
        if (gradleBuildFile.exists()) {
            destinationContents = this.readTextFile(gradleBuildFile);
        }
        if (destinationContents == null) {
            destinationContents = "";
        }
        String compileSdkVersion = (String)this.getParamMap().get("buildApiString");
        String result = GradleFileMerger.mergeGradleFiles(this.formatDependencies(), destinationContents, this.myContext.getProject(), compileSdkVersion);
        this.myIO.writeFile(this, result, gradleBuildFile);
        this.myNeedsGradleSync = true;
    }

    private String formatDependencies() {
        StringBuilder dependencies = new StringBuilder();
        dependencies.append("dependencies {\n");
        for (String dependency : this.myContext.getDependencies()) {
            dependencies.append("  compile '").append(dependency).append("'\n");
        }
        dependencies.append("}\n");
        return dependencies.toString();
    }

    private void copyDirectory(final @NotNull VirtualFile src, final @NotNull File dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyDirectory"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyDirectory"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$1", "visitFile"));
                }
                try {
                    return DefaultRecipeExecutor.this.copyFile(file, src, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private void copyTemplateResource(@NotNull File from, @NotNull File to) throws IOException {
        File destPath;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyTemplateResource"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "copyTemplateResource"));
        }
        File source = this.myContext.getLoader().getSourceFile(from);
        File target = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)source, (boolean)true);
        assert (sourceFile != null) : source;
        sourceFile.refresh(false, false);
        File file = destPath = source.isDirectory() ? target : target.getParentFile();
        if (source.isDirectory()) {
            this.copyDirectory(sourceFile, destPath);
        } else if (target.exists()) {
            if (!this.compareFile(sourceFile, target)) {
                this.addFileAlreadyExistWarning(target);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                this.myIO.writeFile(this, document.getText(), target);
            } else {
                this.myIO.copyFile(this, sourceFile, destPath, target.getName());
            }
            this.myReferences.addSourceFile(source);
            this.myReferences.addTargetFile(target);
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            throw new RuntimeException(String.format("%1$s is not a child of %2$s", file.getPath(), src));
        }
        if (file.isDirectory()) {
            this.myIO.mkDir(new File(destinationFile, relativePath));
        } else {
            File target = new File(destinationFile, relativePath);
            if (target.exists()) {
                if (!this.compareFile(file, target)) {
                    this.addFileAlreadyExistWarning(target);
                }
            } else {
                this.myIO.copyFile(this, file, target);
                this.myReferences.addSourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                this.myReferences.addTargetFile(target);
            }
        }
        return true;
    }

    private String readTextFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "readTextFile"));
        }
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(file);
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    private String readTextFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "readTextFile"));
        }
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    public boolean compareFile(@NotNull VirtualFile sourceVFile, @NotNull File targetFile) throws IOException {
        if (sourceVFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceVFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareFile"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareFile"));
        }
        VirtualFile targetVFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true);
        if (targetVFile == null) {
            return false;
        }
        if (sourceVFile.getFileType().isBinary()) {
            byte[] source = sourceVFile.contentsToByteArray();
            byte[] target = targetVFile.contentsToByteArray();
            return Arrays.equals(source, target);
        }
        String source = this.readTextFile(sourceVFile);
        String target = this.readTextFile(targetVFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)source, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    public boolean compareTextFile(@NotNull File targetFile, @NotNull String content) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareTextFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "compareTextFile"));
        }
        String target = this.readTextFile(targetFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)content, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private void addFileAlreadyExistWarning(@NotNull File targetFile) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor", "addFileAlreadyExistWarning"));
        }
        this.addWarning(String.format("The following file could not be created since it already exists: %1$s", targetFile.getName()));
    }

    private static class DryRunRecipeIO
    extends RecipeIO {
        private DryRunRecipeIO() {
        }

        @Override
        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "writeFile"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "writeFile"));
            }
            TemplateUtils.checkDirectoryIsWriteable(to.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            if (toFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            TemplateUtils.checkDirectoryIsWriteable(toFile.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @Nullable String newName) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            if (toFileDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFileDir", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "copyFile"));
            }
            TemplateUtils.checkDirectoryIsWriteable(toFileDir);
        }

        @Override
        public void mkDir(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "mkDir"));
            }
            TemplateUtils.checkDirectoryIsWriteable(directory);
        }

        @Override
        public void requestGradleSync(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO", "requestGradleSync"));
            }
        }
    }

    private static class RecipeIO {
        private RecipeIO() {
        }

        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "writeFile"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "writeFile"));
            }
            TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            TemplateUtils.writeTextFile(this, contents, to);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            if (toFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFile", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFile.getParentFile());
            VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)toDir);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @NotNull String newName) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            if (toFileDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFileDir", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "copyFile"));
            }
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFileDir);
            VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file, (VirtualFile)toDir, (String)newName);
        }

        public void mkDir(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "mkDir"));
            }
            TemplateUtils.checkedCreateDirectoryIfMissing(directory);
        }

        public void requestGradleSync(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO", "requestGradleSync"));
            }
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

