/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Platform
extends InstallableComponent {
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    /*
     * WARNING - void declaration
     */
    public Platform(@NotNull ScopedStateStore store, @NotNull String name, long size, @NotNull String description, AndroidVersion version, boolean bl) {
        void isDefaultPlatform;
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Platform", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/install/Platform", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/welcome/install/Platform", "<init>"));
        }
        super(store, name, size, description);
        this.myVersion = version;
        this.myIsDefaultPlatform = isDefaultPlatform;
    }

    private static Platform getLatestPlatform(@NotNull ScopedStateStore store, Multimap<PkgType, RemotePkgInfo> remotePackages, boolean preview) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Platform", "getLatestPlatform"));
        }
        RemotePkgInfo latest = InstallComponentsPath.findLatestPlatform(remotePackages, preview);
        if (latest != null) {
            AndroidVersion version = latest.getPkgDesc().getAndroidVersion();
            String versionName = SdkVersionInfo.getAndroidName((int)version.getFeatureLevel());
            String description = "Android platform libraries for targeting " + versionName + " platform";
            return new Platform(store, versionName, latest.getDownloadSize(), description, version, !version.isPreview());
        }
        return null;
    }

    @NotNull
    private static LocalPkgInfo[] getPlatformPackages(@Nullable SdkManager manager) {
        if (manager != null) {
            LocalSdk localSdk = manager.getLocalSdk();
            LocalPkgInfo[] localPkgInfoArray = localSdk.getPkgsInfos(PkgType.PKG_PLATFORM);
            if (localPkgInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Platform", "getPlatformPackages"));
            }
            return localPkgInfoArray;
        }
        LocalPkgInfo[] localPkgInfoArray = new LocalPkgInfo[]{};
        if (localPkgInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Platform", "getPlatformPackages"));
        }
        return localPkgInfoArray;
    }

    public static ComponentTreeNode createSubtree(@NotNull ScopedStateStore store, Multimap<PkgType, RemotePkgInfo> remotePackages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Platform", "createSubtree"));
        }
        Platform latestPlatform = Platform.getLatestPlatform(store, remotePackages, false);
        Object previewPlatform = null;
        if (previewPlatform != null) {
            if (latestPlatform != null) {
                return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform, previewPlatform);
            }
            latestPlatform = previewPlatform;
        }
        if (latestPlatform != null) {
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<IPkgDesc> getRequiredSdkPackages(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        MajorRevision unspecifiedRevision = new MajorRevision(FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder platform = PkgDesc.Builder.newPlatform((AndroidVersion)this.myVersion, (MajorRevision)unspecifiedRevision, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder platformSources = PkgDesc.Builder.newSource((AndroidVersion)this.myVersion, (MajorRevision)unspecifiedRevision);
        PkgDesc.Builder buildTool = PkgDesc.Builder.newBuildTool((FullRevision)Platform.findLatestCompatibleBuildTool(remotePackages, this.myVersion));
        ImmutableList immutableList = ImmutableList.of((Object)platform.create(), (Object)platformSources.create(), (Object)buildTool.create());
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Platform", "getRequiredSdkPackages"));
        }
        return immutableList;
    }

    private static FullRevision findLatestCompatibleBuildTool(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages, AndroidVersion version) {
        FullRevision revision = null;
        if (remotePackages != null) {
            for (RemotePkgInfo remotePkgInfo : remotePackages.get((Object)PkgType.PKG_BUILD_TOOLS)) {
                FullRevision testRevision = remotePkgInfo.getPkgDesc().getFullRevision();
                if (testRevision == null || testRevision.getMajor() != version.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
                revision = testRevision;
            }
        }
        return revision;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/Platform", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/install/Platform", "configure"));
        }
    }

    @Override
    public boolean isOptionalForSdkLocation(@Nullable SdkManager manager) {
        LocalPkgInfo[] infos = Platform.getPlatformPackages(manager);
        if (infos.length == 0) {
            return !this.myIsDefaultPlatform;
        }
        for (LocalPkgInfo info : infos) {
            int apiLevel;
            IPkgDesc desc = info.getDesc();
            AndroidVersion androidVersion = desc.getAndroidVersion();
            int n = apiLevel = androidVersion == null ? 0 : androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault(@Nullable SdkManager sdkManager) {
        return false;
    }
}

