/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.config.JdkDetection;
import com.android.tools.idea.welcome.wizard.FirstRunWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class JdkLocationStep
extends FirstRunWizardStep {
    private final ScopedStateStore.Key<String> myPathKey;
    @NotNull
    private final FirstRunWizardMode myMode;
    private JPanel myContents;
    private TextFieldWithBrowseButton myJdkPath;
    private HyperlinkLabel myDownloadPageLink;
    private JLabel myError;
    private JButton myDetectButton;
    private boolean myUserInput;

    public JdkLocationStep(@NotNull ScopedStateStore.Key<String> pathKey, @NotNull FirstRunWizardMode mode) {
        if (pathKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathKey", "com/android/tools/idea/welcome/wizard/JdkLocationStep", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/wizard/JdkLocationStep", "<init>"));
        }
        super("Java Settings");
        this.myUserInput = false;
        this.myPathKey = pathKey;
        this.myMode = mode;
        this.$$$setupUI$$$();
        this.myDownloadPageLink.setHyperlinkText(JdkLocationStep.getLinkText());
        this.myDownloadPageLink.setHyperlinkTarget("http://www.oracle.com/technetwork/java/javase/downloads/jdk7-downloads-1880260.html");
        this.myDownloadPageLink.getParent().invalidate();
        this.setComponent(this.myContents);
        this.myError.setForeground((Color)JBColor.red);
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myJdkPath.addBrowseFolderListener("Select JDK Location", "Select compatible JDK location", null, folderDescriptor);
        this.myError.setText(null);
        this.myDetectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkLocationStep.this.myDetectButton.setEnabled(false);
                JdkDetection.startWithProgressIndicator(new JdkDetection.JdkDetectionResult(){

                    @Override
                    public void onSuccess(String newJdkPath) {
                        if (newJdkPath == null) {
                            String message = AndroidBundle.message("android.wizard.jdk.autodetect.result.not.found", new Object[0]);
                            ExternalSystemUiUtil.showBalloon((JComponent)JdkLocationStep.this.myJdkPath, (MessageType)MessageType.INFO, (String)message);
                        } else {
                            JdkLocationStep.this.myJdkPath.setText(newJdkPath);
                        }
                        JdkLocationStep.this.myDetectButton.setEnabled(true);
                    }

                    @Override
                    public void onCancel() {
                        JdkLocationStep.this.myDetectButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private static String getLinkText() {
        if (SystemInfo.isMac) {
            return "Mac OS X x64";
        }
        if (SystemInfo.isLinux) {
            return SystemInfo.is32Bit ? "Linux x86" : "Linux x64";
        }
        if (SystemInfo.isWindows) {
            return SystemInfo.is32Bit ? "Windows x86" : "Windows x64";
        }
        return SystemInfo.OS_NAME;
    }

    @Override
    public boolean validate() {
        String path = this.myState.get(this.myPathKey);
        if (!StringUtil.isEmpty((String)path)) {
            this.myUserInput = true;
        }
        File userInput = StringUtil.isEmptyOrSpaces((String)path) ? null : new File(path);
        String message = JdkDetection.validateJdkLocation(userInput);
        if (this.myUserInput) {
            this.setErrorHtml(message);
        }
        return StringUtil.isEmpty((String)message);
    }

    @Override
    public void init() {
        this.register(this.myPathKey, this.myJdkPath);
    }

    @Override
    public boolean isStepVisible() {
        return !this.myMode.hasValidJdkLocation();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkPath;
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/JdkLocationStep", "getMessageLabel"));
        }
        return jLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        HyperlinkLabel hyperlinkLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html>Android Studio requires Java Development Kit (JDK) 7.0 or newer.</html>");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 2, null, new Dimension(800, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Java Development Kit (JDK) version 7.0.");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("or download and install JDK for your operating system and architecture: ");
        Component component = jPanel2.add(jLabel4);
        this.myDownloadPageLink = hyperlinkLabel = new HyperlinkLabel();
        Component component2 = jPanel2.add((Component)hyperlinkLabel);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(" and press ");
        Component component3 = jPanel2.add(jLabel5);
        this.myDetectButton = jButton = new JButton();
        jButton.setText("Detect");
        Component component4 = jPanel2.add(jButton);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myError = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Up to date JDK was not detected. Please select JDK location:");
        jPanel.add((Component)jLabel6, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }
}

