/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.text.StringUtilRt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.intellij.plugins.xpathView.ui.Mode;
import org.jetbrains.annotations.NotNull;

public abstract class ModeSwitchableDialog
extends DialogWrapper {
    protected final DimensionService dimensionService = DimensionService.getInstance();
    private Mode myMode = Mode.values()[StringUtilRt.parseInt((String)PropertiesComponent.getInstance().getValue(this.getPrivateDimensionServiceKey() + ".MODE", "0"), (int)0)];

    public ModeSwitchableDialog(Project project, boolean canBeParent) {
        super(project, canBeParent);
    }

    protected void init() {
        Mode mode = this.myMode;
        this.myMode = null;
        this.setMode(mode);
        super.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new AbstractAction(this.myMode.other().getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.putValue("Name", ModeSwitchableDialog.this.myMode.getName());
                ModeSwitchableDialog.this.dimensionService.setSize(ModeSwitchableDialog.this.getPrivateDimensionKey(), ModeSwitchableDialog.this.getSize());
                ModeSwitchableDialog.this.setMode(ModeSwitchableDialog.this.myMode.other());
                Dimension size = ModeSwitchableDialog.this.dimensionService.getSize(ModeSwitchableDialog.this.getPrivateDimensionKey());
                if (size != null) {
                    ModeSwitchableDialog.this.setSize(size.width, size.height);
                    ModeSwitchableDialog.this.validate();
                } else {
                    ModeSwitchableDialog.this.pack();
                }
            }
        }};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/ModeSwitchableDialog", "createActions"));
        }
        return actionArray;
    }

    public final Mode getMode() {
        return this.myMode;
    }

    protected final void setMode(Mode mode) {
        this.setModeImpl(mode);
        this.myMode = mode;
    }

    public void show() {
        Window window = SwingUtilities.windowForComponent(this.getContentPane());
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                Dimension size = ModeSwitchableDialog.this.dimensionService.getSize(ModeSwitchableDialog.this.getPrivateDimensionKey());
                if (size != null) {
                    ModeSwitchableDialog.this.setSize(size.width, size.height);
                    ModeSwitchableDialog.this.validate();
                }
            }
        });
        super.show();
        this.dimensionService.setSize(this.getPrivateDimensionKey(), this.getSize());
        this.dimensionService.setLocation(this.getPrivateDimensionKey(), this.getLocation());
        PropertiesComponent.getInstance().setValue(this.getPrivateDimensionServiceKey() + ".MODE", this.myMode.ordinal(), 0);
    }

    protected abstract void setModeImpl(Mode var1);

    public Point getInitialLocation() {
        return this.dimensionService.getLocation(this.getPrivateDimensionKey());
    }

    @NotNull
    protected abstract String getPrivateDimensionServiceKey();

    protected final String getPrivateDimensionKey() {
        return this.getPrivateDimensionServiceKey() + "." + this.myMode.toString();
    }

    protected final String getDimensionServiceKey() {
        return null;
    }

    public boolean isOK() {
        return this.getExitCode() == 0;
    }
}

