/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.IntProgression;
import kotlin.ReplaceWith;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinMultifileClassPart(version={1, 0, 1}, abiVersion=32, data={"\u000f\u0004)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001E\u0010\u000b\u0001)\u0011\u0001#\u0005\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001\u0003\b\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0019)\u0011\u0001#\u0004\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\u0005)\u0011\u0001C\b\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\u0011R!\u0001C\u0003\u000b\u0005A\u0011#B\u0001\t'\u0015\t\u00012E\u0003\u0002\u0011O)\u0011\u0001#\n\u0006\u0003\u0011\tQ!\u0001E\u000f\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012E\u0003\u0002\t5)\u0011\u0001c\u0004\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!$\u000e\u0005\b!\u0001Q\"\u0001M\u0001#\t!\u0001\u0001C\u0001\u0016\u000b%\u0019A\u0001A\u0005\u0002I\u0005A\u001a!'\u0005\t\u00055)\u0011b\u0001C\u0001\u0013\u0005!\u0013\u0001'\u0002Q\u0007\u0003\t6!\u0001\u0005\u0004)\u000e\u001dQ2\u0007\u0005\u0001\u001b\u0005AB!\u0005\u0002\u0005\u0001!\tQ#B\u0005\u0004\t\u0001I\u0011\u0001J\u0001\u0019\u0004eE\u0001BA\u0007\u0006\u0013\r!\t!C\u0001%\u0003a\u0015\u0001k!\u0001R\u0007\u0005AI\u0001VB\u0004\u001b]!9\u0001\u0003\u0001\u000e\u0003a\u0005\u0011C\u0001\u0003\u0001\u0011\u0005)R!C\u0002\u0005\u0001%\tA%\u0001M\u00023\u001fA!!\u0004\u0003\n\u0005%\tA%\u0001\r\u0006!\u000e\u0005Aka\u0002\u000e-!\u0001Q\"\u0001\r\u0005#\t!\u0001\u0001C\u0001\u0016\u000b%\u0019A\u0001A\u0005\u0002I\u0005A\u001a!g\u0004\t\u00055!\u0011BA\u0005\u0002I\u0005AR\u0001UB\u0001)\u000e\u001dQb\u0006C\u0004\u0011\u0001i\u0011\u0001'\u0001\u0012\u0005\u0011\u0001\u0001\"A\u000b\u0006\u0013\r!\u0001!C\u0001%\u0003a\r\u0011t\u0002\u0005\u0003\u001b\u0011I!!C\u0001%\u0003a-\u0001k!\u0001U\u0007\u000fia\u0003\u0003\u0001\u000e\u0003a!\u0011C\u0001\u0003\u0001\u0011\u0005)R!C\u0002\u0005\u0001%\tA%\u0001M\u00023\u001fA!!\u0004\u0003\n\u0005%\tA%\u0001M\u0006!\u000e\u0005Aka\u0002\u000e\u001b\u0011\u001d\u0001BB\u0007\u00021\u001b)\u0012\u0001G\u0004\u001a\n!=Q\"\u0001\r\t!\u000e\u0005Aka\u0002\u000e4\u0011\u001d\u0001\u0012C\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0013U!\u0011BA\u0005\u0002I%A\u001a\"'\u0005\t\u00055)\u0011bA\u0005\u0003\u0019\u0003A\"\u0002g\u0005Q\u0007\u0003\t6!\u0001C\u000b)\u000e\u001dQr\u0006E\t\u001b\u0005AB!%\u0003\u0005\u0001!\t\u0011kA\u0001\u0005\u0017U!\u0011BA\u0005\u0002I\u0005A\u001a\"g\u0004\t\u00055!\u0011BA\u0005\u0002I\u0005A\u001a\u0002UB\u0001)\u000e\u001dQr\u0005CD!!]Q\"\u0001\r\u0005+\rI\u0011\u0001b\u0001\u0019\u0014eE\u0001BA\u0007\u0006\u0013\rI!\u0001$\u0001\u0019\u0015aM\u0001k!\u0001U\u0007\u000fiQ\u0004b\"\u0011\u00111i\u0011\u0001\u0007\u0003\u0012\u0005\u0011\u0001\u0001\u0012D\t\u0003\t\u0003AQ\"\u0006\u0005\n\u0007\u0011\u0005\u0011\"\u0001S\r\u0013\tI\u0011\u0001J\u0007\u0019\u001ce%\u0001BD\u0007\u0002I3\u00016\u0011A)\u0004\u0003!uAka\u0002\u000e9\u0011\u001d\u0005\u0003C\b\u000e\u0003a!\u0011C\u0001\u0003\u0001\u00113\t\"\u0001\"\u0001\t\u001bU9\u0011BA\u0005\u0002I3I!!C\u0001%\u001bam\u0011\u0014\u0002E\u0010\u001b\u0005!S\u0002UB\u0001#\u000e\t\u0001R\u0004+\u0004\b5iBq\u0011\t\t!5Q\u0011\u0002C\u0005\b\u0013\tI\u0011\u0001*\u0007\n\u0005%\tA%\u0004\r\u00121C\t\"\u0001\u0002\u0001\t\u001aE\u0011A\u0011\u0001\u0005\u000e+\u001dI!!C\u0001%\u001a%\u0011\u0011\"\u0001\u0013\u000e17!6qA\u0007 \t\u000fA\u0001#\u0004\u0006\n\u0011%9\u0011BA\u0005\u0002I3I!!C\u0001%\u001ba\u0011\u00024E\t\u0003\t\u0001AI\"\u0005\u0002\u0005\u0002!iQcB\u0005\u0003\u0013\u0005!K\"\u0003\u0002\n\u0003\u0011j\u0001TE)\u0004\u0003\u0011\u0019Bka\u0002\u000e>\u0011\t\u0001rE\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0003U!\u0011BA\u0005\u0002I\u0005AB#'\u0006\t*59\u0011BA\u0005\u0002I\u0005I!!C\u0001\u0019\ta)\u0002k!\u0001\u001a\n!-R\"\u0001\r\u0005!\u000e\tAka\u0002\u000e>\u0011\t\u0001rE\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0003U!\u0011BA\u0005\u0002I\u0005Ab#'\u0006\t*59\u0011BA\u0005\u0002I\u0005I!!C\u0001\u0019\ta)\u0002k!\u0001\u001a\n!-R\"\u0001\r\u0005!\u000e\tAka\u0002\u000e=\u0011\u001dE\u0003#\f\u000e\u00051\u0005A%D\t\u0003\t\u0001AI\"\u0005\u0002\u0005\u0002!iQ\u0003C\u0005\u0004\t\u0003I\u0011\u0001*\u0007\n\u0005%\tA%\u0004M\u000e3\u0013Aa\"D\u0001%\u001aA\u001b\t!U\u0002\u0002\u0011]!6qA\u0007\u0017\t\u000fAy#D\u0001%\u001aE\u0011A\u0001\u0001E\r#\t!\t\u0001C\u0007\u0016\u000f%\u0011\u0011\"\u0001S\r\u0013\tI\u0011\u0001J\u0007\u0019#E\u001b\u0011\u0001\u0003\rU\u0007\u000fia\u0003b\u0002\t25\tA%D\t\u0003\t\u0001AI\"\u0005\u0002\u0005\u0002!iQcB\u0005\u0003\u0013\u0005!K\"\u0003\u0002\n\u0003\u0011j\u0001$E)\u0004\u0003!ABka\u0002\u000e/\u0011\u001d\u0005\u0003C\r\u000e\t%\u0011\u0011\"\u0001S\r1C\t\"\u0001\u0002\u0001\t\u001aE\u0011A\u0011\u0001\u0005\u000e+\u001dI!!C\u0001%\u001a%\u0011\u0011\"\u0001\u0013\u000e17!6qA\u0007\u001a\t\u000fA\u0011$\u0004\u0003\n\u0005%\tA\u0015\u0004M\u0012#\t!\u0001\u0001#\u0007\u0012\u0005\u0011\u0005\u0001\"D\u000b\b\u0013\tI\u0011\u0001*\u0007\n\u0005%\tA%\u0004M\u0013#\u000e\tA1\u0007+\u0004\b5=Aq\u0001\u0005\u001b\u001b\u0005A\u0002\"F\u0001\u0019\u000fQ\u001b9!D\f\u0005\u0007\u0012A)$D\u0001\u0019\u0002E\u0011A\u0001\u0001\u0005\u0002+\u0015I1\u0001\u0002\u0001\n\u0003\u0011\n\u00014AM\u0005\u0011mi\u0011\u0001J\u0001Q\u0007\u0003\t6!\u0001E\u001c)\u000e\u001dQB\u0007\u0003D\t!UR\"\u0001M\u0001#\t!\u0001\u0001C\u0001\u0016\u000b%\u0019A\u0001A\u0005\u0002I\u0005A\u001a!g\u0004\t\u00055!\u0011BA\u0005\u0002I\u0005A*\u0001UB\u0001#\u000e\t\u0001b\u0001+\u0004\b5=Ba\u0011\u0003\t65\t\u0001\u0014A\t\u0003\t\u0001A\u0011!F\u0003\n\u0007\u0011\u0001\u0011\"\u0001\u0013\u00021\u0007Iz\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\u0013\u00021\u0015\u00016\u0011\u0001+\u0004\b5=Ba\u0011\u0003\t65\t\u0001\u0014A\t\u0003\t\u0001A\u0011!F\u0003\n\u0007\u0011\u0001\u0011\"\u0001\u0013\u00021\u0007Iz\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\u0013\u00021\u0017\u00016\u0011\u0001+\u0004\b59Ba\u0011\u0003\t95\t\u0001\u0014A\t\u0003\t\u0001A\u0011!F\u0003\n\u0007\u0011\u0001\u0011\"\u0001\u0013\u00021\u0007IJ\u0001C\u000e\u000e\u0003\u0011\n\u0001k!\u0001R\u0007\u0005A9\u0004VB\u0004\u001bi!1\t\u0002\u0005\u001d\u001b\u0005A\n!\u0005\u0002\u0005\u0001!\tQ#B\u0005\u0004\t\u0001I\u0011\u0001J\u0001\u0019\u0004e=\u0001BA\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0006A\u001b\t!U\u0002\u0002\u0011\r!6qAG\u0018\t\r#\u0001\u0002H\u0007\u00021\u0003\t\"\u0001\u0002\u0001\t\u0003U)\u0011b\u0001\u0003\u0001\u0013\u0005!\u0013\u0001g\u0001\u001a\u0010!\u0011Q\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001G\u0003Q\u0007\u0003!6qAG\u0018\t\r#\u0001\u0002H\u0007\u00021\u0003\t\"\u0001\u0002\u0001\t\u0003U)\u0011b\u0001\u0003\u0001\u0013\u0005!\u0013\u0001g\u0001\u001a\u0010!\u0011Q\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001g\u0003Q\u0007\u0003!6qAG\u0018\t\u000fAI$D\u0001\u0019\tE\u0011A\u0001\u0001\u0005\u0002+\u0015I1\u0001\"\u0001\n\u0003\u0011\n\u00014AM\u0005\u0011mi\u0011\u0001J\u0001Q\u0007\u0003\t6A\u0001\u0003\u001e\u0011w!6qA\u0007\u0019\u0011si\u0011\u0001\u0007\u0003\u0012\n\u0011\u0001\u0001\"A)\u0004\u0003\u0011YQ#B\u0005\u0004\t\u0003I\u0011\u0001J\u0001\u0019\u0004e%\u0001bG\u0007\u0002I\u0005\u00016\u0011A)\u0004\u0003!mBka\u0002\u000e,\u0011\u001d\u0001\u0012H\u0007\u0002I%\t\"\u0001\u0002\u0001\t\u0013U!\u0011BA\u0005\u0002I%Ab#'\u0003\t\u00105\t\u0001\u0004\u0003)\u0004\u0002E\u001b\u0011\u0001\u0003\u0010U\u0007\u000fi\u0019\u0004b\u0002\t>5\t\u0001\u0004B\t\u0003\t\u0001A\u0011\"\u0006\u0003\n\u0005%\tA%\u0003M\u00023#A!!D\u0003\n\u0007%\u0011A\u0012\u0001\r\u000b1'\u00016\u0011A)\u0004\u0003\u0011yBka\u0002\u000e6\u0011\u001d\u0001RH\u0007\u00021\u0003\t\"\u0001\u0002\u0001\t\u0003U)\u0011b\u0001\u0003\u0001\u0013\u0005!\u0013\u0001g\u0001\u001a\u0012!\u0011Q\"B\u0005\u0004\t\u0003I\u0011\u0001J\u0001\u0019\u0006A\u001b\t!U\u0002\u0002\u0011\r!6qAG\u001a\u0011{i\u0011\u0001\u0007\u0003\u0012\u0005\u0011\u0001\u0001\"A\u000b\u0006\u0013\r!\u0001!C\u0001%\u0003a\r\u0011\u0014\u0003\u0005\u0003\u001b\u0015I1\u0001\"\u0001\n\u0003\u0011\n\u0001T\u0001)\u0004\u0002E\u001b\u0011\u0001#\u0003U\u0007\u000fiq\u0003b\u0002\t>5\t\u0001\u0014A\t\u0003\t\u0001A\u0011!F\u0003\n\u0007\u0011\u0001\u0011\"\u0001\u0013\u00021\u0007Iz\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\u0013\u00021\u0015\u00016\u0011\u0001+\u0004\b51\u0002RH\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0003U)\u0011b\u0001\u0003\u0001\u0013\u0005!\u0013\u0001g\u0001\u001a\u0010!\u0011Q\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001G\u0003Q\u0007\u0003!6qA\u0007\u0018\t\u000fAi$D\u0001\u0019\u0002E\u0011A\u0001\u0001\u0005\u0002+\u0015I1\u0001\u0002\u0001\n\u0003\u0011\n\u00014AM\b\u0011\tiA!\u0003\u0002\n\u0003\u0011\n\u00014\u0002)\u0004\u0002Q\u001b9!\u0004\f\t>5\t\u0001\u0004B\t\u0003\t\u0001A\u0011!F\u0003\n\u0007\u0011\u0001\u0011\"\u0001\u0013\u00021\u0007Iz\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\u0013\u00021\u0017\u00016\u0011\u0001+\u0004\b5E\u0002RH\u0007\u00021\u0011\tJ\u0001\u0002\u0001\t\u0003E\u001b\u0011\u0001B\u0006\u0016\u000b%\u0019A\u0011A\u0005\u0002I\u0005A\u001a!g\u0004\t\u00055!\u0011BA\u0005\u0002I\u0005A\u001a\u0002UB\u0001)\u000e\u001dQ\u0002\u0007E\u001f\u001b\u0005AB!\u0005\u0002\u0005\u0001!\tQ\u0003B\u0005\u0003\u0013\u0005!\u0013\u0001\u0007\u000b\u001a\u0016!%RbB\u0005\u0003\u0013\u0005!\u0013!\u0003\u0002\n\u0003a!\u0001$\u0006)\u0004\u0002Q\u001b9!\u0004\r\t>5\t\u0001\u0004B\t\u0003\t\u0001A\u0011!\u0006\u0003\n\u0005%\tA%\u0001\r\u00173+AI#D\u0004\n\u0005%\tA%A\u0005\u0003\u0013\u0005AB\u0001G\u000bQ\u0007\u0003!6qAG\u0018\t\u000f\u0003\u0002rH\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0013U!\u0011BA\u0005\u0002I%A\u001a!'\u0005\t\u00055)\u0011bA\u0005\u0003\u0019\u0003A\"\u0002g\u0005Q\u0007\u0003!6qAG\u0015\t\u000f\u0003\u0002\u0002I\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0013U!\u0011BA\u0005\u0002I%A\u001a!g\u0003\t75\u0011A\u0012\u0001\r\u000b!\u000e\u0005Aka\u0002\u000e4\u0011\u001d\u0001\u0012I\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0013U!\u0011BA\u0005\u0002I%A\u001a!'\u0005\t\u00055)\u0011bA\u0005\u0003\u0019\u0003A\"\u0002g\u0005Q\u0007\u0003\t6!\u0001\u0003\")\u000e\u001dQR\u0007C\u0004\u0011\u0003j\u0011\u0001'\u0001\u0012\u0005\u0011\u0001\u0001\"A\u000b\u0006\u0013\r!\u0001!C\u0001%\u0003a\r\u0011\u0014\u0003\u0005\u0003\u001b\u0015I1\u0001\"\u0001\n\u0003\u0011\n\u0001T\u0001)\u0004\u0002E\u001b\u0011\u0001C\u0002U\u0007\u000fi\u0019\u0004#\u0011\u000e\u0003a!\u0011C\u0001\u0003\u0001\u0011\u0005)R!C\u0002\u0005\u0001%\tA%\u0001M\u00023#A!!D\u0003\n\u0007\u0011\u0005\u0011\"\u0001\u0013\u00021\u000b\u00016\u0011A)\u0004\u0003!%Aka\u0002\u000e/\u0011\u001d\u0001\u0012I\u0007\u00021\u0003\t\"\u0001\u0002\u0001\t\u0003U)\u0011b\u0001\u0003\u0001\u0013\u0005!\u0013\u0001g\u0001\u001a\u0010!\u0011Q\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001G\u0003Q\u0007\u0003!6qA\u0007\u0017\u0011\u0003j\u0011\u0001\u0007\u0003\u0012\u0005\u0011\u0001\u0001\"A\u000b\u0006\u0013\r!\u0001!C\u0001%\u0003a\r\u0011t\u0002\u0005\u0003\u001b\u0011I!!C\u0001%\u0003a)\u0001k!\u0001U\u0007\u000fiq\u0003b\u0002\tB5\t\u0001\u0014A\t\u0003\t\u0001A\u0011!F\u0003\n\u0007\u0011\u0001\u0011\"\u0001\u0013\u00021\u0007Iz\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\u0013\u00021\u0017\u00016\u0011\u0001+\u0004\b51\u0002\u0012I\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0003U)\u0011b\u0001\u0003\u0001\u0013\u0005!\u0013\u0001g\u0001\u001a\u0010!\u0011Q\u0002B\u0005\u0003\u0013\u0005!\u0013\u0001g\u0003Q\u0007\u0003!6qAG\u0019\u0011\u0003j\u0011\u0001\u0007\u0003\u0012\n\u0011\u0001\u0001\"A)\u0004\u0003\u0011YQ#B\u0005\u0004\t\u0003I\u0011\u0001J\u0001\u0019\u0004e=\u0001BA\u0007\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0014A\u001b\t\u0001VB\u0004\u001baA\t%D\u0001\u0019\tE\u0011A\u0001\u0001\u0005\u0002+\u0011I!!C\u0001%\u0003a!\u0012T\u0003E\u0015\u001b\u001dI!!C\u0001%\u0003%\u0011\u0011\"\u0001\r\u00051U\u00016\u0011\u0001+\u0004\b5A\u0002\u0012I\u0007\u00021\u0011\t\"\u0001\u0002\u0001\t\u0003U!\u0011BA\u0005\u0002I\u0005Ab#'\u0006\t*59\u0011BA\u0005\u0002I\u0005I!!C\u0001\u0019\ta)\u0002k!\u0001U\u0007\u000fiy\u0003b\"\u0011\u0011\u0007j\u0011\u0001\u0007\u0003\u0012\u0005\u0011\u0001\u0001\"C\u000b\u0005\u0013\tI\u0011\u0001J\u0005\u0019\u0004eE\u0001BA\u0007\u0006\u0013\rI!\u0001$\u0001\u0019\u0015aM\u0001k!\u0001U\u0007\u000fi\u0019\u0002B\u0001\tE5\t\u0001\u0004B\u000b\u0004\u0013\u0005!\u0019\u0001g\u0001U\u0007\u000fi!\u0002b\"\u0011\u0011\u000bj\u0011\u0001\u0007\u0005\u0016\u0007%\tA1\u0001M\n)\u000e\u001dQ\u0002\u0004CD!!\u0015S\"\u0001\r\t+\u0015I\u0011\u0001b\u0001\n\u0003\u0011\r\u00014\u0004+\u0004\b5\r\u0002bI\u0007\u00021\u0003\tr\u0001\u0002\u0001\t\u0003U!\u0011BA\u0005\u0002I\u0005A:%\u0006\u0003\n\u0005%\tA%\u0001\r\u0017)\u000e\u001dQB\u0006\u0005%\u001b\u0005A\n!\u0005\u0002\u0005\u0001!\tQ\u0003B\u0005\u0003\u0013\u0005!\u0013\u0001\u0007\f\u001a\u0012!%S\"B\u0005\u0004\t\u0001I\u0011\u0001J\u0001\u0019KA\u001b\t\u0001VB\u0004\u001b]!9\t\u0005E&\u001b\u0011I!!C\u0001%\u001baM\u0011C\u0001\u0003\u0001\u00113\t\"\u0001\"\u0001\t\u001bU9\u0011BA\u0005\u0002I3I!!C\u0001%\u001bamAka\u0002\u000e3\u0011\u001d\u00012J\u0007\u0005\u0013\tI\u0011\u0001J\u0007\u0019\u0004E\u0011A\u0001\u0001E\r#\t!\t\u0001C\u0007\u0016\u000f%\u0011\u0011\"\u0001S\r\u0013\tI\u0011\u0001J\u0007\u0019&E\u001b\u0011\u0001\u0002\u0014U\u0007\u000f\u0001"}, strings={"addAll", "", "T", "", "elements", "", "(Ljava/util/Collection;[Ljava/lang/Object;)V", "CollectionsKt__MutableCollectionsKt", "", "(Ljava/util/Collection;[Ljava/lang/Object;)Z", "", "Lkotlin/Sequence;", "charAt", "", "", "index", "", "containsAll", "E", "", "", "containsAllOfAny", "Lkotlin/internal/OnlyInputTypes;", "containsAllRaw", "containsKey", "K", "V", "", "key", "(Ljava/util/Map;Ljava/lang/Object;)Z", "containsValue", "value", "entrySet", "", "", "", "", "", "mutableEntrySet", "filterInPlace", "", "predicate", "Lkotlin/Function1;", "predicateResultToRemove", "", "get", "(Ljava/util/Map;Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "(Ljava/util/Map$Entry;)Ljava/lang/Object;", "getValue", "keySet", "mutableKeys", "length", "minusAssign", "element", "(Ljava/util/Collection;Ljava/lang/Object;)V", "plusAssign", "remove", "removeAny", "(Ljava/util/Collection;Ljava/lang/Object;)Z", "(Ljava/util/List;I)Ljava/lang/Object;", "removeAll", "removeAllOfAny", "removeAllRaw", "removeRaw", "retainAll", "retainAllOfAny", "retainAllRaw", "retainNothing", "size", "sort", "", "sortWith", "comparator", "Ljava/util/Comparator;", "values", "mutableValues"}, multifileClassName="kotlin/collections/CollectionsKt")
final class CollectionsKt__MutableCollectionsKt {
    public static final <T> boolean containsAll(Collection<? extends T> $receiver, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return $receiver.containsAll(elements);
    }

    @Deprecated(message="Collections have incompatible types. Upcast either to Collection<Any?> if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="containsAll<Any?>(elements)"))
    public static final boolean containsAllRaw(Collection<?> $receiver, @NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return $receiver.containsAll(elements);
    }

    @Deprecated(message="Collections have incompatible types. Upcast either to Collection<Any?> if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="containsAll<Any?>(elements)"))
    @JvmName(name="containsAllOfAny")
    @LowPriorityInOverloadResolution
    public static final <E> boolean containsAllOfAny(Collection<? extends E> $receiver, @NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return CollectionsKt.containsAll($receiver, elements);
    }

    public static final <T> boolean remove(Collection<? extends T> $receiver, T element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection<? extends T> collection = $receiver;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableCollection<T>");
        }
        return TypeIntrinsics.asMutableCollection(collection).remove(element);
    }

    @Deprecated(message="Collection and element have incompatible types. Upcast element to Any? if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="remove(element as Any?)"))
    public static final <E> boolean removeRaw(Collection<E> $receiver, @Nullable Object element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return CollectionsKt.remove($receiver, element);
    }

    @Deprecated(message="Collection and element have incompatible types. Upcast element to Any? if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="remove(element as T)"))
    @JvmName(name="removeAny")
    @LowPriorityInOverloadResolution
    public static final <T> boolean removeAny(Collection<? extends T> $receiver, T element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return CollectionsKt.remove($receiver, element);
    }

    public static final <T> boolean removeAll(Collection<? extends T> $receiver, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Collection<? extends T> collection = $receiver;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableCollection<T>");
        }
        return TypeIntrinsics.asMutableCollection(collection).removeAll(elements);
    }

    @Deprecated(message="Collections have incompatible types. Upcast elements to Collection<Any?> if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="removeAll<Any?>(elements)"))
    public static final <E> boolean removeAllRaw(Collection<E> $receiver, @NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return CollectionsKt.removeAll($receiver, elements);
    }

    @Deprecated(message="Collections have incompatible types. Upcast elements to Collection<Any?> if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="removeAll<Any?>(elements)"))
    @JvmName(name="removeAllOfAny")
    @LowPriorityInOverloadResolution
    public static final <E> boolean removeAllOfAny(Collection<E> $receiver, @NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return CollectionsKt.removeAll($receiver, elements);
    }

    public static final <T> boolean retainAll(Collection<? extends T> $receiver, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Collection<? extends T> collection = $receiver;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableCollection<T>");
        }
        return TypeIntrinsics.asMutableCollection(collection).retainAll(elements);
    }

    @Deprecated(message="Collections have incompatible types. Upcast elements to Collection<Any?> if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="retainAll<Any?>(elements)"))
    public static final <E> boolean retainAllRaw(Collection<E> $receiver, @NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return CollectionsKt.retainAll($receiver, elements);
    }

    @Deprecated(message="Collections have incompatible types. Upcast elements to Collection<Any?> if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="retainAll<Any?>(elements)"))
    @JvmName(name="retainAllOfAny")
    @LowPriorityInOverloadResolution
    public static final <E> boolean retainAllOfAny(Collection<E> $receiver, @NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Collection<? extends Object> collection = elements;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Collection<kotlin.Any?>");
        }
        return CollectionsKt.retainAll($receiver, collection);
    }

    @Deprecated(message="Use operator 'get' instead", replaceWith=@ReplaceWith(imports={}, expression="this[index]"))
    public static final char charAt(CharSequence $receiver, int index) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.charAt(index);
    }

    @Deprecated(message="Use property 'size' instead", replaceWith=@ReplaceWith(imports={}, expression="size"))
    public static final int size(Collection<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.size();
    }

    @Deprecated(message="Use property 'size' instead", replaceWith=@ReplaceWith(imports={}, expression="size"))
    public static final int size(Map<?, ?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.size();
    }

    @Deprecated(message="Use property 'key' instead", replaceWith=@ReplaceWith(imports={}, expression="key"))
    public static final <K, V> K getKey(Map.Entry<? extends K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getKey();
    }

    @Deprecated(message="Use property 'value' instead.", replaceWith=@ReplaceWith(imports={}, expression="value"))
    public static final <K, V> V getValue(Map.Entry<? extends K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getValue();
    }

    @Deprecated(message="Use 'removeAt' instead.", replaceWith=@ReplaceWith(imports={}, expression="removeAt(index)"))
    public static final <E> E remove(List<E> $receiver, int index) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.remove(index);
    }

    @Deprecated(message="Use property 'length' instead.", replaceWith=@ReplaceWith(imports={}, expression="length"))
    public static final int length(CharSequence $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.length();
    }

    @Deprecated(message="Map and key have incompatible types. Upcast key to Any? if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="get(key as K)"))
    @LowPriorityInOverloadResolution
    @Nullable
    public static final <K, V> V get(Map<? extends K, ? extends V> $receiver, K key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return MapsKt.get($receiver, key);
    }

    @Deprecated(message="Map and key have incompatible types. Upcast key to Any? if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="containsKey(key as K)"))
    @LowPriorityInOverloadResolution
    public static final <K, V> boolean containsKey(Map<? extends K, ? extends V> $receiver, K key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return MapsKt.containsKey($receiver, key);
    }

    @Deprecated(message="Map and value have incompatible types. Upcast value to Any? if you're sure.", replaceWith=@ReplaceWith(imports={}, expression="containsValue(value as V)"))
    @LowPriorityInOverloadResolution
    public static final <K, V> boolean containsValue(Map<K, ? extends V> $receiver, V value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return MapsKt.containsValue($receiver, value);
    }

    @Deprecated(message="Use property 'keys' instead.", replaceWith=@ReplaceWith(imports={}, expression="keys"))
    @NotNull
    public static final <K, V> Set<K> keySet(Map<K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.keySet();
    }

    @Deprecated(message="Use property 'keys' instead.", replaceWith=@ReplaceWith(imports={}, expression="keys"))
    @JvmName(name="mutableKeys")
    @NotNull
    public static final <K, V> Set<K> mutableKeys(Map<K, V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.keySet();
    }

    @Deprecated(message="Use property 'entries' instead.", replaceWith=@ReplaceWith(imports={}, expression="entries"))
    @NotNull
    public static final <K, V> Set<Map.Entry<K, V>> entrySet(Map<K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.entrySet();
    }

    @Deprecated(message="Use property 'entries' instead.", replaceWith=@ReplaceWith(imports={}, expression="entries"))
    @JvmName(name="mutableEntrySet")
    @NotNull
    public static final <K, V> Set<Map.Entry<K, V>> mutableEntrySet(Map<K, V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.entrySet();
    }

    @Deprecated(message="Use property 'values' instead.", replaceWith=@ReplaceWith(imports={}, expression="values"))
    @NotNull
    public static final <K, V> Collection<V> values(Map<K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.values();
    }

    @Deprecated(message="Use property 'values' instead.", replaceWith=@ReplaceWith(imports={}, expression="values"))
    @JvmName(name="mutableValues")
    @NotNull
    public static final <K, V> Collection<V> mutableValues(Map<K, V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.values();
    }

    public static final <T> void plusAssign(Collection<? super T> $receiver, T element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.add(element);
    }

    public static final <T> void plusAssign(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        CollectionsKt.addAll($receiver, elements);
    }

    public static final <T> void plusAssign(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        CollectionsKt.addAll($receiver, elements);
    }

    public static final <T> void plusAssign(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        CollectionsKt.addAll($receiver, elements);
    }

    public static final <T> void minusAssign(Collection<? super T> $receiver, T element) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.remove(element);
    }

    public static final <T> void minusAssign(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        CollectionsKt.removeAll($receiver, elements);
    }

    public static final <T> void minusAssign(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        CollectionsKt.removeAll($receiver, elements);
    }

    public static final <T> void minusAssign(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        CollectionsKt.removeAll($receiver, elements);
    }

    public static final <T> boolean addAll(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Iterable<T> iterable = elements;
        if (iterable instanceof Collection) {
            return $receiver.addAll((Collection)elements);
        }
        boolean result = false;
        for (T item : elements) {
            if (!$receiver.add(item)) continue;
            result = true;
        }
        return result;
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void addAll(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Iterable<T> iterable = elements;
        if (iterable instanceof Collection) {
            $receiver.addAll((Collection)elements);
        } else {
            for (T item : elements) {
                $receiver.add(item);
            }
        }
    }

    public static final <T> boolean addAll(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        boolean result = false;
        Iterator<T> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!$receiver.add(item)) continue;
            result = true;
        }
        return result;
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void addAll(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        Iterator<T> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            $receiver.add(item);
        }
    }

    public static final <T> boolean addAll(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return $receiver.addAll((Collection)ArraysKt.asList(elements));
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void addAll(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        $receiver.addAll((Collection)ArraysKt.asList(elements));
    }

    public static final <T> boolean removeAll(Iterable<? extends T> $receiver, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return CollectionsKt__MutableCollectionsKt.filterInPlace($receiver, predicate, true);
    }

    public static final <T> boolean retainAll(Iterable<? extends T> $receiver, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return CollectionsKt__MutableCollectionsKt.filterInPlace($receiver, predicate, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> boolean filterInPlace(Iterable<? extends T> $receiver, Function1<? super T, Boolean> predicate, boolean predicateResultToRemove) {
        void result;
        void receiver$iv;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Iterator<? extends T> iterator2 = $receiver.iterator();
        Iterator $receiver2 = (Iterator)receiver$iv;
        while ($receiver2.hasNext()) {
            if (predicate.invoke($receiver2.next()) != predicateResultToRemove) continue;
            $receiver2.remove();
            result.element = true;
        }
        return result.element;
    }

    public static final <T> boolean removeAll(List<T> $receiver, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return CollectionsKt__MutableCollectionsKt.filterInPlace($receiver, predicate, true);
    }

    public static final <T> boolean retainAll(List<T> $receiver, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return CollectionsKt__MutableCollectionsKt.filterInPlace($receiver, predicate, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> boolean filterInPlace(List<T> $receiver, Function1<? super T, Boolean> predicate, boolean predicateResultToRemove) {
        int readIndex;
        int writeIndex = 0;
        int n = 0;
        int n2 = CollectionsKt.getLastIndex($receiver);
        if (n <= n2) {
            while (true) {
                T element;
                if (predicate.invoke(element = $receiver.get(readIndex)) != predicateResultToRemove) {
                    if (writeIndex != readIndex) {
                        $receiver.set(writeIndex, element);
                    }
                    ++writeIndex;
                }
                if (readIndex == n2) break;
                ++readIndex;
            }
        }
        if (writeIndex < $receiver.size()) {
            IntProgression intProgression = RangesKt.downTo(CollectionsKt.getLastIndex($receiver), writeIndex);
            readIndex = intProgression.getFirst();
            n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = readIndex;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void removeIndex;
                    $receiver.remove((int)removeIndex);
                    if (removeIndex == n2) break;
                    removeIndex += n3;
                }
            }
            return true;
        }
        return false;
    }

    public static final <T> boolean removeAll(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return $receiver.removeAll(CollectionsKt.convertToSetForSetOperationWith(elements, (Iterable)$receiver));
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void removeAll(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        $receiver.removeAll(CollectionsKt.convertToSetForSetOperationWith(elements, (Iterable)$receiver));
    }

    public static final <T> boolean removeAll(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        HashSet<? extends T> set = SequencesKt.toHashSet(elements);
        return CollectionsKt.isNotEmpty((Collection)set) && $receiver.removeAll((Collection)set);
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void removeAll(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        HashSet<? extends T> set = SequencesKt.toHashSet(elements);
        if (CollectionsKt.isNotEmpty((Collection)set)) {
            $receiver.removeAll((Collection)set);
        }
    }

    public static final <T> boolean removeAll(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return ArraysKt.isNotEmpty(elements) && $receiver.removeAll((Collection)ArraysKt.toHashSet(elements));
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void removeAll(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        if (ArraysKt.isNotEmpty(elements)) {
            $receiver.removeAll((Collection)ArraysKt.toHashSet(elements));
        }
    }

    public static final <T> boolean retainAll(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return $receiver.retainAll(CollectionsKt.convertToSetForSetOperationWith(elements, (Iterable)$receiver));
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void retainAll(Collection<? super T> $receiver, @NotNull Iterable<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        $receiver.retainAll(CollectionsKt.convertToSetForSetOperationWith(elements, (Iterable)$receiver));
    }

    public static final <T> boolean retainAll(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        if (ArraysKt.isNotEmpty(elements)) {
            return $receiver.retainAll((Collection)ArraysKt.toHashSet(elements));
        }
        return CollectionsKt__MutableCollectionsKt.retainNothing($receiver);
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void retainAll(Collection<? super T> $receiver, @NotNull T[] elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        if (ArraysKt.isNotEmpty(elements)) {
            $receiver.retainAll((Collection)ArraysKt.toHashSet(elements));
        } else {
            $receiver.clear();
        }
    }

    public static final <T> boolean retainAll(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        HashSet<? extends T> set = SequencesKt.toHashSet(elements);
        if (CollectionsKt.isNotEmpty((Collection)set)) {
            return $receiver.retainAll((Collection)set);
        }
        return CollectionsKt__MutableCollectionsKt.retainNothing($receiver);
    }

    @Deprecated(message="Provided for binary compatibility", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ <T> void retainAll(Collection<? super T> $receiver, @NotNull Sequence<? extends T> elements) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        HashSet<? extends T> set = SequencesKt.toHashSet(elements);
        if (CollectionsKt.isNotEmpty((Collection)set)) {
            $receiver.retainAll((Collection)set);
        } else {
            $receiver.clear();
        }
    }

    private static final boolean retainNothing(Collection<?> $receiver) {
        boolean result = CollectionsKt.isNotEmpty($receiver);
        $receiver.clear();
        return result;
    }

    public static final <T extends Comparable<? super T>> void sort(List<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.size() > 1) {
            Collections.sort($receiver);
        }
    }

    public static final <T> void sortWith(List<T> $receiver, @NotNull Comparator<? super T> comparator2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(comparator2, "comparator");
        if ($receiver.size() > 1) {
            Collections.sort($receiver, comparator2);
        }
    }
}

