/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessWrapper;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.commandLine.TerminalExecutor;
import org.jetbrains.idea.svn.commandLine.WinTerminalProcessHandler;

public class WinTerminalExecutor
extends TerminalExecutor {
    private static final int TERMINAL_WINDOW_MAX_COLUMNS = 480;
    @Nullable
    private File myRedirectFile;
    @Nullable
    private FileInputStream myRedirectStream;

    public WinTerminalExecutor(@NotNull @NonNls String exePath, @NotNull String locale, @NotNull Command command) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "<init>"));
        }
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "<init>"));
        }
        super(exePath, locale, command);
    }

    @Override
    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        WinTerminalProcessHandler winTerminalProcessHandler = new WinTerminalProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString(), this.needsUtf8Output(), this.needsBinaryOutput());
        if (winTerminalProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "createProcessHandler"));
        }
        return winTerminalProcessHandler;
    }

    @Override
    protected void beforeCreateProcess() throws SvnBindException {
        super.beforeCreateProcess();
        this.createRedirectFile();
    }

    private void createRedirectFile() throws SvnBindException {
        this.myRedirectFile = WinTerminalExecutor.createTempFile("terminal-output", "");
        try {
            this.myRedirectStream = new FileInputStream(this.myRedirectFile);
        }
        catch (FileNotFoundException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteRedirectFile();
    }

    private void deleteRedirectFile() {
        if (this.myRedirectStream != null) {
            try {
                this.myRedirectStream.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        WinTerminalExecutor.deleteTempFile(this.myRedirectFile);
    }

    @Override
    @NotNull
    protected Process createProcess() throws ExecutionException {
        this.checkRedirectFile();
        List<String> parameters = this.escapeArguments(this.buildParameters());
        parameters.add(0, ExecUtil.getWindowsShellName());
        parameters.add(1, "/c");
        parameters.add(">>");
        parameters.add(WinTerminalExecutor.quote(this.myRedirectFile.getAbsolutePath()));
        Process process = this.createProcess(parameters);
        ProcessWrapper processWrapper = new ProcessWrapper(process){

            public InputStream getInputStream() {
                return WinTerminalExecutor.this.myRedirectStream;
            }

            public InputStream getErrorStream() {
                return this.getOriginalProcess().getInputStream();
            }
        };
        if (processWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "createProcess"));
        }
        return processWrapper;
    }

    private void checkRedirectFile() {
        if (this.myRedirectFile == null) {
            throw new IllegalStateException("No redirect file found");
        }
        if (this.myRedirectStream == null) {
            throw new IllegalStateException("No redirect stream found");
        }
    }

    @Override
    @NotNull
    protected List<String> escapeArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "escapeArguments"));
        }
        List list = ContainerUtil.map(arguments, (Function)new Function<String, String>(){

            public String fun(String argument) {
                return WinTerminalExecutor.needQuote(argument) && !WinTerminalExecutor.isQuoted(argument) ? WinTerminalExecutor.quote(argument) : argument;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "escapeArguments"));
        }
        return list;
    }

    @NotNull
    private static String quote(@NotNull String argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "quote"));
        }
        String string = StringUtil.wrapWithDoubleQuote((String)argument);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "quote"));
        }
        return string;
    }

    private static boolean needQuote(@NotNull String argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "needQuote"));
        }
        return argument.contains(" ");
    }

    private static boolean isQuoted(@NotNull String argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/idea/svn/commandLine/WinTerminalExecutor", "isQuoted"));
        }
        return StringUtil.startsWithChar((CharSequence)argument, (char)'\"') && StringUtil.endsWithChar((CharSequence)argument, (char)'\"');
    }

    static {
        if (SystemInfo.isWindows) {
            System.setProperty("win.pty.cols", String.valueOf(480));
        }
    }
}

