/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HorizontalRuleMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tA\u0002\u0001\t\n3\u0011I!!C\u0001\u0019\u0003a\u0005Q\u0014A\u0005\"\u0006E\u001b\u0011\u0001c\u0001&+\u0011Y\u0001BA\u0007\u0005\u0013\tI\u0011\u0001G\u0002\u0019\u0006e)\u0001rA\u0007\u00041\u0011I\u0013\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u00063\rAa!D\u0001\u0019\u0003\u0015rAa\u0003E\u0007\u001b\u0005Ar!G\u0003\t\b5\u0019\u0001\u0004B\u0015\u00021\u0013I2\u0001c\u0004\u000e\u0003aAQ%\u0004E\t\u001b\u0005Ar!G\u0003\t\b5\u0019\u0001\u0004B\u0015\u00021\u0013I2\u0001c\u0004\u000e\u0003aA\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/HorizontalRuleProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Companion"}, moduleName="intellij-markdown")
public final class HorizontalRuleProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    public static final Companion Companion = org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider$Companion.INSTANCE;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (this.matches(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.listOf((Object)new HorizontalRuleMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.matches(pos, constraints);
    }

    public final boolean matches(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return false;
        }
        return Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine());
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u001b)\u0001!B\u0001\t\t\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"A\u0013\f\u0011\u0007i\u0011\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u00043\rA9!D\u0001\u0019\t\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/HorizontalRuleProvider$Companion;", "", "()V", "isHorizontalRule", "", "line", "", "offset", ""}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isHorizontalRule(@NotNull CharSequence line, int offset) {
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Character hrChar = null;
            int startSpace = 0;
            int charCount = 1;
            int n = offset;
            int n2 = line.length() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    char c = line.charAt((int)i);
                    if (hrChar == null) {
                        if (c == '*' || c == '-' || c == '_') {
                            hrChar = Character.valueOf(c);
                        } else {
                            if (startSpace >= 3) return false;
                            if (c != ' ') return false;
                            ++startSpace;
                        }
                    } else if (Intrinsics.areEqual((Object)Character.valueOf(c), (Object)hrChar)) {
                        ++charCount;
                    } else if (c != ' ' && c != '\t') {
                        return false;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (charCount < 3) return false;
            return true;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

