/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KotlinLightTypeParameterListBuilder;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightElement;
import org.jetbrains.kotlin.asJava.KtLightField;
import org.jetbrains.kotlin.asJava.KtLightMethod;
import org.jetbrains.kotlin.asJava.KtLightTypeParameter;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"{\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!9\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\u001e\u0002a\t;\u0001B\u0001R\u0007\u0005A\u0011!J\u0006\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u0005K\u001dAI!D\u0001\u0019\u000be\u0019\u0001rA\u0007\u00021\u0011)#\u0003B\u0001\t\f5\t\u0001DB\r\u0004\u0011\u001bi\u0011\u0001\u0007\u0003\u001a\t!9QB\u0001G\u00011\u001fIB\u0001\u0003\u0005\u000e\u00051\u0005\u0001tB\u0013\u000f\u0011#i!\u0001$\u0001\u0019\u0013e\u0019\u00012C\u0007\u00021)IR\u0001#\u0006\u000e\u0007%\tA1\u0001\r\fK!A9\"\u0004\u0002\r\u0002a=\u0011d\u0001\u0005\r\u001b\u0005AJ\"\n\u0006\t\u001b5!\u0011BA\u0005\u00021\u001fAZ\"G\u0002\t\u00195\t\u0001\u0014D\u0013\n\t\u0005Aa\"\u0004\u0002\r\u0002au\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0005\t\u001f5\u0011A\u0012\u0001M\b3\rAy\"D\u0001\u0019!\u0015R\u0001\u0012E\u0007\u0005\u0013\tI\u0011\u0001g\u0004\u0019\u001ce\u0019\u0001rD\u0007\u00021A)s\u0001C\t\u000e\u0003a1\u0011d\u0001E\u0012\u001b\u0005A\"#J\u0004\t#5\t\u0001DB\r\u0004\u0011Ki\u0011\u0001G\n&\u0011!\u001dRB\u0001G\u00011;I2\u0001\u0003\u000b\u000e\u0003a%R%\u0003\u0005\u0016\u001b\ta\t\u0001G\u0005\u001a\t!-RB\u0001G\u00011S)\u0013\u0002B\u0001\t-5\u0011A\u0012\u0001M\b3\rA9!D\u0001\u0019\t\u0015zA!\u0001E\u0017\u001b\u0011I!!C\u0001\u0019\u0010am\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t/5\t\u0001$B\u0013\n\t\u0005Ay#\u0004\u0002\r\u0002aI\u0011d\u0001E\u0004\u001b\u0005AB\u0001"}, strings={"Lorg/jetbrains/kotlin/asJava/LightClassUtil;", "", "()V", "buildLightTypeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "owner", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canGenerateLightClass", "", "extractPropertyAccessors", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "ktDeclaration", "specialGetter", "Lcom/intellij/psi/PsiMethod;", "specialSetter", "findClass", "Lcom/intellij/psi/PsiClass;", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "stub", "Lcom/intellij/psi/stubs/StubElement;", "getLightClassAccessorMethod", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLightClassAccessorMethods", "", "getLightClassBackingField", "Lcom/intellij/psi/PsiField;", "getLightClassMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getLightClassMethods", "getLightClassPropertyMethods", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getLightFieldForCompanionObject", "companionObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getPsiClass", "classOrObject", "getPsiMethodWrapper", "getPsiMethodWrappers", "collectAll", "getWrappingClass", "PropertyAccessorsPsiMethods"}, moduleName="kotlin-compiler")
public final class LightClassUtil {
    public static final LightClassUtil INSTANCE;
    public static final LightClassUtil INSTANCE$;

    @Nullable
    public final PsiClass findClass(@NotNull FqName fqn, @NotNull StubElement<?> stub) {
        Intrinsics.checkParameterIsNotNull(fqn, "fqn");
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        if (stub instanceof PsiClassStub && Comparing.equal(fqn.asString(), ((PsiClassStub)stub).getQualifiedName())) {
            return (PsiClass)((PsiClassStub)stub).getPsi();
        }
        if (stub instanceof PsiClassStub || stub instanceof PsiFileStub) {
            Iterator<StubElement> iterator2 = stub.getChildrenStubs().iterator();
            while (iterator2.hasNext()) {
                StubElement child;
                StubElement stubElement = child = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(stubElement, "child");
                PsiClass answer = this.findClass(fqn, stubElement);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public final PsiClass getPsiClass(@Nullable KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            return null;
        }
        return LightClassGenerationSupport.getInstance(classOrObject.getProject()).getPsiClass(classOrObject);
    }

    @Nullable
    public final PsiMethod getLightClassAccessorMethod(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkParameterIsNotNull(accessor, "accessor");
        return CollectionsKt.firstOrNull(this.getLightClassAccessorMethods(accessor));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiMethod> getLightClassAccessorMethods(@NotNull KtPropertyAccessor accessor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(accessor, "accessor");
        PsiElement $receiver$iv2 = accessor;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($receiver$iv2, KtProperty.class, false);
        if (ktProperty == null) {
            return CollectionsKt.emptyList();
        }
        KtProperty property = ktProperty;
        List<PsiMethod> wrappers = this.getPsiMethodWrappers(property, true);
        Iterable $i$f$getNonStrictParentOfType = wrappers;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod wrapper = (PsiMethod)element$iv$iv;
            if (!(accessor.isGetter() && !JvmAbi.isSetterName(wrapper.getName()) || accessor.isSetter() && JvmAbi.isSetterName(wrapper.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiField getLightFieldForCompanionObject(@NotNull KtClassOrObject companionObject) {
        Intrinsics.checkParameterIsNotNull(companionObject, "companionObject");
        PsiClass outerPsiClass = this.getWrappingClass(companionObject);
        if (outerPsiClass != null) {
            PsiField[] psiFieldArray = outerPsiClass.getFields();
            for (int i = 0; i < psiFieldArray.length; ++i) {
                PsiField fieldOfParent = psiFieldArray[i];
                if (!(fieldOfParent instanceof KtLightElement) || ((KtLightElement)((Object)fieldOfParent)).getOrigin() != companionObject) continue;
                return fieldOfParent;
            }
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        KtPropertyAccessor getter = property.getGetter();
        KtPropertyAccessor setter = property.getSetter();
        PsiMethod getterWrapper = getter != null ? this.getLightClassAccessorMethod(getter) : (PsiMethod)null;
        PsiMethod setterWrapper = setter != null ? this.getLightClassAccessorMethod(setter) : (PsiMethod)null;
        return this.extractPropertyAccessors(property, getterWrapper, setterWrapper);
    }

    private final PsiField getLightClassBackingField(KtDeclaration declaration) {
        PsiClass containingLightClass;
        KtClass containingClass;
        KtClassOrObject origin;
        PsiClass psiClass = this.getWrappingClass(declaration);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 instanceof KtLightClass && (origin = (KtClassOrObject)((KtLightClass)psiClass2).getOrigin()) instanceof KtObjectDeclaration && ((KtObjectDeclaration)origin).isCompanion() && (containingClass = PsiTreeUtil.getParentOfType((PsiElement)origin, KtClass.class)) != null && (containingLightClass = this.getPsiClass(containingClass)) != null) {
            psiClass2 = containingLightClass;
        }
        PsiField[] psiFieldArray = psiClass2.getFields();
        for (int i = 0; i < psiFieldArray.length; ++i) {
            PsiField field = psiFieldArray[i];
            if (!(field instanceof KtLightField) || ((KtLightField)field).getOrigin() != declaration) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.extractPropertyAccessors(parameter, null, null);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        return this.getPsiMethodWrapper(function);
    }

    @NotNull
    public final List<PsiMethod> getLightClassMethods(@NotNull KtFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        return this.getPsiMethodWrappers(function, true);
    }

    private final PsiMethod getPsiMethodWrapper(KtDeclaration declaration) {
        return CollectionsKt.firstOrNull(this.getPsiMethodWrappers(declaration, false));
    }

    private final List<PsiMethod> getPsiMethodWrappers(KtDeclaration declaration, boolean collectAll) {
        PsiClass psiClass = this.getWrappingClass(declaration);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass psiClass2 = psiClass;
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        for (PsiMethod psiMethod : ArraysKt.asList((Object[])psiClass2.getMethods())) {
            try {
                if (!(psiMethod instanceof KtLightMethod) || ((KtLightMethod)psiMethod).getOrigin() != declaration) continue;
                methods.add(psiMethod);
                if (collectAll) continue;
                return methods;
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                throw (Throwable)new IllegalStateException("Error while wrapping declaration " + declaration.getName() + "Context\n:" + psiMethod, e);
            }
        }
        return methods;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiClass getWrappingClass(KtDeclaration declaration) {
        KtClassOrObject constructorClass;
        KtDeclaration declaration2 = declaration;
        if (declaration2 instanceof KtParameter && (constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)declaration2)) != null) {
            return this.getPsiClass(constructorClass);
        }
        if (declaration2 instanceof KtPropertyAccessor) {
            Unit unit;
            PsiElement propertyParent = ((KtPropertyAccessor)declaration2).getParent();
            boolean bl = propertyParent instanceof KtProperty;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "JetProperty is expected to be parent of accessor";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            PsiElement psiElement2 = propertyParent;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            declaration2 = (KtProperty)psiElement2;
        }
        if (declaration2 instanceof KtConstructor) {
            return this.getPsiClass(((KtConstructor)declaration2).getContainingClassOrObject());
        }
        if (!this.canGenerateLightClass(declaration2)) {
            return null;
        }
        PsiElement parent2 = declaration2.getParent();
        if (parent2 instanceof KtFile) {
            FqName fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)parent2);
            Project project = declaration2.getProject();
            return JavaElementFinder.getInstance(project).findClass(fqName2.asString(), GlobalSearchScope.allScope(project));
        }
        if (parent2 instanceof KtClassBody) {
            PreconditionsKt.assert(((KtClassBody)parent2).getParent() instanceof KtClassOrObject);
            PsiElement psiElement3 = ((KtClassBody)parent2).getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            return this.getPsiClass((KtClassOrObject)psiElement3);
        }
        return null;
    }

    public final boolean canGenerateLightClass(@NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        return PsiTreeUtil.getParentOfType((PsiElement)declaration, KtFunction.class, KtProperty.class) == null;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyAccessorsPsiMethods extractPropertyAccessors(KtDeclaration ktDeclaration, PsiMethod specialGetter, PsiMethod specialSetter) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        PsiMethod getterWrapper = specialGetter;
        PsiMethod setterWrapper = specialSetter;
        ArrayList<PsiMethod> additionalAccessors = CollectionsKt.arrayListOf(new PsiMethod[0]);
        Iterable iterable = this.getPsiMethodWrappers(ktDeclaration, true);
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            if (!(JvmAbi.isGetterName(it.getName()) || JvmAbi.isSetterName(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List wrappers = (List)destination$iv$iv;
        for (PsiMethod wrapper : wrappers) {
            if (JvmAbi.isSetterName(wrapper.getName())) {
                if (setterWrapper == null || setterWrapper == specialSetter) {
                    setterWrapper = wrapper;
                    continue;
                }
                additionalAccessors.add(wrapper);
                continue;
            }
            if (getterWrapper == null || Intrinsics.areEqual(getterWrapper, specialGetter)) {
                getterWrapper = wrapper;
                continue;
            }
            additionalAccessors.add(wrapper);
        }
        PsiField backingField = this.getLightClassBackingField(ktDeclaration);
        return new PropertyAccessorsPsiMethods(getterWrapper, setterWrapper, backingField, (List<? extends PsiMethod>)additionalAccessors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiTypeParameterList buildLightTypeParameterList(@NotNull PsiTypeParameterListOwner owner, @NotNull KtDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        PsiManager psiManager = owner.getManager();
        Intrinsics.checkExpressionValueIsNotNull(psiManager, "owner.manager");
        KotlinLightTypeParameterListBuilder builder = new KotlinLightTypeParameterListBuilder(psiManager);
        if (declaration instanceof KtTypeParameterListOwner) {
            int n;
            List<KtTypeParameter> parameters2 = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            IntRange intRange = CollectionsKt.getIndices((Collection)parameters2);
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    KtTypeParameter jetTypeParameter;
                    String name;
                    String string;
                    if ((string = (name = (jetTypeParameter = parameters2.get((int)i)).getName())) == null) {
                        string = "__no_name__";
                    }
                    String safeName = string;
                    builder.addParameter(new KtLightTypeParameter(owner, (int)i, safeName));
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return builder;
    }

    private LightClassUtil() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new LightClassUtil();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u00119)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!I!B\u0001\t)1\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001\"2%!\u00012A\u0007\u0003\u0019\u0003A\u0012!\u0003\u0003\t\u00055\u0011A\u0012\u0001\r\u0002\u0013\u0011A)!\u0004\u0002\r\u0002a\u0019\u0011B\u0002E\u0004\u001b\u0011I!!C\u0001\u0019\u0003a!\u0011kA\u0001\t\n\u0015>Aa\u0013\u0003\t\u00155!\u0011BA\u0005\u00021\u0005A*\"K\u0007\u0005\u0007\"AQ!\u0004\u0003\n\u0005%\t\u00014\u0002\r\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0019Ai!\u000b\u0006\u0005\u0003\"Aq!\u0004\u0003\n\u0005%\t\u0001$\u0001\r\u0005#\u000e\tQ\u0001A\u0015\f\t\rC\u0001RA\u0007\u0003\u0019\u0003A2!U\u0002\u0005\u000b\u0001i!\u0001b\u0004\t\u0011%ZAa\u0011\u0005\t\u00045\u0011A\u0012\u0001\r\u0002#\u000e!Q\u0001A\u0007\u0003\t#A\u0011\"K\u0006\u0005\u0007\"A!!\u0004\u0002\r\u0002a\t\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0003\u0005\n"}, strings={"Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "", "Lcom/intellij/psi/PsiMethod;", "getter", "setter", "backingField", "Lcom/intellij/psi/PsiField;", "additionalAccessors", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiField;Ljava/util/List;)V", "allDeclarations", "Lcom/intellij/psi/PsiNamedElement;", "getAllDeclarations", "()Ljava/util/List;", "allMethods", "getBackingField", "()Lcom/intellij/psi/PsiField;", "getGetter", "()Lcom/intellij/psi/PsiMethod;", "getSetter", "iterator", ""}, moduleName="kotlin-compiler")
    public static final class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod>,
    KMappedMarker {
        private final List<PsiMethod> allMethods;
        @NotNull
        private final List<PsiNamedElement> allDeclarations;
        @Nullable
        private final PsiMethod getter;
        @Nullable
        private final PsiMethod setter;
        @Nullable
        private final PsiField backingField;

        @NotNull
        public final List<PsiNamedElement> getAllDeclarations() {
            return this.allDeclarations;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            return this.allMethods.iterator();
        }

        @Nullable
        public final PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public final PsiMethod getSetter() {
            return this.setter;
        }

        @Nullable
        public final PsiField getBackingField() {
            return this.backingField;
        }

        /*
         * WARNING - void declaration
         */
        public PropertyAccessorsPsiMethods(@Nullable PsiMethod getter, @Nullable PsiMethod setter, @Nullable PsiField backingField, @NotNull List<? extends PsiMethod> additionalAccessors) {
            PsiNamedElement[] $receiver$iv;
            Iterable elements$iv;
            Intrinsics.checkParameterIsNotNull(additionalAccessors, "additionalAccessors");
            this.getter = getter;
            this.setter = setter;
            this.backingField = backingField;
            this.allMethods = CollectionsKt.arrayListOf(new PsiMethod[0]);
            PsiMethod[] psiMethodArray = new PsiMethod[]{this.getter, this.setter};
            ArraysKt.filterNotNullTo((Object[])elements$iv, (Collection)this.allMethods);
            elements$iv = additionalAccessors;
            Collection $i$f$arrayOf = this.allMethods;
            for (Object t : $receiver$iv) {
                void destination$iv;
                if (!(t instanceof PsiMethod)) continue;
                destination$iv.add(t);
            }
            this.allDeclarations = CollectionsKt.arrayListOf(new PsiNamedElement[0]);
            $receiver$iv = new PsiNamedElement[]{this.getter, this.setter, this.backingField};
            ArraysKt.filterNotNullTo((Object[])elements$iv, (Collection)this.allDeclarations);
            ((ArrayList)this.allDeclarations).addAll((Collection)additionalAccessors);
        }
    }
}

