/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class WhenChecker {
    private WhenChecker() {
    }

    public static boolean mustHaveElse(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "mustHaveElse"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "mustHaveElse"));
        }
        return !BindingContextUtilsKt.isUsedAsStatement(expression, trace.getBindingContext()) && !WhenChecker.isWhenExhaustive(expression, trace);
    }

    public static boolean isWhenByEnum(@NotNull KtWhenExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenByEnum"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenByEnum"));
        }
        return WhenChecker.getClassDescriptorOfTypeIfEnum(WhenChecker.whenSubjectType(expression, context)) != null;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor == null) {
            return null;
        }
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        return classDescriptor;
    }

    @Nullable
    private static KotlinType whenSubjectType(@NotNull KtWhenExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "whenSubjectType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "whenSubjectType"));
        }
        KtExpression subjectExpression = expression.getSubjectExpression();
        return subjectExpression == null ? null : context.getType(subjectExpression);
    }

    private static boolean isWhenOnBooleanExhaustive(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnBooleanExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnBooleanExhaustive"));
        }
        boolean containsFalse = false;
        boolean containsTrue = false;
        for (KtWhenEntry whenEntry : expression.getEntries()) {
            for (KtWhenCondition whenCondition : whenEntry.getConditions()) {
                if (!(whenCondition instanceof KtWhenConditionWithExpression)) continue;
                KtExpression whenExpression = ((KtWhenConditionWithExpression)whenCondition).getExpression();
                if (CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, trace, true)) {
                    containsTrue = true;
                }
                if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, trace, false)) continue;
                containsFalse = true;
            }
        }
        return containsFalse && containsTrue;
    }

    public static boolean isWhenOnEnumExhaustive(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace, @NotNull ClassDescriptor enumClassDescriptor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        if (enumClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        assert (DescriptorUtils.isEnumClass(enumClassDescriptor)) : "isWhenOnEnumExhaustive should be called with an enum class descriptor";
        HashSet<ClassDescriptor> entryDescriptors = new HashSet<ClassDescriptor>();
        for (DeclarationDescriptor descriptor2 : DescriptorUtils.getAllDescriptors(enumClassDescriptor.getUnsubstitutedInnerClassesScope())) {
            if (!DescriptorUtils.isEnumEntry(descriptor2)) continue;
            entryDescriptors.add((ClassDescriptor)descriptor2);
        }
        return !entryDescriptors.isEmpty() && WhenChecker.containsAllClassCases(expression, entryDescriptors, trace);
    }

    private static void collectNestedSubclasses(@NotNull ClassDescriptor baseDescriptor, @NotNull ClassDescriptor currentDescriptor, @NotNull Set<ClassDescriptor> subclasses) {
        if (baseDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "collectNestedSubclasses"));
        }
        if (currentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "collectNestedSubclasses"));
        }
        if (subclasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subclasses", "org/jetbrains/kotlin/cfg/WhenChecker", "collectNestedSubclasses"));
        }
        for (DeclarationDescriptor descriptor2 : DescriptorUtils.getAllDescriptors(currentDescriptor.getUnsubstitutedInnerClassesScope())) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassDescriptor memberClassDescriptor = (ClassDescriptor)descriptor2;
            if (DescriptorUtils.isDirectSubclass(memberClassDescriptor, baseDescriptor)) {
                subclasses.add(memberClassDescriptor);
            }
            WhenChecker.collectNestedSubclasses(baseDescriptor, memberClassDescriptor, subclasses);
        }
    }

    private static boolean isWhenOnSealedClassExhaustive(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnSealedClassExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnSealedClassExhaustive"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnSealedClassExhaustive"));
        }
        assert (classDescriptor.getModality() == Modality.SEALED) : "isWhenOnSealedClassExhaustive should be called with a sealed class descriptor";
        HashSet<ClassDescriptor> memberClassDescriptors = new HashSet<ClassDescriptor>();
        WhenChecker.collectNestedSubclasses(classDescriptor, classDescriptor, memberClassDescriptors);
        return !memberClassDescriptors.isEmpty() && WhenChecker.containsAllClassCases(expression, memberClassDescriptors, trace);
    }

    private static boolean isNullableTypeWithoutPossibleSmartCast(@Nullable KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext context) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/cfg/WhenChecker", "isNullableTypeWithoutPossibleSmartCast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "isNullableTypeWithoutPossibleSmartCast"));
        }
        if (expression == null) {
            return false;
        }
        if (!TypeUtils.isNullableType(type2)) {
            return false;
        }
        return context.get(BindingContext.SMARTCAST, expression) == null;
    }

    public static boolean isWhenExhaustive(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace) {
        ClassDescriptor classDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenExhaustive"));
        }
        KotlinType type2 = WhenChecker.whenSubjectType(expression, trace.getBindingContext());
        if (type2 == null) {
            return false;
        }
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        boolean exhaustive = enumClassDescriptor == null ? (KotlinBuiltIns.isBoolean(TypeUtils.makeNotNullable(type2)) ? WhenChecker.isWhenOnBooleanExhaustive(expression, trace) : (classDescriptor = TypeUtils.getClassDescriptor(type2)) != null && classDescriptor.getModality() == Modality.SEALED && WhenChecker.isWhenOnSealedClassExhaustive(expression, trace, classDescriptor)) : WhenChecker.isWhenOnEnumExhaustive(expression, trace, enumClassDescriptor);
        if (exhaustive && (enumClassDescriptor != null && FlexibleTypesKt.isFlexible(type2) || WhenChecker.containsNullCase(expression, trace) || !WhenChecker.isNullableTypeWithoutPossibleSmartCast(expression.getSubjectExpression(), type2, trace.getBindingContext()))) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression);
            return true;
        }
        return false;
    }

    private static boolean containsAllClassCases(@NotNull KtWhenExpression whenExpression, @NotNull Set<ClassDescriptor> memberDescriptors, @NotNull BindingTrace trace) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/cfg/WhenChecker", "containsAllClassCases"));
        }
        if (memberDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptors", "org/jetbrains/kotlin/cfg/WhenChecker", "containsAllClassCases"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "containsAllClassCases"));
        }
        HashSet<ClassDescriptor> checkedDescriptors = new HashSet<ClassDescriptor>();
        for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
            for (KtWhenCondition condition : whenEntry.getConditions()) {
                DeclarationDescriptor target;
                KtSimpleNameExpression reference;
                KtWhenConditionWithExpression conditionWithExpression;
                boolean negated = false;
                ClassDescriptor checkedDescriptor = null;
                if (condition instanceof KtWhenConditionIsPattern) {
                    KtWhenConditionIsPattern conditionIsPattern = (KtWhenConditionIsPattern)condition;
                    KotlinType checkedType = trace.get(BindingContext.TYPE, conditionIsPattern.getTypeReference());
                    if (checkedType != null) {
                        checkedDescriptor = TypeUtils.getClassDescriptor(checkedType);
                    }
                    negated = conditionIsPattern.isNegated();
                } else if (condition instanceof KtWhenConditionWithExpression && (conditionWithExpression = (KtWhenConditionWithExpression)condition).getExpression() != null && (reference = WhenChecker.getReference(conditionWithExpression.getExpression())) != null && (target = trace.get(BindingContext.REFERENCE_TARGET, reference)) instanceof ClassDescriptor) {
                    checkedDescriptor = (ClassDescriptor)target;
                }
                if (checkedDescriptor == null || !memberDescriptors.contains(checkedDescriptor) || condition instanceof KtWhenConditionWithExpression && !DescriptorUtils.isObject(checkedDescriptor) && !DescriptorUtils.isEnumEntry(checkedDescriptor)) continue;
                if (negated) {
                    if (checkedDescriptors.contains(checkedDescriptor)) {
                        return true;
                    }
                    checkedDescriptors.addAll(memberDescriptors);
                    checkedDescriptors.remove(checkedDescriptor);
                    continue;
                }
                checkedDescriptors.add(checkedDescriptor);
            }
        }
        return checkedDescriptors.containsAll(memberDescriptors);
    }

    public static boolean containsNullCase(@NotNull KtWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "containsNullCase"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "containsNullCase"));
        }
        for (KtWhenEntry entry : expression.getEntries()) {
            for (KtWhenCondition condition : entry.getConditions()) {
                KotlinType type2;
                KtWhenConditionWithExpression conditionWithExpression;
                if (!(condition instanceof KtWhenConditionWithExpression) || (conditionWithExpression = (KtWhenConditionWithExpression)condition).getExpression() == null || (type2 = trace.getBindingContext().getType(conditionWithExpression.getExpression())) == null || !KotlinBuiltIns.isNothingOrNullableNothing(type2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static KtSimpleNameExpression getReference(@Nullable KtExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof KtSimpleNameExpression) {
            return (KtSimpleNameExpression)expression;
        }
        if (expression instanceof KtQualifiedExpression) {
            return WhenChecker.getReference(((KtQualifiedExpression)expression).getSelectorExpression());
        }
        return null;
    }

    public static void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "checkDeprecatedWhenSyntax"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "checkDeprecatedWhenSyntax"));
        }
        if (expression.getSubjectExpression() != null) {
            return;
        }
        block0: for (KtWhenEntry entry : expression.getEntries()) {
            if (entry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNode().getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                if (child.getNode().getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public static void checkReservedPrefix(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "checkReservedPrefix"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "checkReservedPrefix"));
        }
        KtPsiUtilKt.checkReservedPrefixWord(trace, expression.getWhenKeyword(), "sealed", TokenSet.EMPTY, "sealed when");
    }
}

