/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"3\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\t\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001E\u0006\u000b\u0001i\u0001\u0006\u0003\u0001\u000e\u0003a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\u00055\t\u00014A\r\u0006\t\u0005A)!\u0004\u0002\r\u0002a\r\u0011$\u0002\u0003\u0002\u0011\ri!\u0001$\u0001\u0019\u0004eu\u0001rAG\r\u0013\tI\u0011\u0001'\u0001\n\u0005%\t\u0001\u0014B\u0005\u0003\u0013\u0005AR\u0001\u0007\u0003R\u0007\u0005!Y\u0001V\u0002\u0007\u001baAi!D\u0001\u0019\u0002e\u0019\u0001bB\u0007\u00021\u001fIj\u0002\u0003\u0005\u000e\u001a%\u0011\u0011\"\u0001M\u0001\u0013\tI\u0011\u0001'\u0003\n\u0005%\t\u0001$\u0002\r\u0005#\u000e\tA1\u0002+\u0004\r5I\u0003\u0012C\u0007\u00021\u0003I2\u0001C\u0004\u000e\u0003a=\u0011$\u0002\u0003\u0002\u0011%i!\u0001$\u0001\u0019\u0004e!A!\u0001E\n\u001b\u0005A\"\"G\u0003\u0005\u0003!UQB\u0001G\u00011\u0007Ij\u0002\u0003\u0005\u000e\u001a%\u0011\u0011\"\u0001M\u0001\u0013\tI\u0011\u0001'\u0003\n\u0005%\t\u0001$\u0002\r\u0005#\u000e\tA1\u0002+\u0004\r\u0001"}, strings={"createBinaryIntrinsicCallable", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicCallable;", "returnType", "Lorg/jetbrains/org/objectweb/asm/Type;", "valueParameterType", "thisType", "receiverType", "lambda", "Lkotlin/Function2;", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "", "Lkotlin/Extension;", "IntrinsicCallableKt", "createIntrinsicCallable", "callable", "Lorg/jetbrains/kotlin/codegen/CallableMethod;", "invoke", "createUnaryIntrinsicCallable", "newReturnType", "needPrimitiveCheck", "", "newThisType"}, moduleName="kotlin-compiler")
public final class IntrinsicCallableKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IntrinsicCallable createBinaryIntrinsicCallable(@NotNull Type returnType2, @NotNull Type valueParameterType, @Nullable Type thisType, @Nullable Type receiverType, @NotNull Function2<? super IntrinsicCallable, ? super InstructionAdapter, Unit> lambda2) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(returnType2, "returnType");
        Intrinsics.checkParameterIsNotNull(valueParameterType, "valueParameterType");
        Intrinsics.checkParameterIsNotNull(lambda2, "lambda");
        boolean bl = AsmUtil.isPrimitive(returnType2);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "Return type of BinaryOp intrinsic should be of primitive type: " + returnType2;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return new IntrinsicCallable(lambda2, returnType2, CollectionsKt.listOf(valueParameterType), thisType, receiverType){
            final /* synthetic */ Function2 $lambda;

            public void invokeIntrinsic(@NotNull InstructionAdapter v) {
                Intrinsics.checkParameterIsNotNull(v, "v");
                this.$lambda.invoke(this, v);
            }
            {
                this.$lambda = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, null, 16, null);
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IntrinsicCallable createBinaryIntrinsicCallable$default(Type type2, Type type3, Type type4, Type type5, Function2 function2, int n) {
        if ((n & 4) != 0) {
            type4 = null;
        }
        if ((n & 8) != 0) {
            type5 = null;
        }
        return IntrinsicCallableKt.createBinaryIntrinsicCallable(type2, type3, type4, type5, function2);
    }

    @NotNull
    public static final IntrinsicCallable createUnaryIntrinsicCallable(@NotNull CallableMethod callable, @Nullable Type newReturnType, boolean needPrimitiveCheck, @Nullable Type newThisType, @NotNull Function2<? super IntrinsicCallable, ? super InstructionAdapter, Unit> invoke2) {
        Unit unit;
        boolean value$iv;
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(invoke2, "invoke");
        Type type2 = newReturnType;
        if (type2 == null) {
            type2 = callable.getReturnType();
        }
        List<Type> list = callable.getValueParameterTypes();
        Type type3 = newThisType;
        if (type3 == null) {
            type3 = callable.getDispatchReceiverType();
        }
        IntrinsicCallable intrinsic = new IntrinsicCallable(type2, list, type3, callable.getExtensionReceiverType(), invoke2);
        boolean bl = intrinsic.getValueParameterTypes().isEmpty();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Unary operation should not have any parameters";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (needPrimitiveCheck) {
            Unit unit2;
            value$iv = AsmUtil.isPrimitive(intrinsic.getReturnType());
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value$iv) {
                    String message$iv = "Return type of UnaryPlus intrinsic should be of primitive type: " + intrinsic.getReturnType();
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
        }
        return intrinsic;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IntrinsicCallable createUnaryIntrinsicCallable$default(CallableMethod callableMethod, Type type2, boolean bl, Type type3, Function2 function2, int n) {
        if ((n & 2) != 0) {
            type2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            type3 = null;
        }
        return IntrinsicCallableKt.createUnaryIntrinsicCallable(callableMethod, type2, bl, type3, function2);
    }

    @NotNull
    public static final IntrinsicCallable createIntrinsicCallable(@NotNull CallableMethod callable, @NotNull Function2<? super IntrinsicCallable, ? super InstructionAdapter, Unit> invoke2) {
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(invoke2, "invoke");
        return new IntrinsicCallable(callable, invoke2);
    }
}

