/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u0001\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u001f\u0015\tA\"A\u0003\u0001\u000b\u0005Aa\"\u0002\u0001\u0006\u0003!9Aa\u0003\u0007\u00013\u0005A\n!)\u0007\n\u0007!\tQ\"\u0001M\u0002\u0013\u0015A!!D\u0002\n\u0003\u0011\r\u0001TA)\u0004\u0003!\u0019Q\u0005\u0003\u0003\u000b\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0007K9!\u0011\u0001#\u0004\u000e\u0003a)\u0011$\u0002\u0005\u0003\u001b\rI\u0011\u0001b\u0001\u0019\u0006e\u0019\u00012B\u0007\u00021\u0019)3\u0002B\u0006\t\u000f5!\u0011BA\u0005\u00021!Az!G\u0002\t\f5\t\u0001DB\u0013\b\t-A\t\"\u0004\u0003\n\u0005%\t\u0001\u0004\u0003\r\nK\u0011!1\u0002c\u0005\u000e\u0003aQ\u0011\u0006\u0004\u0003D\u0011!\u0011QbA\u0005\u0002\t\u0007A*!U\u0002\u0005\u000b\u0001i!\u0001b\u0002\t\t\u0001"}, strings={"Lorg/jetbrains/kotlin/container/SingletonTypeComponentDescriptor;", "Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "klass", "Ljava/lang/Class;", "(Lorg/jetbrains/kotlin/container/ComponentContainer;Ljava/lang/Class;)V", "getKlass", "()Ljava/lang/Class;", "createInstance", "", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "createInstanceOf", "getDependencies", "", "Ljava/lang/reflect/Type;", "getRegistrations", "", "toString", ""}, moduleName="kotlin-compiler")
public class SingletonTypeComponentDescriptor
extends SingletonDescriptor {
    @NotNull
    private final Class<?> klass;

    @Override
    @NotNull
    protected Object createInstance(@NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return this.createInstanceOf(this.klass, context);
    }

    @Override
    @NotNull
    public Iterable<Type> getRegistrations() {
        return CacheKt.getInfo(this.klass).getRegistrations();
    }

    /*
     * WARNING - void declaration
     */
    private final Object createInstanceOf(Class<?> klass, ValueResolveContext context) {
        void $receiver$iv;
        ConstructorBinding binding = ResolveKt.bindToConstructor(klass, context);
        this.setState(ComponentState.Initializing);
        for (ValueDescriptor argumentDescriptor : binding.getArgumentDescriptors()) {
            if (!(argumentDescriptor instanceof Closeable) || argumentDescriptor instanceof SingletonDescriptor) continue;
            this.registerDisposableObject((Closeable)((Object)argumentDescriptor));
        }
        Constructor<?> constructor = binding.getConstructor();
        List<Object> arguments2 = ResolveKt.computeArguments(binding.getArgumentDescriptors());
        Collection collection = arguments2;
        Constructor<?> constructor2 = constructor;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v0;
        Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        Object obj = constructor2.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
        if (obj == null) {
            Intrinsics.throwNpe();
        }
        Object instance = obj;
        this.setState(ComponentState.Initialized);
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Type> getDependencies(@NotNull ValueResolveContext context) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassInfo classInfo = CacheKt.getInfo(this.klass);
        ConstructorInfo constructorInfo = classInfo.getConstructorInfo();
        Iterable iterable = classInfo.getSetterInfos();
        Collection collection = CollectionsKt.orEmpty(constructorInfo != null ? constructorInfo.getParameters() : null);
        void var4_5 = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SetterInfo it = (SetterInfo)element$iv$iv;
            Iterable list$iv$iv = it.getParameters();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus(collection, (Iterable)list);
    }

    @NotNull
    public String toString() {
        return "Singleton: " + this.klass.getSimpleName();
    }

    @NotNull
    public final Class<?> getKlass() {
        return this.klass;
    }

    public SingletonTypeComponentDescriptor(@NotNull ComponentContainer container, @NotNull Class<?> klass) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        super(container);
        this.klass = klass;
    }
}

